/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.implclasses.tree;

import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeNodeTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeOperationContext;
import org.eclipse.jubula.rc.common.implclasses.tree.TreeNodeOperation;

public class StandardDepthFirstTraverser
extends AbstractTreeNodeTraverser {
    public StandardDepthFirstTraverser(AbstractTreeOperationContext context) {
        super(context);
    }

    public void traversePath(TreeNodeOperation operation, Object startNode) throws StepExecutionException {
        operation.setContext(this.getContext());
        this.traversePath(startNode, operation);
        Object currentNode = startNode;
        while (currentNode != null) {
            Object parent = this.getContext().getParent(currentNode);
            int childIndexOfCurrentNode = this.getContext().getIndexOfChild(parent, currentNode);
            Object[] currentNodeSiblings = this.getContext().getChildren(parent);
            int i = childIndexOfCurrentNode + 1;
            while (i < currentNodeSiblings.length) {
                this.traversePath(currentNodeSiblings[i], operation);
                ++i;
            }
            currentNode = parent;
        }
    }

    private void traversePath(Object node, TreeNodeOperation operation) throws StepExecutionException {
        if (node != null) {
            this.callOperation(node, operation);
        }
        int childCount = this.getContext().getNumberOfChildren(node);
        int i = 0;
        while (i < childCount) {
            Object child = this.getContext().getChild(node, i);
            this.traversePath(child, operation);
            ++i;
        }
    }
}

