/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.core.internal.ast.models;

import com.naef.jnlua.LuaState;
import com.naef.jnlua.NamedJavaFunction;
import java.util.ArrayList;
import org.eclipse.ldt.core.internal.ast.models.api.Item;
import org.eclipse.ldt.core.internal.ast.models.common.LuaASTNode;
import org.eclipse.ldt.core.internal.ast.models.file.Block;
import org.eclipse.ldt.core.internal.ast.models.file.Call;
import org.eclipse.ldt.core.internal.ast.models.file.Identifier;
import org.eclipse.ldt.core.internal.ast.models.file.Index;
import org.eclipse.ldt.core.internal.ast.models.file.Invoke;
import org.eclipse.ldt.core.internal.ast.models.file.LocalVar;
import org.eclipse.ldt.core.internal.ast.models.file.LuaExpression;
import org.eclipse.ldt.core.internal.ast.models.file.LuaInternalContent;

public final class InternalModelFactory {
    private InternalModelFactory() {
    }

    public static final void registerInternalModelFactory(LuaState l) {
        NamedJavaFunction[] namedJavaFunctions = InternalModelFactory.createFunctions();
        l.register("javainternalmodelfactory", namedJavaFunctions);
    }

    private static NamedJavaFunction[] createFunctions() {
        ArrayList<NamedJavaFunction> javaFunctions = new ArrayList<NamedJavaFunction>();
        javaFunctions.add(InternalModelFactory.newInternalContent());
        javaFunctions.add(InternalModelFactory.newIdentifier());
        javaFunctions.add(InternalModelFactory.newIndex());
        javaFunctions.add(InternalModelFactory.newCall());
        javaFunctions.add(InternalModelFactory.newInvoke());
        javaFunctions.add(InternalModelFactory.newBlock());
        javaFunctions.add(InternalModelFactory.newLocalVar());
        javaFunctions.add(InternalModelFactory.blockAddContent());
        javaFunctions.add(InternalModelFactory.blockAddLocalVar());
        javaFunctions.add(InternalModelFactory.intenalContentAddUnknownGlobalVar());
        return javaFunctions.toArray(new NamedJavaFunction[javaFunctions.size()]);
    }

    private static NamedJavaFunction newInternalContent() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                Block block = (Block)((Object)l.checkJavaObject(1, Block.class));
                LuaInternalContent content = new LuaInternalContent();
                content.setContent(block);
                l.pushJavaObject((Object)content);
                return 1;
            }

            public String getName() {
                return "newinternalmodel";
            }
        };
    }

    private static NamedJavaFunction newIdentifier() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                int sourceRangeMin = l.checkInteger(1);
                int sourceRangeMax = l.checkInteger(2);
                Identifier identifier = new Identifier();
                identifier.setStart(sourceRangeMin);
                identifier.setEnd(sourceRangeMax);
                l.pushJavaObject((Object)identifier);
                return 1;
            }

            public String getName() {
                return "newidentifier";
            }
        };
    }

    private static NamedJavaFunction newIndex() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                int sourceRangeMin = l.checkInteger(1);
                int sourceRangeMax = l.checkInteger(2);
                LuaExpression left = (LuaExpression)((Object)l.checkJavaObject(3, LuaExpression.class));
                String right = l.checkString(4, null);
                Index index = new Index();
                index.setStart(sourceRangeMin);
                index.setEnd(sourceRangeMax);
                index.setLeft(left);
                index.setRight(right);
                l.pushJavaObject((Object)index);
                return 1;
            }

            public String getName() {
                return "newindex";
            }
        };
    }

    private static NamedJavaFunction newCall() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                int sourceRangeMin = l.checkInteger(1);
                int sourceRangeMax = l.checkInteger(2);
                LuaExpression function = (LuaExpression)((Object)l.checkJavaObject(3, LuaExpression.class));
                Call call = new Call();
                call.setStart(sourceRangeMin);
                call.setEnd(sourceRangeMax);
                call.setFunction(function);
                l.pushJavaObject((Object)call);
                return 1;
            }

            public String getName() {
                return "newcall";
            }
        };
    }

    private static NamedJavaFunction newInvoke() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                int sourceRangeMin = l.checkInteger(1);
                int sourceRangeMax = l.checkInteger(2);
                String functionName = l.checkString(3);
                LuaExpression record = (LuaExpression)((Object)l.checkJavaObject(4, LuaExpression.class));
                Invoke invoke = new Invoke();
                invoke.setStart(sourceRangeMin);
                invoke.setEnd(sourceRangeMax);
                invoke.setFunctionName(functionName);
                invoke.setRecord(record);
                l.pushJavaObject((Object)invoke);
                return 1;
            }

            public String getName() {
                return "newinvoke";
            }
        };
    }

    private static NamedJavaFunction newBlock() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                int sourceRangeMin = l.checkInteger(1);
                int sourceRangeMax = l.checkInteger(2);
                Block block = new Block();
                block.setStart(sourceRangeMin);
                block.setEnd(sourceRangeMax);
                l.pushJavaObject((Object)block);
                return 1;
            }

            public String getName() {
                return "newblock";
            }
        };
    }

    private static NamedJavaFunction blockAddContent() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                Block block = (Block)((Object)l.checkJavaObject(1, Block.class));
                LuaASTNode node = (LuaASTNode)((Object)l.checkJavaObject(2, LuaASTNode.class));
                block.addContent(node);
                return 0;
            }

            public String getName() {
                return "addcontent";
            }
        };
    }

    private static NamedJavaFunction newLocalVar() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                Item item = (Item)l.checkJavaObject(1, Item.class);
                int sourceRangeMin = l.checkInteger(2);
                int sourceRangeMax = l.checkInteger(3);
                LocalVar localVar = new LocalVar(item, sourceRangeMin, sourceRangeMax);
                l.pushJavaObject((Object)localVar);
                return 1;
            }

            public String getName() {
                return "newlocalvar";
            }
        };
    }

    private static NamedJavaFunction blockAddLocalVar() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                Block block = (Block)((Object)l.checkJavaObject(1, Block.class));
                LocalVar var = (LocalVar)((Object)l.checkJavaObject(2, LocalVar.class));
                block.addLocalVar(var);
                return 0;
            }

            public String getName() {
                return "addlocalvar";
            }
        };
    }

    private static NamedJavaFunction intenalContentAddUnknownGlobalVar() {
        return new NamedJavaFunction(){

            public int invoke(LuaState l) {
                LuaInternalContent internalContent = (LuaInternalContent)((Object)l.checkJavaObject(1, LuaInternalContent.class));
                Item item = (Item)l.checkJavaObject(2, Item.class);
                internalContent.addUnknownGlobalVar(item);
                return 0;
            }

            public String getName() {
                return "addunknownglobalvar";
            }
        };
    }
}

