/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.core.internal.ast.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.ldt.core.IProjectSourceVisitor2;
import org.eclipse.ldt.core.LuaUtils;
import org.eclipse.ldt.core.internal.Activator;
import org.eclipse.ldt.core.internal.LuaLanguageToolkit;
import org.eclipse.ldt.core.internal.ast.models.LuaASTModelUtils;
import org.eclipse.ldt.core.internal.ast.models.MatchNodeVisitor;
import org.eclipse.ldt.core.internal.ast.models.api.ExprTypeRef;
import org.eclipse.ldt.core.internal.ast.models.api.ExternalTypeRef;
import org.eclipse.ldt.core.internal.ast.models.api.FunctionTypeDef;
import org.eclipse.ldt.core.internal.ast.models.api.InlineTypeRef;
import org.eclipse.ldt.core.internal.ast.models.api.InternalTypeRef;
import org.eclipse.ldt.core.internal.ast.models.api.Item;
import org.eclipse.ldt.core.internal.ast.models.api.LuaFileAPI;
import org.eclipse.ldt.core.internal.ast.models.api.ModuleTypeRef;
import org.eclipse.ldt.core.internal.ast.models.api.PrimitiveTypeRef;
import org.eclipse.ldt.core.internal.ast.models.api.RecordTypeDef;
import org.eclipse.ldt.core.internal.ast.models.api.Return;
import org.eclipse.ldt.core.internal.ast.models.api.TypeDef;
import org.eclipse.ldt.core.internal.ast.models.api.TypeRef;
import org.eclipse.ldt.core.internal.ast.models.api.UnknownItem;
import org.eclipse.ldt.core.internal.ast.models.common.LuaASTNode;
import org.eclipse.ldt.core.internal.ast.models.common.LuaSourceRoot;
import org.eclipse.ldt.core.internal.ast.models.file.Block;
import org.eclipse.ldt.core.internal.ast.models.file.Call;
import org.eclipse.ldt.core.internal.ast.models.file.Identifier;
import org.eclipse.ldt.core.internal.ast.models.file.Index;
import org.eclipse.ldt.core.internal.ast.models.file.Invoke;
import org.eclipse.ldt.core.internal.ast.models.file.LocalVar;
import org.eclipse.ldt.core.internal.ast.models.file.LuaExpression;
import org.eclipse.ldt.core.internal.ast.models.file.LuaInternalContent;

public final class LuaASTUtils {
    private LuaASTUtils() {
    }

    public static Item getClosestLocalVar(LuaSourceRoot luaSourceRoot, String identifierName, int position) {
        try {
            ClosestItemVisitor closestItemVisitor = new ClosestItemVisitor(position, identifierName);
            luaSourceRoot.getInternalContent().getContent().traverse(closestItemVisitor);
            return closestItemVisitor.getResult();
        }
        catch (Exception e) {
            Activator.logError("unable to collect local var", e);
            return null;
        }
    }

    public static TypeResolution resolveType(ISourceModule sourceModule, TypeRef typeRef) {
        if (typeRef instanceof PrimitiveTypeRef) {
            return LuaASTUtils.resolveType(sourceModule, (PrimitiveTypeRef)typeRef);
        }
        if (typeRef instanceof InternalTypeRef) {
            return LuaASTUtils.resolveType(sourceModule, (InternalTypeRef)typeRef);
        }
        if (typeRef instanceof ExternalTypeRef) {
            return LuaASTUtils.resolveType(sourceModule, (ExternalTypeRef)typeRef);
        }
        if (typeRef instanceof ModuleTypeRef) {
            return LuaASTUtils.resolveType(sourceModule, (ModuleTypeRef)typeRef);
        }
        if (typeRef instanceof ExprTypeRef) {
            return LuaASTUtils.resolveType(sourceModule, (ExprTypeRef)typeRef);
        }
        if (typeRef instanceof InlineTypeRef) {
            return LuaASTUtils.resolveType(sourceModule, (InlineTypeRef)typeRef);
        }
        return null;
    }

    public static TypeResolution resolveType(ISourceModule sourceModule, PrimitiveTypeRef primitiveTypeRef) {
        if (primitiveTypeRef.getTypeName().equals("string")) {
            ISourceModule stringSourceModule = LuaUtils.getSourceModule("string", sourceModule.getScriptProject());
            if (stringSourceModule == null) {
                return null;
            }
            LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot(stringSourceModule);
            TypeDef typeDef = luaSourceRoot.getFileapi().getTypes().get("string");
            return new TypeResolution(stringSourceModule, typeDef);
        }
        return null;
    }

    public static TypeResolution resolveType(ISourceModule sourceModule, InternalTypeRef internalTypeRef) {
        LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot(sourceModule);
        TypeDef typeDef = luaSourceRoot.getFileapi().getTypes().get(internalTypeRef.getTypeName());
        return new TypeResolution(sourceModule, typeDef);
    }

    public static TypeResolution resolveType(ISourceModule sourceModule, ExternalTypeRef externalTypeRef) {
        ISourceModule externalSourceModule = LuaUtils.getSourceModule(externalTypeRef.getModuleName(), sourceModule.getScriptProject());
        if (externalSourceModule == null) {
            return null;
        }
        LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot(externalSourceModule);
        TypeDef typeDef = luaSourceRoot.getFileapi().getTypes().get(externalTypeRef.getTypeName());
        return new TypeResolution(externalSourceModule, typeDef);
    }

    public static TypeResolution resolveType(ISourceModule sourceModule, ModuleTypeRef moduleTypeRef) {
        Return returnValues;
        ArrayList<Return> returns;
        ISourceModule referencedSourceModule = LuaUtils.getSourceModule(moduleTypeRef.getModuleName(), sourceModule.getScriptProject());
        if (referencedSourceModule == null) {
            return null;
        }
        LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot(referencedSourceModule);
        LuaFileAPI fileapi = luaSourceRoot.getFileapi();
        if (fileapi != null && (returns = fileapi.getReturns()).size() > 0 && (returnValues = returns.get(0)).getTypes().size() > moduleTypeRef.getReturnPosition() - 1) {
            TypeRef typeRef = returnValues.getTypes().get(moduleTypeRef.getReturnPosition() - 1);
            return LuaASTUtils.resolveType(referencedSourceModule, typeRef);
        }
        return null;
    }

    public static TypeResolution resolveType(ISourceModule sourceModule, ExprTypeRef exprTypeRef) {
        LuaExpression expression = exprTypeRef.getExpression();
        if (expression == null) {
            return null;
        }
        return LuaASTUtils.resolveType(sourceModule, expression, exprTypeRef.getReturnPosition());
    }

    public static TypeResolution resolveType(ISourceModule sourceModule, LuaExpression expr) {
        return LuaASTUtils.resolveType(sourceModule, expr, 1);
    }

    public static TypeResolution getDefaultIndexType(ISourceModule sourceModule, RecordTypeDef recordTypeDef) {
        return LuaASTUtils.getDefaultIndexType(new TypeResolution(sourceModule, recordTypeDef), new HashSet<TypeResolution>());
    }

    public static TypeResolution getDefaultIndexType(TypeResolution recordTypeResolution) {
        return LuaASTUtils.getDefaultIndexType(recordTypeResolution, new HashSet<TypeResolution>());
    }

    private static TypeResolution getDefaultIndexType(TypeResolution recordTypeResolution, Set<TypeResolution> cache) {
        if (recordTypeResolution != null && recordTypeResolution.getTypeDef() instanceof RecordTypeDef) {
            TypeResolution superTypeResolution;
            RecordTypeDef recordTypeDef = (RecordTypeDef)recordTypeResolution.getTypeDef();
            TypeRef defaultIndex = recordTypeDef.getDefaultvaluetyperef();
            if (defaultIndex != null) {
                return LuaASTUtils.resolveType(recordTypeResolution.getModule(), defaultIndex);
            }
            cache.add(recordTypeResolution);
            TypeRef supertype = recordTypeDef.getSupertype();
            if (supertype != null && !cache.contains(superTypeResolution = LuaASTUtils.resolveType(recordTypeResolution.getModule(), supertype))) {
                return LuaASTUtils.getDefaultIndexType(superTypeResolution, cache);
            }
        }
        return null;
    }

    public static TypeResolution resolveType(ISourceModule sourceModule, LuaExpression expr, int returnposition) {
        if (expr instanceof Identifier) {
            Definition definition = LuaASTUtils.getDefinition(sourceModule, expr);
            if (definition == null || definition.getItem() == null || definition.getItem().getType() == null) {
                return null;
            }
            return LuaASTUtils.resolveType(definition.getModule(), definition.getItem().getType());
        }
        if (expr instanceof Index) {
            Definition definition = LuaASTUtils.getDefinition(sourceModule, expr);
            if (definition != null && definition.getItem() != null && definition.getItem().getType() != null) {
                return LuaASTUtils.resolveType(definition.getModule(), definition.getItem().getType());
            }
            TypeResolution resolveType = LuaASTUtils.resolveType(sourceModule, ((Index)expr).getLeft());
            return LuaASTUtils.getDefaultIndexType(resolveType);
        }
        if (expr instanceof Call) {
            Call call = (Call)expr;
            TypeResolution resolvedType = LuaASTUtils.resolveType(sourceModule, call.getFunction());
            if (resolvedType != null) {
                List<TypeRef> types;
                TypeResolution type;
                FunctionTypeDef functiontype = null;
                if (resolvedType.getTypeDef() instanceof FunctionTypeDef) {
                    functiontype = (FunctionTypeDef)resolvedType.getTypeDef();
                } else if (resolvedType.getTypeDef() instanceof RecordTypeDef && (type = LuaASTUtils.resolveType(resolvedType.getModule(), ((RecordTypeDef)resolvedType.getTypeDef()).getCallTypeRef())) != null && type.getTypeDef() instanceof FunctionTypeDef) {
                    functiontype = (FunctionTypeDef)type.getTypeDef();
                }
                if (functiontype != null && functiontype.getReturns().size() > 0 && (types = functiontype.getReturns().get(0).getTypes()).size() >= returnposition) {
                    return LuaASTUtils.resolveType(resolvedType.getModule(), types.get(returnposition - 1));
                }
            }
            return null;
        }
        if (expr instanceof Invoke) {
            List<TypeRef> types;
            FunctionTypeDef functiontype;
            Definition definition = LuaASTUtils.getDefinition(sourceModule, expr);
            if (definition == null || definition.getItem() == null || definition.getItem().getType() == null) {
                return null;
            }
            TypeResolution resolvedFunctionType = LuaASTUtils.resolveType(definition.getModule(), definition.getItem().getType());
            if (resolvedFunctionType != null && resolvedFunctionType.getTypeDef() instanceof FunctionTypeDef && (functiontype = (FunctionTypeDef)resolvedFunctionType.getTypeDef()).getReturns().size() > 0 && (types = functiontype.getReturns().get(0).getTypes()).size() >= returnposition) {
                return LuaASTUtils.resolveType(resolvedFunctionType.getModule(), types.get(returnposition - 1));
            }
        }
        return null;
    }

    public static TypeResolution resolveType(ISourceModule sourceModule, InlineTypeRef inlineTypeRef) {
        TypeDef typeDef = inlineTypeRef.getDefinition();
        return new TypeResolution(sourceModule, typeDef);
    }

    public static Collection<Item> getLocalVars(LuaSourceRoot luaSourceRoot, final int offset, final String start) {
        final HashMap collectedLocalVars = new HashMap();
        ASTVisitor localvarCollector = new ASTVisitor(){

            public boolean visit(ASTNode node) throws Exception {
                if (node instanceof Block) {
                    return node.sourceStart() <= offset && offset <= node.sourceEnd();
                }
                return false;
            }

            public boolean endvisit(ASTNode node) throws Exception {
                if (node instanceof Block) {
                    List<LocalVar> localVars = ((Block)node).getLocalVars();
                    for (LocalVar localVar : localVars) {
                        Item item = localVar.getVar();
                        if (collectedLocalVars.containsKey(item.getName()) || start != null && !item.getName().toLowerCase().startsWith(start.toLowerCase())) continue;
                        collectedLocalVars.put(item.getName(), item);
                    }
                    return true;
                }
                return false;
            }
        };
        try {
            luaSourceRoot.getInternalContent().getContent().traverse(localvarCollector);
        }
        catch (Exception e) {
            Activator.logError("unable to collect local var", e);
        }
        return collectedLocalVars.values();
    }

    public static LuaExpression getLuaExpressionAt(LuaSourceRoot luaSourceRoot, int startOffset, int endOffset) {
        try {
            MatchNodeVisitor matchNodeVisitor = new MatchNodeVisitor(startOffset, endOffset, LuaExpression.class);
            luaSourceRoot.getInternalContent().getContent().traverse(matchNodeVisitor);
            return (LuaExpression)matchNodeVisitor.getNode();
        }
        catch (Exception e) {
            Activator.logError("unable to get expression at", e);
            return null;
        }
    }

    public static Definition getDefinition(ISourceModule sourceModule, RecordTypeDef recordTypeDef, String fieldname) {
        return LuaASTUtils.getDefinition(new TypeResolution(sourceModule, recordTypeDef), fieldname, new HashSet<TypeResolution>());
    }

    private static Definition getDefinition(TypeResolution recordTypeResolution, String fieldname, Set<TypeResolution> cache) {
        if (recordTypeResolution != null && recordTypeResolution.getTypeDef() instanceof RecordTypeDef) {
            TypeResolution superTypeResolution;
            RecordTypeDef recordtypedef = (RecordTypeDef)recordTypeResolution.getTypeDef();
            Item item = recordtypedef.getFields().get(fieldname);
            if (item != null) {
                return new Definition(recordTypeResolution.getModule(), item);
            }
            cache.add(recordTypeResolution);
            TypeRef supertype = recordtypedef.getSupertype();
            if (supertype != null && !cache.contains(superTypeResolution = LuaASTUtils.resolveType(recordTypeResolution.getModule(), supertype))) {
                return LuaASTUtils.getDefinition(superTypeResolution, fieldname, cache);
            }
        }
        return null;
    }

    public static Definition getDefinition(ISourceModule sourceModule, LuaExpression luaExpression) {
        if (luaExpression instanceof Identifier) {
            Identifier identifier = (Identifier)luaExpression;
            if (identifier.getDefinition() != null) {
                Definition globalVarDefinition;
                Item definition = identifier.getDefinition();
                if (definition instanceof UnknownItem) {
                    String identifiername = definition.getName();
                    LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot(sourceModule);
                    Item localvarItem = LuaASTUtils.getClosestLocalVar(luaSourceRoot, identifiername, identifier.start());
                    if (localvarItem != null) {
                        return new Definition(sourceModule, localvarItem);
                    }
                    Definition globalVarDefinition2 = LuaASTUtils.getGlobalVarDefinition(sourceModule, identifiername);
                    if (globalVarDefinition2 != null) {
                        return globalVarDefinition2;
                    }
                    return null;
                }
                if (LuaASTUtils.isUnresolvedGlobal(definition) && (globalVarDefinition = LuaASTUtils.getGlobalVarDefinition(sourceModule, definition.getName())) != null) {
                    return globalVarDefinition;
                }
                return new Definition(sourceModule, definition);
            }
        } else if (luaExpression instanceof Index) {
            Index index = (Index)luaExpression;
            TypeResolution resolveType = LuaASTUtils.resolveType(sourceModule, index.getLeft());
            if (resolveType != null && resolveType.getTypeDef() instanceof RecordTypeDef) {
                RecordTypeDef typeDef = (RecordTypeDef)resolveType.getTypeDef();
                return LuaASTUtils.getDefinition(resolveType.getModule(), typeDef, index.getRight());
            }
        } else if (luaExpression instanceof Invoke) {
            Invoke invoke = (Invoke)luaExpression;
            TypeResolution resolveType = LuaASTUtils.resolveType(sourceModule, invoke.getRecord());
            if (resolveType != null && resolveType.getTypeDef() instanceof RecordTypeDef) {
                RecordTypeDef typeDef = (RecordTypeDef)resolveType.getTypeDef();
                return LuaASTUtils.getDefinition(resolveType.getModule(), typeDef, invoke.getFunctionName());
            }
        } else if (luaExpression instanceof Call) {
            Call call = (Call)luaExpression;
            Definition definition = LuaASTUtils.getDefinition(sourceModule, call.getFunction());
            return definition;
        }
        return null;
    }

    public static List<Definition> getAllGlobalVarsDefinition(ISourceModule sourceModule, String start) {
        ArrayList<Definition> definitions = new ArrayList<Definition>();
        ISourceModule preloadedSourceModule = LuaASTUtils.getPreloadSourceModule(sourceModule);
        if (preloadedSourceModule != null) {
            definitions.addAll(LuaASTUtils.getAllInternalGlobalVarsDefinition(preloadedSourceModule, start));
        }
        if (Platform.getPreferencesService().getBoolean(LuaLanguageToolkit.getDefault().getPreferenceQualifier(), "USE_GLOBAL_VAR_IN_LDT", true, null)) {
            definitions.addAll(LuaASTUtils.getAllInternalGlobalVarsDefinition(sourceModule, start));
            definitions.addAll(LuaASTUtils.getAllExternalGlobalVarsDefinition(sourceModule, start));
        }
        return definitions;
    }

    public static List<Definition> getAllInternalGlobalVarsDefinition(ISourceModule sourceModule, String start) {
        ArrayList<Definition> definitions = new ArrayList<Definition>();
        LuaSourceRoot currentluaSourceRoot = LuaASTModelUtils.getLuaSourceRoot(sourceModule);
        if (currentluaSourceRoot != null) {
            for (Item globalvar : currentluaSourceRoot.getFileapi().getGlobalvars().values()) {
                if (start != null && !start.isEmpty() && !globalvar.getName().toLowerCase().startsWith(start.toLowerCase())) continue;
                definitions.add(new Definition(sourceModule, globalvar));
            }
        }
        return definitions;
    }

    public static List<Definition> getAllExternalGlobalVarsDefinition(ISourceModule originalSourceModule, String start) {
        return LuaASTUtils.getExternalGlobalVarsDefinition(originalSourceModule, start, false);
    }

    private static List<Definition> getExternalGlobalVarsDefinition(final ISourceModule originalSourceModule, final String start, final boolean exactName) {
        final ArrayList<Definition> definitions = new ArrayList<Definition>();
        IProjectSourceVisitor2 visitor = new IProjectSourceVisitor2(){

            @Override
            public void processFile(ISourceModule sourceModule, IPath absolutePath, IPath relativePath, String charset, IProgressMonitor monitor) throws CoreException {
                if (sourceModule != null && !sourceModule.equals(originalSourceModule)) {
                    if (exactName) {
                        Definition globalVarDef = LuaASTUtils.getInternalGlobalVarDefinition(sourceModule, start);
                        if (globalVarDef != null) {
                            definitions.add(globalVarDef);
                        }
                    } else {
                        definitions.addAll(LuaASTUtils.getAllInternalGlobalVarsDefinition(sourceModule, start));
                    }
                }
            }

            @Override
            public void processDirectory(IScriptFolder sourceModule, IPath absolutePath, IPath relativePath, IProgressMonitor monitor) throws CoreException {
            }
        };
        try {
            LuaUtils.visitSourceFiles(originalSourceModule.getScriptProject(), EnumSet.of(LuaUtils.ProjectFragmentFilter.DEPENDENT_PROJECT), visitor, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Activator.logError("Unable to get external global for auto-complete", e);
        }
        return definitions;
    }

    public static Definition getGlobalVarDefinition(ISourceModule sourceModule, String varname) {
        Definition definition = LuaASTUtils.getGlobalVarDefinitionInPreloadedSourceModule(sourceModule, varname);
        if (definition != null) {
            return definition;
        }
        if (Platform.getPreferencesService().getBoolean(LuaLanguageToolkit.getDefault().getPreferenceQualifier(), "USE_GLOBAL_VAR_IN_LDT", true, null)) {
            definition = LuaASTUtils.getInternalGlobalVarDefinition(sourceModule, varname);
            if (definition != null) {
                return definition;
            }
            definition = LuaASTUtils.getExternalGlobalVarDefinition(sourceModule, varname);
            if (definition != null) {
                return definition;
            }
        }
        return null;
    }

    public static Definition getGlobalVarDefinitionInPreloadedSourceModule(ISourceModule sourceModule, String varname) {
        ISourceModule preloadedSourceModule = LuaASTUtils.getPreloadSourceModule(sourceModule);
        if (preloadedSourceModule == null) {
            return null;
        }
        LuaSourceRoot preloadedLuaSourceRoot = LuaASTModelUtils.getLuaSourceRoot(preloadedSourceModule);
        if (preloadedLuaSourceRoot == null) {
            return null;
        }
        Item item = preloadedLuaSourceRoot.getFileapi().getGlobalvars().get(varname);
        if (item == null) {
            return null;
        }
        return new Definition(preloadedSourceModule, item);
    }

    public static Definition getInternalGlobalVarDefinition(ISourceModule sourceModule, String varname) {
        LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot(sourceModule);
        if (luaSourceRoot == null) {
            return null;
        }
        Item item = luaSourceRoot.getFileapi().getGlobalvars().get(varname);
        if (item == null) {
            return null;
        }
        return new Definition(sourceModule, item);
    }

    public static Definition getExternalGlobalVarDefinition(ISourceModule originalSourceModule, String start) {
        List<Definition> definitions = LuaASTUtils.getExternalGlobalVarsDefinition(originalSourceModule, start, true);
        if (!definitions.isEmpty()) {
            return definitions.get(0);
        }
        return null;
    }

    public static ISourceModule getPreloadSourceModule(ISourceModule sourceModule) {
        if (sourceModule != null && sourceModule.getScriptProject() != null) {
            return LuaUtils.getSourceModule("global", sourceModule.getScriptProject());
        }
        return null;
    }

    public static boolean isModule(LuaFileAPI luaFileAPI, RecordTypeDef recordTypeDef) {
        TypeRef moduleReturnTypeRef = LuaASTUtils.getModuleReturnType(luaFileAPI);
        if (!(moduleReturnTypeRef instanceof InternalTypeRef)) {
            return false;
        }
        String typename = ((InternalTypeRef)moduleReturnTypeRef).getTypeName();
        return luaFileAPI.getTypes().get(typename) == recordTypeDef;
    }

    public static boolean isInlineTypeDef(TypeDef typedef) {
        return typedef != null && typedef.getParent() instanceof Item;
    }

    public static boolean isInlineTypeField(Item item) {
        return item.getParent() instanceof RecordTypeDef && LuaASTUtils.isInlineTypeDef((TypeDef)item.getParent());
    }

    public static boolean isLocalVariable(Item item) {
        return item.getParent() instanceof Block;
    }

    public static boolean isGlobalVariable(Item item) {
        return item.getParent() instanceof LuaFileAPI;
    }

    public static boolean isUnresolvedGlobal(Item item) {
        return item.getParent() instanceof LuaInternalContent;
    }

    public static boolean isTypeField(Item item) {
        return item.getParent() instanceof RecordTypeDef;
    }

    public static boolean isModuleTypeField(LuaFileAPI luaFileAPI, Item item) {
        LuaASTNode parent = item.getParent();
        if (parent instanceof RecordTypeDef) {
            return LuaASTUtils.isModule(luaFileAPI, (RecordTypeDef)parent);
        }
        return false;
    }

    public static boolean isModule(LuaFileAPI luaFileAPI, LuaASTNode node) {
        TypeDef typedef;
        if (node instanceof Item) {
            Item item = (Item)node;
            if (LuaASTUtils.isInlineTypeField(item) && item.getParent() instanceof RecordTypeDef) {
                LuaASTNode parent = ((RecordTypeDef)item.getParent()).getParent();
                return LuaASTUtils.isModule(luaFileAPI, parent);
            }
            return LuaASTUtils.isModuleTypeField(luaFileAPI, item);
        }
        if (node instanceof TypeDef && LuaASTUtils.isInlineTypeDef(typedef = (TypeDef)node)) {
            return LuaASTUtils.isModule(luaFileAPI, ((TypeDef)node).getParent());
        }
        return false;
    }

    public static boolean isPublic(LuaASTNode node) {
        TypeDef typedef;
        if (node instanceof Item) {
            Item item = (Item)node;
            if (LuaASTUtils.isInlineTypeField(item) && item.getParent() instanceof RecordTypeDef) {
                LuaASTNode parent = ((RecordTypeDef)item.getParent()).getParent();
                return LuaASTUtils.isPublic(parent);
            }
            return LuaASTUtils.isGlobalVariable(item) || LuaASTUtils.isTypeField(item);
        }
        if (node instanceof TypeDef && LuaASTUtils.isInlineTypeDef(typedef = (TypeDef)node)) {
            return LuaASTUtils.isPublic(((TypeDef)node).getParent());
        }
        return false;
    }

    public static boolean isPrivate(LuaASTNode node) {
        TypeDef typedef;
        if (node instanceof Item) {
            Item item = (Item)node;
            if (LuaASTUtils.isInlineTypeField(item) && item.getParent() instanceof RecordTypeDef) {
                LuaASTNode parent = ((RecordTypeDef)item.getParent()).getParent();
                return LuaASTUtils.isPrivate(parent);
            }
            return LuaASTUtils.isLocalVariable(item);
        }
        if (node instanceof TypeDef && LuaASTUtils.isInlineTypeDef(typedef = (TypeDef)node)) {
            return LuaASTUtils.isPrivate(((TypeDef)node).getParent());
        }
        return false;
    }

    public static TypeDef resolveTypeLocaly(ISourceModule sourceModule, Item item) {
        LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot(sourceModule);
        if (luaSourceRoot != null) {
            return LuaASTUtils.resolveTypeLocaly(luaSourceRoot.getFileapi(), item);
        }
        return null;
    }

    public static TypeDef resolveTypeLocaly(LuaFileAPI luaFileAPI, Item item) {
        if (item == null) {
            return null;
        }
        TypeRef typeref = item.getType();
        if (typeref instanceof InternalTypeRef) {
            if (luaFileAPI == null) {
                return null;
            }
            InternalTypeRef internaltyperef = (InternalTypeRef)typeref;
            TypeDef typeDef = luaFileAPI.getTypes().get(internaltyperef.getTypeName());
            return typeDef;
        }
        if (typeref instanceof InlineTypeRef) {
            InlineTypeRef inlinetyperef = (InlineTypeRef)typeref;
            TypeDef typeDef = inlinetyperef.getDefinition();
            return typeDef;
        }
        return null;
    }

    public static TypeRef getModuleReturnType(LuaFileAPI luaFileAPI) {
        ArrayList<Return> returns = luaFileAPI.getReturns();
        if (returns.isEmpty()) {
            return null;
        }
        Return returnValues = returns.get(0);
        if (returnValues.getTypes().isEmpty()) {
            return null;
        }
        return returnValues.getTypes().get(0);
    }

    private static class ClosestItemVisitor
    extends ASTVisitor {
        private Item result = null;
        private int position;
        private String identifierName;

        public ClosestItemVisitor(int position, String identifierName) {
            this.position = position;
            this.identifierName = identifierName;
        }

        public Item getResult() {
            return this.result;
        }

        public boolean visit(ASTNode node) throws Exception {
            if (node instanceof LocalVar) {
                return false;
            }
            if (node instanceof Block) {
                return node.sourceStart() <= this.position && this.position <= node.sourceEnd();
            }
            return false;
        }

        public boolean endvisit(ASTNode node) throws Exception {
            if (this.result == null && node instanceof Block) {
                List<LocalVar> localVars = ((Block)node).getLocalVars();
                for (LocalVar localVar : localVars) {
                    Item item = localVar.getVar();
                    if (!item.getName().equals(this.identifierName)) continue;
                    this.result = item;
                }
                return true;
            }
            return false;
        }
    }

    public static class Definition {
        private ISourceModule module;
        private Item item;

        public Definition(ISourceModule module, Item item) {
            this.module = module;
            this.item = item;
        }

        public ISourceModule getModule() {
            return this.module;
        }

        public Item getItem() {
            return this.item;
        }
    }

    public static class TypeResolution {
        private ISourceModule module;
        private TypeDef typeDef;

        public TypeResolution(ISourceModule module, TypeDef typeDef) {
            this.module = module;
            this.typeDef = typeDef;
        }

        public ISourceModule getModule() {
            return this.module;
        }

        public TypeDef getTypeDef() {
            return this.typeDef;
        }

        public boolean equals(Object obj) {
            boolean typeDefEquality;
            boolean moduleEquality;
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeResolution typeResolution = (TypeResolution)obj;
            if (this.module == null && typeResolution.module == null) {
                moduleEquality = true;
            } else if (this.module != null && this.module.equals(typeResolution.module)) {
                moduleEquality = true;
            } else {
                return false;
            }
            if (this.typeDef == null && typeResolution.typeDef == null) {
                typeDefEquality = true;
            } else if (this.typeDef != null && this.typeDef.equals(typeResolution.typeDef)) {
                typeDefEquality = true;
            } else {
                return false;
            }
            return typeDefEquality && moduleEquality;
        }

        public int hashCode() {
            int hash = 1;
            hash = 17 * hash + (this.module == null ? 0 : this.module.hashCode());
            hash = 31 * hash + (this.typeDef == null ? 0 : this.typeDef.hashCode());
            return hash;
        }
    }
}

