/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.jonas.internal;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.libra.framework.core.FrameworkInstanceConfiguration;
import org.eclipse.libra.framework.core.OSGIFrameworkInstanceBehaviorDelegate;
import org.eclipse.libra.framework.core.ProgressUtil;
import org.eclipse.libra.framework.core.Trace;
import org.eclipse.libra.framework.jonas.IJonasVersionHandler;
import org.eclipse.libra.framework.jonas.JonasFrameworkInstance;
import org.eclipse.libra.framework.jonas.Messages;
import org.eclipse.libra.framework.jonas.internal.JonasConfigurationPublishHelper;
import org.eclipse.wst.server.core.IModule;

public class JonasFrameworkInstanceBehavior
extends OSGIFrameworkInstanceBehaviorDelegate {
    protected transient JonasConfigurationPublishHelper publishHelper = new JonasConfigurationPublishHelper(this);

    public IJonasVersionHandler getJonasVersionHandler() {
        return this.getJonasRuntimeInstance().getJonasVersionHandler();
    }

    public JonasFrameworkInstance getJonasRuntimeInstance() {
        return (JonasFrameworkInstance)this.getServer().loadAdapter(JonasFrameworkInstance.class, null);
    }

    public String getFrameworkClass() {
        return this.getJonasVersionHandler().getFrameworkClass();
    }

    public String[] getFrameworkProgramArguments(boolean starting) {
        return this.getJonasVersionHandler().getFrameworkProgramArguments(this.getBaseDirectory(), this.getFrameworkInstance().isDebug(), starting);
    }

    public String[] getExcludedFrameworkProgramArguments(boolean starting) {
        return this.getJonasVersionHandler().getExcludedFrameworkProgramArguments(this.getFrameworkInstance().isDebug(), starting);
    }

    public String[] getFrameworkVMArguments() {
        IPath deployPath;
        IPath installPath = this.getServer().getRuntime().getLocation();
        if (!installPath.isAbsolute()) {
            try {
                String installLoc = new File(installPath.toOSString()).getCanonicalPath();
                installPath = new Path(installLoc);
            }
            catch (IOException iOException) {}
        }
        if (!(deployPath = this.getBaseDirectory()).isAbsolute()) {
            try {
                String deployLoc = new File(deployPath.toOSString()).getCanonicalPath();
                deployPath = new Path(deployLoc);
            }
            catch (IOException iOException) {}
        }
        return this.getJonasVersionHandler().getFrameworkVMArguments(installPath, null, deployPath, false);
    }

    protected void publishServer(int kind, IProgressMonitor monitor) throws CoreException {
        if (this.getServer().getRuntime() == null) {
            return;
        }
        IPath confDir = this.getBaseDirectory();
        this.getJonasVersionHandler().createJonasBase(this.getServer().getRuntime().getLocation(), this.getJonasRuntimeInstance().getInstanceDirectory());
        IStatus status = this.getJonasVersionHandler().prepareDeployDirectory(confDir);
        if (status != null && !status.isOK()) {
            throw new CoreException(status);
        }
        monitor = ProgressUtil.getMonitorFor((IProgressMonitor)monitor);
        monitor.beginTask(Messages.publishServerTask, 600);
        monitor.done();
        this.setServerPublishState(1);
    }

    protected void publishModules(int kind, List modules, List deltaKind2, MultiStatus multi, IProgressMonitor monitor) {
        IPath confDir = this.getBaseDirectory();
        try {
            FrameworkInstanceConfiguration jonasConfiguration = this.getJonasRuntimeInstance().getJonasConfiguration();
            IPath deployDir = confDir.append("/jonasbase/tmp");
            IPath installDir = confDir.append("/jonasbase/deploy");
            File deployPath = deployDir.toFile();
            if (!deployPath.exists()) {
                deployPath.mkdir();
            }
            this.publishHelper.exportBundles(modules, jonasConfiguration, installDir, deployDir);
            this.getJonasVersionHandler().prepareFrameworkConfigurationFile(deployDir, this.publishHelper.getServerModules(modules, "reference:file:", " "), this.publishHelper.getTargetBundles(jonasConfiguration, "reference:file:", " "));
        }
        catch (CoreException e) {
            Trace.trace((byte)2, (String)"Publishing failed", (Throwable)e);
        }
    }

    protected void publishModule(int kind, int deltaKind, IModule[] moduleTree, IProgressMonitor monitor) throws CoreException {
        if (this.getServer().getServerState() != 4 && (deltaKind == 1 || deltaKind == 3)) {
            this.setServerRestartState(true);
        }
        Properties p = this.loadModulePublishLocations();
        this.setModulePublishState(moduleTree, 1);
        this.saveModulePublishLocations(p);
    }
}

