/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.oprofile.ui.model;

import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelEvent;
import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelImage;
import org.eclipse.linuxtools.internal.oprofile.ui.OprofileUiPlugin;
import org.eclipse.linuxtools.oprofile.ui.model.IUiModelElement;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelDependent;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelImage;
import org.eclipse.swt.graphics.Image;

public class UiModelEvent
implements IUiModelElement {
    private IUiModelElement parent = null;
    private OpModelEvent event;
    private UiModelImage image;
    private UiModelDependent dependent;

    public UiModelEvent(IUiModelElement parent, OpModelEvent event) {
        this.parent = parent;
        this.event = event;
        this.image = null;
        this.dependent = null;
        this.refreshModel();
    }

    private void refreshModel() {
        OpModelImage dataModelImage = this.event.getImage();
        if (dataModelImage != null) {
            this.image = new UiModelImage(this, dataModelImage, dataModelImage.getCount(), dataModelImage.getDepCount());
            if (dataModelImage.hasDependents()) {
                this.dependent = new UiModelDependent(this, dataModelImage.getDependents(), dataModelImage.getCount(), dataModelImage.getDepCount());
            }
        }
    }

    public String toString() {
        return this.event == null ? "" : this.event.getName();
    }

    @Override
    public String getLabelText() {
        return this.toString();
    }

    @Override
    public IUiModelElement[] getChildren() {
        if (this.dependent != null) {
            return new IUiModelElement[]{this.image, this.dependent};
        }
        return new IUiModelElement[]{this.image};
    }

    @Override
    public boolean hasChildren() {
        return this.image != null;
    }

    @Override
    public IUiModelElement getParent() {
        return this.parent;
    }

    @Override
    public Image getLabelImage() {
        return OprofileUiPlugin.getImageDescriptor("icons/event.gif").createImage();
    }
}

