/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.panes.oql.contentAssist;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.SnapshotInfo;
import org.eclipse.mat.snapshot.model.IArray;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IClassLoader;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.snapshot.ImageHelper;
import org.eclipse.mat.ui.snapshot.panes.oql.contentAssist.ContentAssistElement;
import org.eclipse.mat.ui.snapshot.panes.oql.contentAssist.SuggestionProvider;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertySuggestionProvider
implements SuggestionProvider {
    private static final String PROPERTY_TAG = "@";
    private static final String START_METHOD = "(";
    private static final String PARM_SEP = ", ";
    private static final String ARG_SEP = " ";
    private static final String END_METHOD = ")";
    private static final String RETURN_SEP = " : ";
    private static final String CLASS_SEP = " - ";
    boolean ready = false;
    private TreeSet<ContentAssistElement> orderedList;
    static final String[] methods = new String[]{"contains", "containsAll", "doesExtend", "equals", "equals", "get", "getClassOf", "getClassesByName", "getClassesByName", "getField", "getGCRootInfo", "getHeapSize", "getHeapSize", "getImmediateDominatedIds", "getImmediateDominatorId", "getInboundRefererIds", "getMultiplePathsFromGCRoots", "getObject", "getOutboundReferentIds", "getPathsFromGCRoots", "getProperty", "getReferenceArray", "getRetainedHeapSize", "getSnapshotAddons", "getThreadStack", "getValueArray", "getValueAt", "hasSuperClass", "hashCode", "hashCode", "indexOf", "isArray", "isClass", "isClassLoader", "isGCRoot", "lastIndexOf", "mapAddressToId", "mapIdToAddress", "resolveValue", "size", "subList", "toArray", "toArray", "toString", "toString"};
    static final String[] parmTypes = new String[]{"java.lang.Object", "java.lang.String", "java.lang.Class", "int", "char", "byte", "short", "float", "double", "long", "boolean", "java.util.Map", "java.util.Collection"};

    public PropertySuggestionProvider(ISnapshot snapshot) {
        InitializerJob asyncJob = new InitializerJob(snapshot);
        asyncJob.schedule();
    }

    @Override
    public List<ContentAssistElement> getSuggestions(String context) {
        LinkedList<ContentAssistElement> tempList = new LinkedList<ContentAssistElement>();
        boolean foundFirst = false;
        if (this.ready) {
            for (ContentAssistElement cp : this.orderedList) {
                String cName = cp.getClassName();
                if (cName.startsWith(context)) {
                    foundFirst = true;
                    tempList.add(cp);
                    continue;
                }
                if (foundFirst) break;
            }
        }
        return tempList;
    }

    private String buildDescription(Method method, String parms, Class<?> retType, Class<?> declaringClass) {
        return String.valueOf(method.getName()) + START_METHOD + parms + END_METHOD + RETURN_SEP + retType.getSimpleName() + CLASS_SEP + declaringClass.getSimpleName();
    }

    private void initList(ISnapshot snapshot) throws SnapshotException {
        ContentAssistElement ce;
        Class c;
        Class[] classes = new Class[]{IObject.class, IInstance.class, IClassLoader.class, IClass.class, IArray.class, IPrimitiveArray.class, IObjectArray.class, ISnapshot.class, Object.class, SnapshotInfo.class, List.class};
        this.orderedList = new TreeSet();
        Class[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            c = classArray[n2];
            Method[] methodArray = c.getMethods();
            int n3 = methodArray.length;
            int n4 = 0;
            while (n4 < n3) {
                block14: {
                    Method m = methodArray[n4];
                    if (this.isSuitableMethod(m)) {
                        Image im = this.imageForClass(m.getDeclaringClass());
                        StringBuilder sb1 = new StringBuilder();
                        StringBuilder sb2 = new StringBuilder();
                        int i = 1;
                        Class<?>[] classArray2 = m.getParameterTypes();
                        int n5 = classArray2.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            Class<?> parm = classArray2[n6];
                            if (this.isSuitableParameter(parm)) {
                                if (sb1.length() > 1) {
                                    sb1.append(PARM_SEP);
                                }
                                if (sb2.length() > 1) {
                                    sb2.append(PARM_SEP);
                                }
                                String nm = String.valueOf(parm.getSimpleName().replaceAll("\\[\\]", "").toLowerCase(Locale.ENGLISH)) + i++;
                                sb1.append(nm);
                                sb2.append(parm.getSimpleName());
                                sb2.append(ARG_SEP);
                                sb2.append(nm);
                                ++n6;
                                continue;
                            }
                            break block14;
                        }
                        ce = new ContentAssistElement(String.valueOf(m.getName()) + START_METHOD + sb1 + END_METHOD, im, this.buildDescription(m, sb2.toString(), m.getReturnType(), m.getDeclaringClass()));
                        if (!this.orderedList.contains(ce)) {
                            this.orderedList.add(ce);
                        }
                    }
                }
                ++n4;
            }
            ++n2;
        }
        classArray = classes;
        n = classes.length;
        n2 = 0;
        while (n2 < n) {
            block15: {
                PropertyDescriptor[] descriptors;
                BeanInfo info;
                c = classArray[n2];
                Image im = this.imageForClass(c);
                try {
                    info = Introspector.getBeanInfo(c);
                }
                catch (IntrospectionException e) {
                    ErrorHelper.logThrowable(e);
                    break block15;
                }
                PropertyDescriptor[] propertyDescriptorArray = descriptors = info.getPropertyDescriptors();
                int n7 = descriptors.length;
                int n8 = 0;
                while (n8 < n7) {
                    PropertyDescriptor descriptor = propertyDescriptorArray[n8];
                    if (descriptor.getReadMethod() != null) {
                        StringBuilder desc = new StringBuilder();
                        desc.append(descriptor.getName());
                        desc.append(RETURN_SEP);
                        desc.append(descriptor.getPropertyType().getSimpleName());
                        desc.append(CLASS_SEP);
                        desc.append(descriptor.getReadMethod().getDeclaringClass().getSimpleName());
                        ce = new ContentAssistElement(PROPERTY_TAG + descriptor.getName(), im, desc.toString());
                        if (!this.orderedList.contains(ce)) {
                            this.orderedList.add(ce);
                        }
                        String desc1 = this.buildDescription(descriptor.getReadMethod(), "", descriptor.getPropertyType(), descriptor.getReadMethod().getDeclaringClass());
                        ce = new ContentAssistElement(String.valueOf(descriptor.getReadMethod().getName()) + START_METHOD + END_METHOD, im, desc1);
                        this.orderedList.remove(ce);
                        String desc2 = this.buildDescription(descriptor.getReadMethod(), "", descriptor.getPropertyType(), c);
                        ce = new ContentAssistElement(String.valueOf(descriptor.getReadMethod().getName()) + START_METHOD + END_METHOD, im, desc2);
                        this.orderedList.remove(ce);
                    }
                    ++n8;
                }
            }
            ++n2;
        }
        this.ready = true;
    }

    private boolean isSuitableMethod(Method meth) {
        String[] stringArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            String m = stringArray[n2];
            if (meth.getName().equals(m)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isSuitableParameter(Class<?> parm) {
        if (parm.isArray()) {
            parm = parm.getComponentType();
        }
        String[] stringArray = parmTypes;
        int n = parmTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String tp = stringArray[n2];
            if (tp.equals(parm.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private Image imageForClass(Class<?> c) {
        Object im;
        if (c == IObject.class) {
            im = ImageHelper.getImage(1);
        } else if (c == IInstance.class) {
            im = ImageHelper.getImage(1);
            im = MemoryAnalyserPlugin.getImage("$nl$/icons/size.gif");
        } else {
            im = c == IClassLoader.class ? ImageHelper.getImage(2) : (c == IClass.class ? ImageHelper.getImage(0) : (c == IArray.class || c == IPrimitiveArray.class || c == IObjectArray.class ? ImageHelper.getImage(3) : (c == ISnapshot.class ? MemoryAnalyserPlugin.getImage("$nl$/icons/heapobjects/heapdump16.gif") : (c == SnapshotInfo.class ? MemoryAnalyserPlugin.getImage("$nl$/icons/heapdump_details.gif") : (c == List.class ? MemoryAnalyserPlugin.getImage("$nl$/icons/grouping.gif") : null)))));
        }
        return im;
    }

    private class InitializerJob
    extends Job {
        ISnapshot snapshot;

        public InitializerJob(ISnapshot snapshot) {
            super("Init content assistant");
            this.snapshot = snapshot;
        }

        protected IStatus run(IProgressMonitor arg0) {
            try {
                PropertySuggestionProvider.this.initList(this.snapshot);
                return Status.OK_STATUS;
            }
            catch (SnapshotException e) {
                ErrorHelper.logThrowable(e);
                return Status.CANCEL_STATUS;
            }
        }
    }
}

