/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementsToAnalyze {
    private IJavaProject fJavaProject;
    private final Map<Object, Map<String, Object>> elementsAndOptions = new LinkedHashMap<Object, Map<String, Object>>();

    public void setJavaProject(IJavaProject javaProject) {
        this.fJavaProject = javaProject;
    }

    public IJavaProject getJavaProject() {
        return this.fJavaProject;
    }

    public ElementsToAnalyze(IJavaProject javaProject) {
        this.fJavaProject = javaProject;
    }

    public Set<Object> getElementsToDiscover() {
        return Collections.unmodifiableSet(this.elementsAndOptions.keySet());
    }

    public Map<String, Object> getDiscoveryOptions(Object element) {
        return this.elementsAndOptions.get(element);
    }

    public void addElementToDiscover(Object element) {
        if (!this.elementsAndOptions.containsKey(element)) {
            this.elementsAndOptions.put(element, new HashMap());
        }
    }

    public void removeElementToDiscover(Object element) {
        this.elementsAndOptions.remove(element);
    }

    public void cleanElementsToDiscover() {
        if (this.elementsAndOptions != null) {
            this.elementsAndOptions.clear();
        }
    }

    protected ElementsToAnalyze clone() throws CloneNotSupportedException {
        ElementsToAnalyze elementsToAnalyze = new ElementsToAnalyze(this.fJavaProject);
        elementsToAnalyze.elementsAndOptions.putAll(this.elementsAndOptions);
        return elementsToAnalyze;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Object object : this.getElementsToDiscover()) {
            if (!first) {
                builder.append(", ");
            }
            first = false;
            if (object instanceof IJavaProject) {
                IJavaProject javaProject = (IJavaProject)object;
                builder.append(javaProject.getElementName());
                continue;
            }
            if (object instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)object;
                builder.append(packageFragmentRoot.getElementName());
                continue;
            }
            builder.append(object.toString());
        }
        return builder.toString();
    }
}

