/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.jee.queries.annotations.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.gmt.modisco.java.Annotation;
import org.eclipse.gmt.modisco.java.BodyDeclaration;

public final class EvaluateAnnotation {
    private EvaluateAnnotation() {
    }

    public static Boolean evaluate(BodyDeclaration context, String annotationName) throws ModelQueryExecutionException {
        ArrayList<Status> statusList = new ArrayList<Status>();
        try {
            for (Annotation an : context.getAnnotations()) {
                try {
                    if (!an.getType().getType().getName().equalsIgnoreCase(annotationName)) continue;
                    return Boolean.TRUE;
                }
                catch (NullPointerException e) {
                    statusList.add(new Status(4, "org.eclipse.modisco.jee.queries", "NullPointer", (Throwable)e));
                }
                catch (Exception e) {
                    statusList.add(new Status(4, "org.eclipse.modisco.jee.queries", "Unknown..", (Throwable)e));
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new ModelQueryExecutionException("Null context not expected");
        }
        catch (Exception exception) {
            return Boolean.FALSE;
        }
        if (!statusList.isEmpty()) {
            MultiStatus multiStatus = new MultiStatus("org.eclipse.modisco.jee.queries", 4, (IStatus[])statusList.toArray(new Status[0]), "", (Throwable)new Exception());
            CoreException cause = new CoreException((IStatus)multiStatus);
            throw new ModelQueryExecutionException((Throwable)cause);
        }
        return Boolean.FALSE;
    }
}

