/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.freeze.command;

import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.freeze.FreezeLayer;
import org.eclipse.nebula.widgets.nattable.freeze.command.IFreezeCoordinatesProvider;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;

public class FreezeSelectionStrategy
implements IFreezeCoordinatesProvider {
    private final FreezeLayer freezeLayer;
    private final ViewportLayer viewportLayer;
    private final SelectionLayer selectionLayer;

    public FreezeSelectionStrategy(FreezeLayer freezeLayer, ViewportLayer viewportLayer, SelectionLayer selectionLayer) {
        this.freezeLayer = freezeLayer;
        this.viewportLayer = viewportLayer;
        this.selectionLayer = selectionLayer;
    }

    @Override
    public PositionCoordinate getTopLeftPosition() {
        int rowPosition;
        PositionCoordinate lastSelectedCellPosition = this.selectionLayer.getLastSelectedCellPosition();
        if (lastSelectedCellPosition == null) {
            return null;
        }
        int columnPosition = this.viewportLayer.getScrollableLayer().getColumnPositionByX(this.viewportLayer.getOrigin().getX());
        if (columnPosition > 0 && columnPosition >= lastSelectedCellPosition.columnPosition) {
            columnPosition = lastSelectedCellPosition.columnPosition - 1;
        }
        if ((rowPosition = this.viewportLayer.getScrollableLayer().getRowPositionByY(this.viewportLayer.getOrigin().getY())) > 0 && rowPosition >= lastSelectedCellPosition.rowPosition) {
            rowPosition = lastSelectedCellPosition.rowPosition - 1;
        }
        return new PositionCoordinate(this.freezeLayer, columnPosition, rowPosition);
    }

    @Override
    public PositionCoordinate getBottomRightPosition() {
        if (this.selectionLayer.getSelectedCells().size() > 1) {
            PositionCoordinate[] coords;
            if (this.selectionLayer.getFullySelectedColumnPositions().length > 0) {
                int[] selColPos;
                int columnPosition = 0;
                int[] nArray = selColPos = this.selectionLayer.getFullySelectedColumnPositions();
                int n = selColPos.length;
                int n2 = 0;
                while (n2 < n) {
                    int col = nArray[n2];
                    columnPosition = Math.max(columnPosition, col);
                    ++n2;
                }
                return new PositionCoordinate(this.freezeLayer, columnPosition, -1);
            }
            if (this.selectionLayer.getFullySelectedRowPositions().length > 0) {
                int[] selRowPos;
                int rowPosition = 0;
                int[] nArray = selRowPos = this.selectionLayer.getFullySelectedRowPositions();
                int n = selRowPos.length;
                int n3 = 0;
                while (n3 < n) {
                    int row = nArray[n3];
                    rowPosition = Math.max(rowPosition, row);
                    ++n3;
                }
                return new PositionCoordinate(this.freezeLayer, -1, rowPosition);
            }
            int columnPosition = -1;
            int rowPosition = -1;
            PositionCoordinate[] positionCoordinateArray = coords = this.selectionLayer.getSelectedCellPositions();
            int n = coords.length;
            int n4 = 0;
            while (n4 < n) {
                PositionCoordinate coord = positionCoordinateArray[n4];
                columnPosition = columnPosition < 0 ? coord.columnPosition : Math.min(columnPosition, coord.columnPosition);
                rowPosition = rowPosition < 0 ? coord.rowPosition : Math.min(rowPosition, coord.rowPosition);
                ++n4;
            }
            return new PositionCoordinate(this.freezeLayer, columnPosition - 1, rowPosition - 1);
        }
        PositionCoordinate selectionAnchor = this.selectionLayer.getSelectionAnchor();
        if (selectionAnchor != null) {
            return new PositionCoordinate(this.freezeLayer, selectionAnchor.columnPosition - 1, selectionAnchor.rowPosition - 1);
        }
        return null;
    }
}

