/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.style.editor;

import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.style.VerticalAlignmentEnum;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class VerticalAlignmentPicker
extends Composite {
    private final Combo combo;

    public VerticalAlignmentPicker(Composite parent, VerticalAlignmentEnum alignment) {
        super(parent, 0);
        this.setLayout((Layout)new RowLayout());
        this.combo = new Combo((Composite)this, 12);
        this.combo.setItems(new String[]{Messages.getString("VerticalAlignmentPicker.top"), Messages.getString("VerticalAlignmentPicker.middle"), Messages.getString("VerticalAlignmentPicker.bottom")});
        this.update(alignment);
    }

    private void update(VerticalAlignmentEnum alignment) {
        if (alignment.equals((Object)VerticalAlignmentEnum.TOP)) {
            this.combo.select(0);
        } else if (alignment.equals((Object)VerticalAlignmentEnum.MIDDLE)) {
            this.combo.select(1);
        } else if (alignment.equals((Object)VerticalAlignmentEnum.BOTTOM)) {
            this.combo.select(2);
        } else {
            throw new IllegalArgumentException("bad alignment: " + (Object)((Object)alignment));
        }
    }

    public VerticalAlignmentEnum getSelectedAlignment() {
        int idx = this.combo.getSelectionIndex();
        if (idx == 0) {
            return VerticalAlignmentEnum.TOP;
        }
        if (idx == 1) {
            return VerticalAlignmentEnum.MIDDLE;
        }
        if (idx == 2) {
            return VerticalAlignmentEnum.BOTTOM;
        }
        throw new IllegalStateException("shouldn't happen");
    }

    public void setSelectedAlignment(VerticalAlignmentEnum verticalAlignment) {
        if (verticalAlignment == null) {
            throw new IllegalArgumentException("null");
        }
        this.update(verticalAlignment);
    }
}

