/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.widgets.BaseDialog;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogDialog
extends BaseDialog<Viewer> {
    private StringBuilder log = new StringBuilder();
    private StyledText text;
    private TextStyle textStyle;
    private List<StyleRange> styleRanges = new ArrayList<StyleRange>();
    private StyleRange currentStyleRange = new StyleRange();
    private StyleRange lastStyleRange;
    private Font font;

    public LogDialog(Shell parentShell, int shellStyle, String title, String message, IDialogSettings settings) {
        super(parentShell, shellStyle, title, message, settings);
    }

    public LogDialog(Shell parentShell, String title, String message, IDialogSettings settings) {
        this(parentShell, 1264, title, message, settings);
    }

    public TextStyle getTextStyle() {
        return this.textStyle;
    }

    public void setTextStyle(TextStyle textStyle) {
        if (textStyle == null) {
            throw new IllegalArgumentException("textStyle == null");
        }
        if (textStyle.equals((Object)this.textStyle)) {
            return;
        }
        this.lastStyleRange = this.currentStyleRange;
        this.textStyle = textStyle;
        this.currentStyleRange = new StyleRange();
        this.currentStyleRange.start = this.log.length();
        this.currentStyleRange.rise = textStyle.rise;
        this.currentStyleRange.background = textStyle.background;
        this.currentStyleRange.font = textStyle.font;
        this.currentStyleRange.foreground = textStyle.foreground;
        this.currentStyleRange.metrics = textStyle.metrics;
        this.currentStyleRange.strikeout = textStyle.strikeout;
        this.currentStyleRange.underline = textStyle.underline;
    }

    public void append(String text) {
        this.checkStyleRange();
        this.log.append(text);
        this.currentStyleRange.length += text.length();
    }

    public void append(Throwable t) {
        this.checkStyleRange();
        String text = IOUtil.toString((Throwable)t);
        this.log.append(text);
        this.currentStyleRange.length += text.length();
    }

    @Override
    public boolean close() {
        this.font.dispose();
        return super.close();
    }

    @Override
    protected void createUI(Composite parent) {
        GridLayout grid = new GridLayout();
        grid.marginTop = 6;
        grid.marginLeft = 6;
        grid.marginRight = 6;
        grid.marginBottom = 6;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)grid);
        composite.setLayoutData((Object)UIUtil.createGridData());
        this.font = new Font((Device)this.getShell().getDisplay(), "Courier New", 9, 0);
        this.checkStyleRange();
        this.lastStyleRange = this.currentStyleRange;
        this.checkStyleRange();
        this.text = new StyledText(composite, 2826);
        this.text.setLayoutData((Object)UIUtil.createGridData());
        this.text.setText(this.log.toString());
        this.text.setStyleRanges(this.styleRanges.toArray(new StyleRange[this.styleRanges.size()]));
        this.text.setBackground(this.getShell().getDisplay().getSystemColor(1));
        this.text.setFont(this.font);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    private void checkStyleRange() {
        if (this.lastStyleRange != null) {
            this.styleRanges.add(this.lastStyleRange);
            this.lastStyleRange = null;
        }
    }
}

