/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.table;

import java.io.PrintStream;
import org.eclipse.net4j.internal.util.table.Cell;
import org.eclipse.net4j.internal.util.table.Coordinate;
import org.eclipse.net4j.internal.util.table.Range;
import org.eclipse.net4j.internal.util.table.RectangularRange;
import org.eclipse.net4j.internal.util.table.Table;

public class Dumper {
    public static final Dumper ASCII = new Dumper();
    public static final Dumper UTF8 = new Dumper('\u2500', '\u2534', '\u252c', '\u253c', '\u2518', '\u2510', '\u2524', '\u2502', '\u251c', '\u2514', '\u250c', "\n", " ");
    public final char borderLeftRight;
    public final char borderLeftRightUp;
    public final char borderLeftRightDown;
    public final char borderLeftRightUpDown;
    public final char borderLeftUp;
    public final char borderLeftDown;
    public final char borderLeftUpDown;
    public final char borderUpDown;
    public final char borderUpDownRight;
    public final char borderUpRight;
    public final char borderDownRight;
    public final String newLine;
    public final String padding;
    public final String paddingBorder;

    public Dumper(char borderLeftRight, char borderLeftRightUp, char borderLeftRightDown, char borderLeftRightUpDown, char borderLeftUp, char borderLeftDown, char borderLeftUpDown, char borderUpDown, char borderUpDownRight, char borderUpRight, char borderDownRight, String newLine, String padding) {
        this.borderLeftRight = borderLeftRight;
        this.borderLeftRightUp = borderLeftRightUp;
        this.borderLeftRightDown = borderLeftRightDown;
        this.borderLeftRightUpDown = borderLeftRightUpDown;
        this.borderLeftUp = borderLeftUp;
        this.borderLeftDown = borderLeftDown;
        this.borderLeftUpDown = borderLeftUpDown;
        this.borderUpDown = borderUpDown;
        this.borderUpDownRight = borderUpDownRight;
        this.borderUpRight = borderUpRight;
        this.borderDownRight = borderDownRight;
        this.newLine = newLine == null ? "" : newLine;
        this.padding = padding == null ? "" : padding;
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < padding.length()) {
            builder.append(borderLeftRight);
            ++i;
        }
        this.paddingBorder = builder.toString();
    }

    public Dumper() {
        this('-', '+', '+', '+', '+', '+', '+', '|', '+', '+', '+', "\n", " ");
    }

    public String dump(RectangularRange range, int ... rowSeparators) {
        StringBuilder builder = new StringBuilder();
        this.dump(builder, range, rowSeparators);
        return builder.toString();
    }

    public void dump(PrintStream stream, RectangularRange range, int ... rowSeparators) {
        String string = this.dump(range, rowSeparators);
        stream.print(string);
        stream.flush();
    }

    public void dump(StringBuilder builder, RectangularRange range, int ... rowSeparators) {
        Table table = range.table();
        Coordinate topLeft = range.topLeft();
        int cols = range.cols();
        int rows = range.rows();
        String[][] strings = new String[cols][];
        Range.Alignment[][] alignments = new Range.Alignment[cols][];
        int[] widths = new int[cols];
        int col = 0;
        while (col < cols) {
            strings[col] = new String[rows];
            alignments[col] = new Range.Alignment[rows];
            int row = 0;
            while (row < rows) {
                String string;
                Cell cell = table.cell(topLeft.col + col, range.topLeft().row + row);
                Object value = cell.value();
                strings[col][row] = string = cell.applyFormat(value);
                alignments[col][row] = cell.alignmentFor(value);
                widths[col] = Math.max(widths[col], string.length());
                ++row;
            }
            ++col;
        }
        this.dumpSeparator(builder, Position.BEGIN, widths);
        int row = 0;
        while (row < rows) {
            builder.append(this.borderUpDown);
            builder.append(this.padding);
            int col2 = 0;
            while (col2 < cols) {
                if (col2 != 0) {
                    builder.append(this.padding);
                    builder.append(this.borderUpDown);
                    builder.append(this.padding);
                }
                String value = strings[col2][row];
                Range.Alignment alignment = alignments[col2][row];
                int width = widths[col2];
                builder.append(alignment.apply(value, width));
                ++col2;
            }
            builder.append(this.padding);
            builder.append(this.borderUpDown);
            builder.append(this.newLine);
            if (row < rows - 1 && Dumper.needsSeparator(row, rowSeparators)) {
                this.dumpSeparator(builder, Position.MIDDLE, widths);
            }
            ++row;
        }
        this.dumpSeparator(builder, Position.END, widths);
    }

    private void dumpSeparator(StringBuilder builder, Position vertical, int[] widths) {
        builder.append(this.border(Position.BEGIN, vertical));
        builder.append(this.paddingBorder);
        int c = 0;
        while (c < widths.length) {
            if (c > 0) {
                builder.append(this.paddingBorder);
                builder.append(this.border(Position.MIDDLE, vertical));
                builder.append(this.paddingBorder);
            }
            int i = 0;
            while (i < widths[c]) {
                builder.append(this.borderLeftRight);
                ++i;
            }
            ++c;
        }
        builder.append(this.paddingBorder);
        builder.append(this.border(Position.END, vertical));
        builder.append(this.newLine);
    }

    private char border(Position horizontal, Position vertical) {
        switch (horizontal) {
            case BEGIN: {
                switch (vertical) {
                    case BEGIN: {
                        return this.borderDownRight;
                    }
                    case MIDDLE: {
                        return this.borderUpDownRight;
                    }
                    case END: {
                        return this.borderUpRight;
                    }
                }
                break;
            }
            case MIDDLE: {
                switch (vertical) {
                    case BEGIN: {
                        return this.borderLeftRightDown;
                    }
                    case MIDDLE: {
                        return this.borderLeftRightUpDown;
                    }
                    case END: {
                        return this.borderLeftRightUp;
                    }
                }
                break;
            }
            case END: {
                switch (vertical) {
                    case BEGIN: {
                        return this.borderLeftDown;
                    }
                    case MIDDLE: {
                        return this.borderLeftUpDown;
                    }
                    case END: {
                        return this.borderLeftUp;
                    }
                }
            }
        }
        throw new IllegalArgumentException();
    }

    private static boolean needsSeparator(int row, int[] rowSeparators) {
        int i = 0;
        while (i < rowSeparators.length) {
            if (rowSeparators[i] == row) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Position {
        BEGIN,
        MIDDLE,
        END;

    }
}

