/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.factory;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.net4j.util.factory.Factory;
import org.eclipse.net4j.util.factory.FactoryCreationException;
import org.eclipse.net4j.util.factory.FactoryKey;
import org.eclipse.net4j.util.factory.IFactory;

public class FactoryDescriptor
extends Factory {
    private static final String ATTR_PRODUCT_GROUP = "productGroup";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_CLASS = "class";
    private IConfigurationElement configurationElement;

    public FactoryDescriptor(IConfigurationElement configurationElement) {
        super(FactoryDescriptor.createFactoryKey(configurationElement));
        this.configurationElement = configurationElement;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public IFactory createFactory() {
        try {
            return (IFactory)this.configurationElement.createExecutableExtension(ATTR_CLASS);
        }
        catch (CoreException ex) {
            throw new FactoryCreationException(ex);
        }
    }

    public Object create(String description) {
        throw new UnsupportedOperationException();
    }

    public String getDescriptionFor(Object product) {
        throw new UnsupportedOperationException();
    }

    private static FactoryKey createFactoryKey(IConfigurationElement element) {
        String productGroup = element.getAttribute(ATTR_PRODUCT_GROUP);
        String type = element.getAttribute(ATTR_TYPE);
        return new FactoryKey(productGroup, type);
    }
}

