/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.debug;

import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.core.IJavaBreakpointListener;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.debug.internal.breakpoints.OTBreakpoints;

public class OTBreakpointInstaller {
    private static Hashtable<String, IBreakpoint> OT_BREAKPOINTS = new Hashtable(5);
    private static IJavaBreakpointListener dynListener;

    public static void installOTBreakpoints(IJavaProject project, IJavaBreakpointListener dynListener) throws CoreException {
        OTBreakpointInstaller.dynListener = dynListener;
        if (dynListener != null) {
            JDIDebugModel.addJavaBreakpointListener((IJavaBreakpointListener)dynListener);
        }
        DebugPlugin.getDefault().addDebugEventListener(new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                boolean done = false;
                if (OT_BREAKPOINTS.size() == 0) {
                    done = true;
                } else {
                    DebugEvent[] debugEventArray = events;
                    int n = events.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DebugEvent event = debugEventArray[n2];
                        if (event.getKind() == 4 && event.getSource() instanceof IJavaDebugTarget) {
                            IDebugTarget debugTarget = ((IJavaDebugTarget)event.getSource()).getDebugTarget();
                            for (IBreakpoint bp : OT_BREAKPOINTS.values()) {
                                debugTarget.breakpointAdded(bp);
                            }
                            done = true;
                            break;
                        }
                        ++n2;
                    }
                }
                if (done) {
                    DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                }
            }
        });
        try {
            IType oot = project.findType(String.valueOf(IOTConstants.STR_ORG_OBJECTTEAMS_TEAM));
            OTBreakpoints.Descriptor[] descriptorArray = OTBreakpoints.Descriptor.values();
            int n = descriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType instrumentation;
                OTBreakpoints.Descriptor bpDescriptor = descriptorArray[n2];
                if (bpDescriptor.isOOTBreakPoint()) {
                    if (oot != null) {
                        bpDescriptor.insertInto(oot, OT_BREAKPOINTS);
                    }
                } else if (dynListener != null && (instrumentation = project.findType(bpDescriptor.getTypeName())) != null) {
                    bpDescriptor.insertInto(instrumentation, OT_BREAKPOINTS);
                }
                ++n2;
            }
        }
        catch (JavaModelException ex) {
            throw new CoreException((IStatus)new Status(2, "org.eclipse.objectteams.otdt.debug", 0, "Cannot set breakpoints for team-activation tracking", (Throwable)ex));
        }
    }

    public static void uninstallTeamBreakpoints() throws CoreException {
        if (dynListener != null) {
            JDIDebugModel.removeJavaBreakpointListener((IJavaBreakpointListener)dynListener);
            dynListener = null;
        }
        OT_BREAKPOINTS.clear();
    }
}

