/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.dynamic;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.CodeGenConstants;
import org.eclipse.ocl.examples.codegen.dynamic.JavaSourceFileObject;
import org.eclipse.ocl.examples.codegen.dynamic.OCL2JavaFileObject;
import org.eclipse.ocl.examples.codegen.utilities.CGUtil;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.osgi.framework.Bundle;

public abstract class JavaFileUtil {
    public static final @NonNull TracingOption CLASS_PATH = new TracingOption(CodeGenConstants.PLUGIN_ID, "classPath");
    public static final @NonNull String TEST_BIN_FOLDER_NAME = "test-bin";
    private static final @NonNull String MAVEN_TYCHO_BIN_FOLDER_NAME = "target/classes";
    private static final @NonNull String REGULAR_BIN_FOLDER_NAME = "bin";
    public static final @NonNull String TEST_SRC_FOLDER_NAME = "test-src";
    private static @Nullable JavaCompiler compiler = JavaFileUtil.getJavaCompiler();

    public static @Nullable String compileClass(@NonNull String sourcePath, @NonNull String javaCodeSource, @NonNull String objectPath, @Nullable List<@NonNull String> classpathProjects) throws IOException {
        List<@NonNull JavaFileObject> compilationUnits = Collections.singletonList(new OCL2JavaFileObject(sourcePath, javaCodeSource));
        return JavaFileUtil.compileClasses(compilationUnits, sourcePath, objectPath, classpathProjects);
    }

    public static @Nullable String compileClasses(@NonNull String sourcePath, @NonNull String objectPath, @Nullable List<@NonNull String> classpathProjects) throws IOException {
        List<@NonNull JavaFileObject> compilationUnits = JavaFileUtil.gatherCompilationUnits(new File(sourcePath), null);
        return JavaFileUtil.compileClasses(compilationUnits, sourcePath, objectPath, classpathProjects);
    }

    public static @Nullable String compileClasses(@NonNull List<@NonNull JavaFileObject> compilationUnits, @NonNull String sourcePath, @NonNull String objectPath, @Nullable List<@NonNull String> classpathProjects) {
        JavaCompiler compiler2 = compiler;
        if (compiler2 == null) {
            throw new IllegalStateException("No JavaCompiler provided by the Java platform - you need to use a JDK rather than a JRE");
        }
        StandardJavaFileManager stdFileManager2 = compiler2.getStandardFileManager(null, Locale.getDefault(), null);
        if (stdFileManager2 == null) {
            throw new IllegalStateException("No StandardJavaFileManager provided by the Java platform");
        }
        try {
            JavaCompiler.CompilationTask compilerTask;
            DiagnosticCollector diagnostics = new DiagnosticCollector();
            ArrayList<@NonNull String> compilationOptions = new ArrayList<String>();
            compilationOptions.add("-d");
            compilationOptions.add(objectPath);
            compilationOptions.add("-g");
            if (classpathProjects != null && classpathProjects.size() > 0) {
                compilationOptions.add("-cp");
                compilationOptions.add(JavaFileUtil.createClassPath(classpathProjects));
            }
            if ((compilerTask = compiler2.getTask(null, stdFileManager2, diagnostics, compilationOptions, null, compilationUnits)).call().booleanValue()) {
                return null;
            }
            StringBuilder s = new StringBuilder();
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                s.append("\n" + diagnostic.getMessage(null));
            }
            String message = s.length() > 0 ? "Failed to compile " + sourcePath + s.toString() : "Compilation of " + sourcePath + " returned false but no diagnostics";
            String string = message;
            return string;
        }
        finally {
            try {
                stdFileManager2.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static @NonNull String createClassPath(@NonNull List<@NonNull String> projectPaths) {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            String pathSeparator = null;
            StringBuilder s = new StringBuilder();
            for (String projectName : projectPaths) {
                String projectPath = null;
                if (projectName.contains("/") || projectName.contains("\\")) {
                    projectPath = projectName;
                } else {
                    Bundle bundle;
                    IPath location;
                    IProject project = root.getProject(projectName);
                    if (project != null && (location = project.getLocation()) != null) {
                        projectPath = String.valueOf(location.toString()) + "/";
                    }
                    if (projectPath == null && (bundle = Platform.getBundle((String)projectName)) != null) {
                        projectPath = bundle.getLocation();
                    }
                    if (projectPath != null) {
                        URI uri;
                        if (projectPath.startsWith("reference:")) {
                            projectPath = projectPath.substring(10);
                        }
                        if ((uri = URI.createURI((String)projectPath)).isFile()) {
                            projectPath = ((String)ClassUtil.nonNullState((Object)uri.toFileString())).replace("\\", "/");
                        }
                        assert (projectPath != null);
                        if (projectPath.endsWith("/")) {
                            projectPath = String.valueOf(projectPath) + REGULAR_BIN_FOLDER_NAME;
                        }
                    }
                }
                if (projectPath == null) continue;
                if (pathSeparator != null) {
                    s.append(pathSeparator);
                } else {
                    pathSeparator = System.getProperty("path.separator");
                }
                s.append(projectPath);
            }
            return s.toString();
        }
        String pathSeparator = null;
        StringBuilder s = new StringBuilder();
        for (String projectPath : projectPaths) {
            if (pathSeparator != null) {
                s.append(pathSeparator);
            } else {
                pathSeparator = System.getProperty("path.separator");
            }
            s.append(projectPath);
        }
        return s.toString();
    }

    public static @NonNull List<@NonNull String> createClassPathProjectList(@NonNull URIConverter uriConverter, @NonNull List<@NonNull String> projectNames) {
        ArrayList<@NonNull String> classpathProjectList = new ArrayList<String>();
        for (String projectName : projectNames) {
            File path = JavaFileUtil.getProjectBinFolder(uriConverter, projectName);
            if (path == null) continue;
            classpathProjectList.add(String.valueOf(path));
        }
        return classpathProjectList;
    }

    public static void deleteJavaFiles(@NonNull String sourcePath) {
        JavaFileUtil.deleteJavaFiles(new File(sourcePath));
    }

    private static void deleteJavaFiles(@NonNull File folder) {
        File[] listFiles = folder.listFiles();
        if (listFiles != null) {
            File[] fileArray = listFiles;
            int n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    JavaFileUtil.deleteJavaFiles(file);
                } else if (file.isFile() && file.getName().endsWith(".java")) {
                    file.delete();
                }
                ++n2;
            }
        }
    }

    private static @NonNull List<@NonNull JavaFileObject> gatherCompilationUnits(@NonNull File folder, @Nullable List<@NonNull JavaFileObject> compilationUnits) throws IOException {
        File[] listFiles;
        if (compilationUnits == null) {
            compilationUnits = new ArrayList<JavaFileObject>();
        }
        if ((listFiles = folder.listFiles()) != null) {
            File[] fileArray = listFiles;
            int n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    JavaFileUtil.gatherCompilationUnits(file, compilationUnits);
                } else if (file.isFile() && file.getName().endsWith(".java")) {
                    java.net.URI uri = file.getCanonicalFile().toURI();
                    compilationUnits.add(new JavaSourceFileObject(uri));
                }
                ++n2;
            }
        }
        return compilationUnits;
    }

    public static @NonNull List<@NonNull String> gatherPackageNames(@NonNull File binFolder, @Nullable String packagePath) {
        ArrayList<@NonNull String> packagePaths = new ArrayList<String>();
        JavaFileUtil.gatherPackageNames(packagePaths, binFolder, packagePath);
        return packagePaths;
    }

    private static void gatherPackageNames(@NonNull List<@NonNull String> packagePaths, @NonNull File binFolder, @Nullable String packagePath) {
        boolean hasFile = false;
        File[] fileArray = binFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            File binFile = fileArray[n2];
            if (binFile.isFile()) {
                if (!hasFile) {
                    if (packagePath != null) {
                        packagePaths.add(packagePath);
                    }
                    hasFile = true;
                }
            } else if (binFile.isDirectory() && !".".equals(name = binFile.getName()) && !"..".equals(name)) {
                JavaFileUtil.gatherPackageNames(packagePaths, binFile, packagePath != null ? String.valueOf(packagePath) + "." + name : name);
            }
            ++n2;
        }
    }

    public static @NonNull List<@NonNull JavaFileObject> getCompilationUnits(@NonNull File srcFile) throws Exception {
        ArrayList<@NonNull JavaFileObject> compilationUnits = new ArrayList<JavaFileObject>();
        JavaFileUtil.getCompilationUnits(compilationUnits, srcFile);
        return compilationUnits;
    }

    private static void getCompilationUnits(@NonNull List<@NonNull JavaFileObject> compilationUnits, @NonNull File directory) throws Exception {
        File[] files = directory.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    JavaFileUtil.getCompilationUnits(compilationUnits, file);
                } else if (file.isFile()) {
                    compilationUnits.add(new JavaSourceFileObject(file.toURI()));
                }
                ++n2;
            }
        }
    }

    private static @Nullable JavaCompiler getJavaCompiler() {
        return ToolProvider.getSystemJavaCompiler();
    }

    public static @Nullable File getProjectBinFolder(@NonNull URIConverter uriConverter, @NonNull String projectName) {
        String path = null;
        String binDir = CGUtil.isMavenSurefire() || CGUtil.isTychoSurefire() ? MAVEN_TYCHO_BIN_FOLDER_NAME : REGULAR_BIN_FOLDER_NAME;
        URI platformURI = URI.createPlatformResourceURI((String)("/" + projectName + "/"), (boolean)true);
        URI pathURI = uriConverter.normalize(platformURI);
        String location = null;
        if (EMFPlugin.IS_ECLIPSE_RUNNING && pathURI.isPlatform()) {
            IWorkspaceRoot workspaceRoot;
            IResource project;
            Bundle bundle;
            if (pathURI.isPlatformPlugin() && (bundle = Platform.getBundle((String)projectName)) != null && (location = bundle.getLocation()) != null) {
                URI uri;
                if ("System Bundle".equals(location)) {
                    uri = URI.createURI((String)Platform.getBundle((String)"org.eclipse.core.runtime").getLocation(), (boolean)true);
                    if (uri.hasOpaquePart()) {
                        String opaquePart = uri.opaquePart();
                        assert (opaquePart != null);
                        if (opaquePart.startsWith("file:") && !opaquePart.startsWith("file:/")) {
                            String file = new File(opaquePart.substring(5)).getAbsolutePath();
                            uri = URI.createFileURI((String)file);
                        } else {
                            uri = URI.createURI((String)uri.opaquePart());
                        }
                    }
                    uri = uri.trimSegments(1).appendSegment(String.valueOf(bundle.getSymbolicName()) + "_" + bundle.getVersion() + ".jar");
                    path = uri.toFileString();
                } else {
                    uri = URI.createURI((String)location, (boolean)true);
                    if (uri.hasOpaquePart()) {
                        String opaquePart = uri.opaquePart();
                        assert (opaquePart != null);
                        if (opaquePart.startsWith("file:../../../../")) {
                            String file = new File(opaquePart.substring(11)).getAbsolutePath();
                            uri = URI.createFileURI((String)file);
                        } else if (opaquePart.equals("file:../../")) {
                            String file = new File(binDir).getAbsolutePath();
                            uri = URI.createFileURI((String)file);
                        } else if (opaquePart.startsWith("file:") && !opaquePart.startsWith("file:/")) {
                            String file = new File(opaquePart.substring(5)).getAbsolutePath();
                            uri = URI.createFileURI((String)file);
                        } else {
                            uri = URI.createURI((String)opaquePart);
                        }
                    }
                    path = uri.isPrefix() ? String.valueOf(uri.toFileString()) + binDir : uri.toFileString();
                }
            }
            if (path == null && (project = (workspaceRoot = ResourcesPlugin.getWorkspace().getRoot()).findMember(projectName)) != null) {
                location = String.valueOf(project.getLocation());
                path = String.valueOf(location) + "/" + TEST_BIN_FOLDER_NAME;
            }
        } else if (pathURI.isArchive()) {
            path = pathURI.toString();
            if (path.startsWith("archive:file:") && path.endsWith("!/")) {
                path = path.substring(13, path.length() - 2);
            }
        } else {
            path = pathURI.toFileString();
            if (path != null) {
                path = !new File(String.valueOf(path) + "/META-INF").exists() ? String.valueOf(path) + TEST_BIN_FOLDER_NAME : String.valueOf(path) + binDir;
            }
        }
        if (CLASS_PATH.isActive()) {
            StringBuilder s = new StringBuilder();
            s.append(projectName);
            s.append(" => ");
            s.append(pathURI);
            s.append(" => ");
            if (location != null) {
                s.append(location);
                s.append(" => ");
            }
            s.append(path);
            System.out.println(s.toString());
        }
        return path != null ? new File(path) : null;
    }
}

