/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.spi;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.View;

public interface IStylingProvider {
    public static final IStylingProvider NONE = new IStylingProvider(){

        @Override
        public void resetStyle(View view) {
        }

        @Override
        public Iterable<EClass> getSupportedSemanticClasses() {
            return Collections.emptyList();
        }

        @Override
        public Predicate<EStructuralFeature> getSemanticPropertySupportedPredicate() {
            return feature -> false;
        }
    };

    public void resetStyle(View var1);

    public Iterable<EClass> getSupportedSemanticClasses();

    public Predicate<EStructuralFeature> getSemanticPropertySupportedPredicate();

    default public IStylingProvider compose(final IStylingProvider other) {
        final IStylingProvider self = this;
        return self == NONE ? other : (other == NONE ? self : new IStylingProvider(){

            @Override
            public void resetStyle(View view) {
                self.resetStyle(view);
                other.resetStyle(view);
            }

            @Override
            public Iterable<EClass> getSupportedSemanticClasses() {
                return Iterables.concat(self.getSupportedSemanticClasses(), other.getSupportedSemanticClasses());
            }

            @Override
            public Predicate<EStructuralFeature> getSemanticPropertySupportedPredicate() {
                return self.getSemanticPropertySupportedPredicate().or(other.getSemanticPropertySupportedPredicate());
            }
        });
    }
}

