/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.wst.server.ui.cnf;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.reddeer.common.adaptable.RedDeerAdaptable;
import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.wait.GroupWait;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitProvider;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.common.wait.WaitWrapper;
import org.eclipse.reddeer.core.handler.ItemHandler;
import org.eclipse.reddeer.core.handler.WidgetHandler;
import org.eclipse.reddeer.eclipse.condition.ServerExists;
import org.eclipse.reddeer.eclipse.condition.ServerHasPublishState;
import org.eclipse.reddeer.eclipse.condition.ServerHasState;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.Server;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.ServerLabel;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.ServerModule;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.ServersView2;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.ServersViewEnums;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.ServersViewException;
import org.eclipse.reddeer.eclipse.wst.server.ui.editor.ServerEditor;
import org.eclipse.reddeer.eclipse.wst.server.ui.wizard.ModifyModulesDialog;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.CheckBox;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.menu.ContextMenuItem;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IPublishListener;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.ui.IServerModule;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.osgi.framework.Bundle;

public abstract class AbstractServer
implements Server,
RedDeerAdaptable<Server> {
    private TimePeriod stateChangeTimeout = TimePeriod.getCustom((long)600L);
    private TimePeriod publishTimeout = TimePeriod.VERY_LONG;
    protected static final String ADD_AND_REMOVE = "Add and Remove...";
    protected static final Logger log = Logger.getLogger(AbstractServer.class);
    protected TreeItem treeItem;
    protected ServersView2 view;
    private static final boolean isServerBundlePresent = AbstractServer.isServerBundlePresent();
    private static final String SERVER_CORE_BUNDLE = "org.eclipse.wst.server.core";
    private static final String SERVER_UI_BUNDLE = "org.eclipse.wst.server.ui";

    protected AbstractServer(TreeItem treeItem) {
        if (!isServerBundlePresent) {
            throw new EclipseLayerException("Server bundles 'org.eclipse.wst.server.core org.eclipse.wst.server.ui' are not present in running eclipse instance");
        }
        this.treeItem = treeItem;
        this.view = new ServersView2();
    }

    @Override
    public TreeItem getTreeItem() {
        return this.treeItem;
    }

    @Override
    public boolean isValid() {
        return this.treeItem != null && !this.treeItem.isDisposed();
    }

    @Override
    public ServerLabel getLabel() {
        this.activate();
        return new ServerLabel(this.treeItem);
    }

    @Override
    public void select() {
        this.activate();
        this.treeItem.select();
    }

    @Override
    public ServerEditor open() {
        this.select();
        log.info("Open server's editor");
        new ContextMenuItem(new String[]{"Open"}).select();
        return this.createServerEditor(this.getLabel().getName());
    }

    @Override
    public void start() {
        this.select();
        log.info("Start server " + this.getLabel().getName());
        if (!ServersViewEnums.ServerState.STOPPED.equals((Object)this.getLabel().getState())) {
            throw new ServersViewException("Cannot start server because it is not stopped");
        }
        this.operateServerState("Start", ServersViewEnums.ServerState.STARTED);
    }

    @Override
    public void stop() {
        this.select();
        log.info("Stop server '" + this.getLabel().getName() + "'");
        ServersViewEnums.ServerState state = this.getLabel().getState();
        if (!ServersViewEnums.ServerState.STARTING.equals((Object)state) && !state.isRunningState()) {
            throw new ServersViewException("Cannot stop server because it not running");
        }
        this.operateServerState("Stop", ServersViewEnums.ServerState.STOPPED);
    }

    @Override
    public void restart() {
        this.select();
        log.info("Restart server '" + this.getLabel().getName() + "'");
        if (!this.getLabel().getState().isRunningState()) {
            throw new ServersViewException("Cannot restart server because it is not running");
        }
        this.operateServerState("Restart", ServersViewEnums.ServerState.STARTED);
    }

    @Override
    public void restartInDebug() {
        this.select();
        log.info("Restart server in debug '" + this.getLabel().getName() + "'");
        if (!this.getLabel().getState().isRunningState()) {
            throw new ServersViewException("Cannot restart server in debug because it is not running");
        }
        this.operateServerState("Restart in Debug", ServersViewEnums.ServerState.DEBUGGING);
    }

    @Override
    public void restartInProfile() {
        this.select();
        log.info("Restart server in profile '" + this.getLabel().getName() + "'");
        if (!this.getLabel().getState().isRunningState()) {
            throw new ServersViewException("Cannot restart server in profile because it is not running");
        }
        this.operateServerState("Restart in Profile", ServersViewEnums.ServerState.PROFILING);
    }

    @Override
    public void debug() {
        this.select();
        log.info("Start server in debug '" + this.getLabel().getName() + "'");
        if (!ServersViewEnums.ServerState.STOPPED.equals((Object)this.getLabel().getState())) {
            throw new ServersViewException("Cannot debug server because it is not stopped");
        }
        this.operateServerState("Debug", ServersViewEnums.ServerState.DEBUGGING);
    }

    @Override
    public void profile() {
        this.select();
        log.info("Start server in profiling mode '" + this.getLabel().getName() + "'");
        if (!ServersViewEnums.ServerState.STOPPED.equals((Object)this.getLabel().getState())) {
            throw new ServersViewException("Cannot profile server because it is not stopped");
        }
        this.operateServerState("Profile", ServersViewEnums.ServerState.PROFILING);
    }

    @Override
    public void publish() {
        this.select();
        log.info("Publish server '" + this.getLabel().getName() + "'");
        PublishListenerCondition listenerCondition = new PublishListenerCondition();
        try {
            new ContextMenuItem(new String[]{"Publish"}).select();
            this.waitForPublish(listenerCondition);
        }
        finally {
            this.cleanupPublishListener(listenerCondition.getPublishListener());
        }
    }

    @Override
    public void clean() {
        this.select();
        log.info("Clean server '" + this.getLabel().getName() + "'");
        PublishListenerCondition listenerCondition = new PublishListenerCondition();
        try {
            new ContextMenuItem(new String[]{"Clean..."}).select();
            DefaultShell serverShell = new DefaultShell("Server");
            new PushButton("OK").click();
            new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)serverShell));
            this.waitForPublish(listenerCondition);
        }
        finally {
            this.cleanupPublishListener(listenerCondition.getPublishListener());
        }
    }

    private void cleanupServerListener(IServerListener listener) {
        if (listener != null) {
            org.eclipse.wst.server.core.internal.Server srv = this.getEclipseServer();
            srv.removeServerListener(listener);
        }
    }

    private void cleanupPublishListener(IPublishListener listener) {
        if (listener != null) {
            org.eclipse.wst.server.core.internal.Server srv = this.getEclipseServer();
            srv.removePublishListener(listener);
        }
    }

    @Override
    public void delete() {
        this.select();
        this.delete(false);
    }

    @Override
    public void delete(boolean stopFirst) {
        this.select();
        String name = this.getLabel().getName();
        log.info("Delete server '" + name + "'. Stop server first: " + stopFirst);
        ServersViewEnums.ServerState state = this.getLabel().getState();
        new ContextMenuItem(new String[]{"Delete"}).select();
        DefaultShell deleteShell = new DefaultShell("Delete Server");
        if (!ServersViewEnums.ServerState.STOPPED.equals((Object)state) && !ServersViewEnums.ServerState.NONE.equals((Object)state)) {
            new CheckBox().toggle(stopFirst);
        }
        new PushButton("OK").click();
        new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)deleteShell));
        long startTimeOfAction = System.currentTimeMillis();
        new WaitWhile((WaitCondition)new ServerExists(name), this.getServerStateChangeTimeout());
        new WaitWhile((WaitCondition)new JobIsRunning(), this.getRemainingTimeoutPeriod(this.getServerStateChangeTimeout(), startTimeOfAction));
    }

    @Override
    public TimePeriod getServerStateChangeTimeout() {
        return this.stateChangeTimeout;
    }

    @Override
    public void setServerStateChangeTimeout(TimePeriod timeout) {
        this.stateChangeTimeout = timeout;
    }

    @Override
    public TimePeriod getServerPublishTimeout() {
        return this.publishTimeout;
    }

    @Override
    public void setServerPublishTimeout(TimePeriod timeout) {
        this.publishTimeout = timeout;
    }

    @Override
    public ModifyModulesDialog addAndRemoveModules() {
        this.select();
        log.info("Add and remove modules of server");
        new ContextMenuItem(new String[]{ADD_AND_REMOVE}).select();
        return new ModifyModulesDialog();
    }

    @Override
    public void activate() {
        this.view.activate();
    }

    @Override
    public ServerModule getModule(String name) {
        return this.getModule((Matcher<String>)new IsEqual((Object)name));
    }

    @Override
    public <T extends ServerModule> T getModule(Class<T> clazz, String name) {
        return this.getModule(clazz, (Matcher<String>)new IsEqual((Object)name));
    }

    @Override
    public <T extends ServerModule> T getModule(Class<T> clazz, Matcher<String> stringMatcher) {
        ServerModule module = this.getModule(stringMatcher);
        return (T)((ServerModule)module.getAdapter(clazz));
    }

    @Override
    public ServerModule getModule(Matcher<String> stringMatcher) {
        for (ServerModule module : this.getModules()) {
            if (!stringMatcher.matches((Object)module.getLabel().getName())) continue;
            return module;
        }
        throw new EclipseLayerException("There is no module with name matching matcher " + stringMatcher.toString() + " on server " + this.getLabel().getName());
    }

    @Override
    public <T extends ServerModule> List<T> getModules(Class<T> clazz) {
        List<ServerModule> modules = this.getModules();
        return modules.stream().map(t -> (ServerModule)t.getAdapter(clazz)).collect(Collectors.toList());
    }

    @Override
    public List<ServerModule> getModules() {
        this.activate();
        ArrayList<ServerModule> modules = new ArrayList<ServerModule>();
        for (TreeItem item : this.treeItem.getItems()) {
            Object data = ItemHandler.getInstance().getData(item.getSWTWidget());
            if (!(data instanceof IModule) && !(data instanceof IServerModule)) continue;
            modules.add(this.createServerModule(item));
        }
        return modules;
    }

    public Object[] getAdapterConstructorArguments() {
        return new Object[]{this.treeItem};
    }

    public Class<?>[] getAdapterConstructorClasses() {
        return new Class[]{TreeItem.class};
    }

    protected void waitForPublish(PublishListenerCondition listenerCondition) {
        new GroupWait(this.getServerPublishTimeout(), new WaitWrapper[]{WaitProvider.waitUntil((WaitCondition)listenerCondition), WaitProvider.waitUntil((WaitCondition)new ServerHasPublishState(this, ServersViewEnums.ServerPublishState.SYNCHRONIZED)), WaitProvider.waitWhile((WaitCondition)new JobIsRunning())});
    }

    protected void operateServerState(String menuItem, ServersViewEnums.ServerState resultState) {
        log.debug("Triggering action: " + menuItem + " on server " + this.getLabel().getName());
        this.select();
        ServerListenerCondition listenerCondition = null;
        switch (resultState) {
            case STARTED: {
                listenerCondition = new ServerListenerCondition(2, "run");
                break;
            }
            case STOPPED: {
                listenerCondition = new ServerListenerCondition(4, null);
                break;
            }
            case DEBUGGING: {
                listenerCondition = new ServerListenerCondition(2, "debug");
                break;
            }
            case PROFILING: {
                listenerCondition = new ServerListenerCondition(2, "profile");
                break;
            }
            default: {
                throw new EclipseLayerException("Unknown state " + (Object)((Object)resultState));
            }
        }
        try {
            new ContextMenuItem(new String[]{menuItem}).select();
            new GroupWait(this.getServerStateChangeTimeout(), new WaitWrapper[]{WaitProvider.waitUntil((WaitCondition)listenerCondition), WaitProvider.waitUntil((WaitCondition)new ServerHasState(this, resultState)), WaitProvider.waitWhile((WaitCondition)new JobIsRunning())});
            log.debug("Operate server's state finished, the result server's state is: '" + (Object)((Object)this.getLabel().getState()) + "'");
        }
        finally {
            this.cleanupServerListener(listenerCondition.getServerListener());
        }
    }

    private TimePeriod getRemainingTimeoutPeriod(TimePeriod oldTimeout, long startTimeOfAction) {
        long diffTime = Math.round((System.currentTimeMillis() - startTimeOfAction) / 1000L);
        long remainingTimeout = oldTimeout.getSeconds() - diffTime;
        if (remainingTimeout < 0L) {
            return TimePeriod.NONE;
        }
        return TimePeriod.getCustom((long)remainingTimeout);
    }

    private ServerModule createServerModule(TreeItem item) {
        return new ServerModule(item, this.view);
    }

    private ServerEditor createServerEditor(String title) {
        return new ServerEditor(title);
    }

    private org.eclipse.wst.server.core.internal.Server getEclipseServer() {
        Object o = WidgetHandler.getInstance().getData(this.treeItem.getSWTWidget());
        return (org.eclipse.wst.server.core.internal.Server)o;
    }

    private static boolean isServerBundlePresent() {
        Bundle serverCoreBundle = Platform.getBundle((String)SERVER_CORE_BUNDLE);
        Bundle serverUIBundle = Platform.getBundle((String)SERVER_UI_BUNDLE);
        return serverCoreBundle != null && serverUIBundle != null;
    }

    class PublishListenerCondition
    extends AbstractWaitCondition {
        private boolean finished = false;
        private IPublishListener publishListener;

        public PublishListenerCondition() {
            org.eclipse.wst.server.core.internal.Server srv = AbstractServer.this.getEclipseServer();
            this.publishListener = new IPublishListener(){

                public void publishStarted(IServer arg0) {
                }

                public void publishFinished(IServer arg0, IStatus arg1) {
                    PublishListenerCondition.this.finished = true;
                }
            };
            srv.addPublishListener(this.publishListener);
        }

        public IPublishListener getPublishListener() {
            return this.publishListener;
        }

        public boolean test() {
            return this.finished;
        }

        public String description() {
            return "Server publish finished";
        }
    }

    class ServerListenerCondition
    extends AbstractWaitCondition {
        private int serverState;
        private String mode;
        private boolean finished = false;
        private IServerListener serverListener;

        public ServerListenerCondition(final int serverState, final String mode) {
            this.serverState = serverState;
            this.mode = mode;
            org.eclipse.wst.server.core.internal.Server srv = AbstractServer.this.getEclipseServer();
            this.serverListener = new IServerListener(){

                public void serverChanged(ServerEvent arg0) {
                    if (serverState == arg0.getServer().getServerState() && (mode == null || mode.equals(arg0.getServer().getMode()))) {
                        ServerListenerCondition.this.finished = true;
                    }
                }
            };
            srv.addServerListener(this.serverListener);
        }

        public IServerListener getServerListener() {
            return this.serverListener;
        }

        public boolean test() {
            return this.finished;
        }

        public String description() {
            if (this.mode != null) {
                return "Server has state " + this.serverState + " and mode " + this.mode;
            }
            return "Server has state " + this.serverState;
        }
    }
}

