/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.compile;

import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;

public class SystemCompileRemoteObjectMatcher {
    private String ssfId;
    private String nameFilter;
    private String typeFilter;
    private boolean allSsfs;
    private boolean allNames;
    private boolean allTypes;
    private boolean genericSsfStart;
    private boolean genericNamesStart;
    private boolean genericTypesStart;
    private boolean genericSsfEnd;
    private boolean genericNamesEnd;
    private boolean genericTypesEnd;
    private String ssfIdPart;
    private String nameFilterPart;
    private String typeFilterPart;

    public SystemCompileRemoteObjectMatcher(String ssfId, String nameFilter, String typeFilter) {
        this.ssfId = ssfId;
        this.nameFilter = nameFilter;
        this.typeFilter = typeFilter;
        if (ssfId == null) {
            ssfId = "*";
        }
        if (nameFilter == null) {
            nameFilter = "*";
        }
        if (typeFilter == null) {
            typeFilter = "*";
        }
        this.allSsfs = ssfId.equals("*");
        this.allNames = nameFilter.equals("*");
        this.allTypes = typeFilter.equals("*");
        this.genericSsfStart = !this.allSsfs && this.startsWithAsterisk(ssfId);
        this.genericNamesStart = !this.allNames && this.startsWithAsterisk(nameFilter);
        this.genericTypesStart = !this.allTypes && this.startsWithAsterisk(typeFilter);
        this.genericSsfEnd = !this.allSsfs && this.endsWithAsterisk(ssfId);
        this.genericNamesEnd = !this.allNames && this.endsWithAsterisk(nameFilter);
        boolean bl = this.genericTypesEnd = !this.allTypes && this.endsWithAsterisk(typeFilter);
        if (this.genericSsfStart) {
            this.ssfIdPart = this.stripLeadingAsterisk(ssfId);
        }
        if (this.genericNamesStart) {
            this.nameFilterPart = this.stripLeadingAsterisk(nameFilter);
        }
        if (this.genericTypesStart) {
            this.typeFilterPart = this.stripLeadingAsterisk(typeFilter);
        }
        if (this.genericSsfEnd) {
            this.ssfIdPart = this.stripTrailingAsterisk(ssfId);
        }
        if (this.genericNamesEnd) {
            this.nameFilterPart = this.stripTrailingAsterisk(nameFilter);
        }
        if (this.genericTypesEnd) {
            this.typeFilterPart = this.stripTrailingAsterisk(typeFilter);
        }
    }

    protected boolean startsWithAsterisk(String name) {
        return name.startsWith("*");
    }

    protected boolean endsWithAsterisk(String name) {
        return name.endsWith("*");
    }

    protected String stripLeadingAsterisk(String name) {
        return name.substring(1);
    }

    protected String stripTrailingAsterisk(String name) {
        return name.substring(0, name.length() - 1);
    }

    public String getSubSystemFactoryId() {
        return this.ssfId;
    }

    public String getNameFilter() {
        return this.nameFilter;
    }

    public String getTypeFilter() {
        return this.typeFilter;
    }

    public boolean appliesTo(Object element) {
        ISystemRemoteElementAdapter adapter = SystemAdapterHelpers.getRemoteAdapter((Object)element);
        if (adapter == null) {
            return false;
        }
        boolean applies = true;
        boolean ssfIdMatch = true;
        if (!this.allSsfs) {
            String subsystem = adapter.getSubSystemConfigurationId(element);
            if (this.ssfId == null) {
                ssfIdMatch = false;
            } else if (!this.genericSsfStart && !this.genericSsfEnd) {
                ssfIdMatch = subsystem.equals(this.ssfId);
            } else if (this.genericSsfStart) {
                ssfIdMatch = subsystem.endsWith(this.ssfIdPart);
            } else if (this.genericSsfEnd) {
                ssfIdMatch = subsystem.startsWith(this.ssfIdPart);
            }
        }
        if (!ssfIdMatch) {
            return false;
        }
        boolean nameMatch = true;
        if (!this.allNames) {
            String name = adapter.getName(element);
            if (name == null || !this.genericNamesStart) {
                nameMatch = false;
            } else if (!this.genericNamesStart && !this.genericNamesEnd) {
                nameMatch = name.equals(this.nameFilter);
            } else if (this.genericNamesStart) {
                nameMatch = name.endsWith(this.nameFilterPart);
            } else if (this.genericNamesEnd) {
                nameMatch = name.startsWith(this.nameFilterPart);
            }
        }
        if (!nameMatch) {
            return false;
        }
        boolean typeMatch = true;
        if (!this.allTypes) {
            String type = adapter.getRemoteSourceType(element);
            if (type == null) {
                typeMatch = false;
            } else if (!this.genericTypesStart && !this.genericTypesEnd) {
                typeMatch = type.equals(this.typeFilter);
            } else if (this.genericTypesStart) {
                typeMatch = type.endsWith(this.typeFilterPart);
            } else if (this.genericTypesEnd) {
                typeMatch = type.startsWith(this.typeFilterPart);
            }
        }
        if (!typeMatch) {
            return false;
        }
        return applies;
    }
}

