/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractFrame;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InteractionUse;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.VerticalSpaceExpansion;
import org.eclipse.sirius.diagram.sequence.ui.Messages;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.SequenceEditPartsOperations;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.ISequenceEventEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.InteractionUseEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy.AbstractFrameResizableEditPolicy;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.AbstractInteractionFrameValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.InteractionUseMoveValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.RequestQuery;
import org.eclipse.sirius.diagram.sequence.util.Range;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;
import org.eclipse.sirius.diagram.ui.tools.internal.edit.command.CommandFactory;

public class InteractionUseResizableEditPolicy
extends AbstractFrameResizableEditPolicy {
    protected Command getMoveCommand(ChangeBoundsRequest request) {
        this.cancelHorizontalDelta(request);
        Command result = super.getMoveCommand(request);
        InteractionUseEditPart iuep = (InteractionUseEditPart)this.getHost();
        InteractionUseMoveValidator validator = new InteractionUseMoveValidator((InteractionUse)iuep.getISequenceEvent(), new RequestQuery((Request)request));
        if (!validator.isValid()) {
            result = UnexecutableCommand.INSTANCE;
        }
        result = this.postProcessDefaultCommand(iuep, request, result, validator);
        return result;
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        Command result = super.getResizeCommand(request);
        InteractionUseEditPart iuep = (InteractionUseEditPart)this.getHost();
        AbstractInteractionFrameValidator validator = AbstractInteractionFrameValidator.getOrCreateResizeValidator(request, (AbstractFrame)((InteractionUse)iuep.getISequenceEvent()));
        if (!validator.isValid()) {
            result = UnexecutableCommand.INSTANCE;
        }
        result = this.postProcessDefaultCommand(iuep, request, result, validator);
        return result;
    }

    private Command postProcessDefaultCommand(InteractionUseEditPart self, ChangeBoundsRequest request, Command defaultCommand, AbstractInteractionFrameValidator validator) {
        Command result = defaultCommand;
        if (result != null && result.canExecute()) {
            CompositeTransactionalCommand ctc = new CompositeTransactionalCommand(self.getEditingDomain(), Messages.InteractionUseResizableEditPolicy_moveCompositeCommand);
            ctc.setLabel(String.valueOf(defaultCommand.getLabel()));
            ctc.compose((IUndoableOperation)new CommandProxy(defaultCommand));
            Range expansionZone = validator.getExpansionZone();
            if (expansionZone != null && !expansionZone.isEmpty()) {
                ISequenceEvent iSequenceEvent = self.getISequenceEvent();
                SequenceDiagram diagram = iSequenceEvent.getDiagram();
                List<ISequenceEvent> eventToIgnore = Collections.singletonList(iSequenceEvent);
                ICommand autoExpand = CommandFactory.createICommand((TransactionalEditingDomain)self.getEditingDomain(), (AbstractModelChangeOperation)new VerticalSpaceExpansion(diagram, expansionZone, Integer.valueOf(0), eventToIgnore));
                ctc.compose((IUndoableOperation)autoExpand);
            }
            SequenceEditPartsOperations.addRefreshGraphicalOrderingCommand(ctc, (IGraphicalEditPart)self);
            SequenceEditPartsOperations.addRefreshSemanticOrderingCommand(ctc, (IGraphicalEditPart)self);
            SequenceEditPartsOperations.addSynchronizeSemanticOrderingCommand(ctc, self.getISequenceEvent());
            result = new ICommandProxy((ICommand)ctc);
        }
        return result;
    }

    @Override
    protected Collection<ISequenceEventEditPart> getChildrenToFeedBack(ChangeBoundsRequest request) {
        return new ArrayList<ISequenceEventEditPart>();
    }
}

