/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.controls.validator;

import org.eclipse.tcf.te.ui.controls.validator.NameOrIPValidator;

public class NetMaskValidator
extends NameOrIPValidator {
    public NetMaskValidator(int attributes) {
        super(4);
        if (NetMaskValidator.isAttribute(1, attributes)) {
            this.addAttribute(1);
        }
    }

    @Override
    public boolean isValid(String netMask) {
        if (super.isValid(netMask)) {
            String[] bytes = netMask.split("\\.");
            int oldByte = 255;
            int i = 0;
            while (i < bytes.length) {
                int actByte = Integer.parseInt(bytes[i]);
                if (oldByte < 255 && actByte > 0 || oldByte == 255 && !this.isValidNetMaskByte(actByte)) {
                    return false;
                }
                oldByte = actByte;
                ++i;
            }
            return true;
        }
        return false;
    }

    private boolean isValidNetMaskByte(int netMaskByte) {
        switch (netMaskByte) {
            case 0: 
            case 128: 
            case 192: 
            case 224: 
            case 240: 
            case 248: 
            case 252: 
            case 254: 
            case 255: {
                return true;
            }
        }
        return false;
    }
}

