/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client.listeners;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSStatus;

public class ServerMessageLineMatcher {
    protected static final Pattern VARIABLE_MATCHING_PATTERN = Pattern.compile("(\\((\\w*):.*:\\2\\))");
    Pattern pattern;
    String[] variables;

    public ServerMessageLineMatcher(String template, String[] expectedVariables) throws CVSException {
        Matcher matcher = VARIABLE_MATCHING_PATTERN.matcher(template);
        ArrayList<String> variables = new ArrayList<String>();
        while (matcher.find()) {
            if (matcher.groupCount() != 2) {
                CVSStatus status = new CVSStatus(4, NLS.bind((String)CVSMessages.ServerMessageLineMatcher_5, (Object[])new String[]{template}));
                throw new CVSException((IStatus)status);
            }
            variables.add(matcher.group(2));
        }
        this.ensureMatches(template, variables, expectedVariables);
        this.variables = variables.toArray(new String[variables.size()]);
        for (String element : variables) {
            template = template.replaceAll(String.valueOf(element) + ":", "");
            template = template.replaceAll(":" + element, "");
        }
        int count = 0;
        int start = -1;
        while ((start = template.indexOf(40, start + 1)) != -1) {
            ++count;
        }
        if (count != variables.size()) {
            CVSStatus status = new CVSStatus(4, NLS.bind((String)CVSMessages.ServerMessageLineMatcher_6, (Object[])new String[]{template}));
            throw new CVSException((IStatus)status);
        }
        this.pattern = Pattern.compile(template);
    }

    private void ensureMatches(String template, List variables, String[] expectedVariables) throws CVSException {
        int i = 0;
        while (i < expectedVariables.length) {
            String expected = expectedVariables[i];
            if (!variables.contains(expected)) {
                CVSStatus status = new CVSStatus(4, NLS.bind((String)CVSMessages.ServerMessageLineMatcher_7, (Object[])new String[]{expected, template}));
                throw new CVSException((IStatus)status);
            }
            ++i;
        }
    }

    public Map processServerMessage(String line) {
        Matcher matcher = this.pattern.matcher(line);
        if (!matcher.find()) {
            return null;
        }
        Assert.isTrue((matcher.groupCount() == this.variables.length ? 1 : 0) != 0);
        HashMap<String, String> result = new HashMap<String, String>();
        int i = 1;
        while (i <= matcher.groupCount()) {
            result.put(this.variables[i - 1], matcher.group(i));
            ++i;
        }
        return result;
    }
}

