/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.trace.experiment;

import com.google.common.collect.HashMultimap;
import java.io.File;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.internal.tmf.core.synchronization.TmfTimestampTransform;
import org.eclipse.tracecompass.internal.tmf.core.trace.experiment.TmfExperimentContext;
import org.eclipse.tracecompass.internal.tmf.core.trace.experiment.TmfExperimentLocation;
import org.eclipse.tracecompass.internal.tmf.core.trace.experiment.TmfLocationArray;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.project.model.ITmfPropertiesProvider;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSynchronizedSignal;
import org.eclipse.tracecompass.tmf.core.synchronization.ITmfTimestampTransform;
import org.eclipse.tracecompass.tmf.core.synchronization.SynchronizationAlgorithm;
import org.eclipse.tracecompass.tmf.core.synchronization.SynchronizationManager;
import org.eclipse.tracecompass.tmf.core.synchronization.TimestampTransformFactory;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfPersistentlyIndexable;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfTraceIndexer;
import org.eclipse.tracecompass.tmf.core.trace.indexer.TmfBTreeTraceIndexer;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;

public class TmfExperiment
extends TmfTrace
implements ITmfPersistentlyIndexable {
    private static final String SYNCHRONIZATION_FILE_NAME = "synchronization.bin";
    private static final String SYNCHRONIZATION_DIRECTORY = "sync_data";
    public static final int DEFAULT_INDEX_PAGE_SIZE = 5000;
    private static final String CLOCK_OFFSET_PROPERTY = "clock_offset";
    private static final long CLOCK_OFFSET_THRESHOLD_NS = 500000L;
    private boolean fInitialized = false;
    private final Lock fSyncLock = new ReentrantLock();

    @Deprecated
    public TmfExperiment() {
    }

    public TmfExperiment(Class<? extends ITmfEvent> type, String path, ITmfTrace[] traces, int indexPageSize, @Nullable IResource resource) {
        this.initExperiment(type, path, traces, indexPageSize, resource);
    }

    @Override
    protected ITmfTraceIndexer createIndexer(int interval) {
        if (this.getCheckpointSize() > 0) {
            return new TmfBTreeTraceIndexer(this, interval);
        }
        return super.createIndexer(interval);
    }

    @Override
    public synchronized void dispose() {
        if (this.getIndexer() != null) {
            this.getIndexer().dispose();
        }
        super.dispose();
    }

    @Override
    public void initTrace(IResource resource, String path, Class<? extends ITmfEvent> type) {
    }

    public void initExperiment(Class<? extends ITmfEvent> type, String path, ITmfTrace[] traces, int indexPageSize, @Nullable IResource resource) {
        this.setCacheSize(indexPageSize);
        this.setStreamingInterval(0L);
        HashMultimap tracesPerHost = HashMultimap.create();
        if (traces != null) {
            ITmfTrace[] iTmfTraceArray = traces;
            int n = traces.length;
            int n2 = 0;
            while (n2 < n) {
                ITmfTrace trace2 = iTmfTraceArray[n2];
                if (trace2 != null) {
                    tracesPerHost.put((Object)trace2.getHostId(), (Object)trace2);
                    this.addChild(trace2);
                }
                ++n2;
            }
        }
        try {
            super.initialize(resource, path, type);
        }
        catch (TmfTraceException e) {
            Activator.logError("Error initializing experiment", e);
        }
        if (resource != null) {
            this.synchronizeTraces();
        }
        Function<ITmfPropertiesProvider, @Nullable Long> offsetGetter = trace -> {
            String offset = trace.getProperties().get(CLOCK_OFFSET_PROPERTY);
            if (offset == null) {
                return null;
            }
            try {
                return Long.parseLong(offset);
            }
            catch (NumberFormatException e) {
                return null;
            }
        };
        for (Collection values : tracesPerHost.asMap().values()) {
            Collection tracesToSynchronize = values.stream().filter(ITmfPropertiesProvider.class::isInstance).map(ITmfPropertiesProvider.class::cast).filter(trace -> offsetGetter.apply((ITmfPropertiesProvider)trace) != null).collect(Collectors.toList());
            if (tracesToSynchronize.size() < 2 || tracesToSynchronize.stream().map(trace -> ((ITmfTrace)((Object)trace)).getTimestampTransform()).anyMatch(transform -> !transform.equals(TmfTimestampTransform.IDENTITY))) continue;
            BigInteger sum = BigInteger.ZERO;
            for (ITmfPropertiesProvider trace3 : tracesToSynchronize) {
                long offset = (Long)NonNullUtils.checkNotNull((Object)offsetGetter.apply(trace3));
                sum = sum.add(BigInteger.valueOf(offset));
            }
            long average = sum.divide(BigInteger.valueOf(tracesToSynchronize.size())).longValue();
            if (average > 500000L) {
                Activator.logWarning("Average clock correction (" + average + ") is higher than threshold of " + 500000L + " ns for experiment " + this.toString());
            }
            tracesToSynchronize.forEach(t -> {
                long offset = (Long)NonNullUtils.checkNotNull((Object)((Long)offsetGetter.apply((ITmfPropertiesProvider)t)));
                long delta = average - offset;
                ITmfTrace trace = (ITmfTrace)((Object)t);
                ITmfTimestampTransform currentTransform = trace.getTimestampTransform();
                ITmfTimestampTransform newTransform = TimestampTransformFactory.createWithOffset(delta);
                if (!newTransform.equals(currentTransform)) {
                    TmfTraceManager.deleteSupplementaryFiles(trace);
                    trace.setTimestampTransform(newTransform);
                }
            });
        }
    }

    @Override
    public IStatus validate(IProject project, String path) {
        return Status.OK_STATUS;
    }

    public List<@NonNull ITmfTrace> getTraces() {
        return this.getChildren(ITmfTrace.class);
    }

    public ITmfTimestamp getTimestamp(int index) {
        ITmfContext context = this.seekEvent(index);
        ITmfEvent event = this.getNext(context);
        context.dispose();
        return event != null ? event.getTimestamp() : null;
    }

    @Override
    public synchronized ITmfContext armRequest(ITmfEventRequest request) {
        if (this.getChildren().isEmpty()) {
            return null;
        }
        if (!TmfTimestamp.BIG_BANG.equals(request.getRange().getStartTime()) && request.getIndex() == 0L) {
            ITmfContext context = this.seekEvent(request.getRange().getStartTime());
            request.setStartIndex((int)context.getRank());
            return context;
        }
        return this.seekEvent(request.getIndex());
    }

    @Override
    public synchronized ITmfContext seekEvent(ITmfLocation location) {
        if (location != null && !(location instanceof TmfExperimentLocation)) {
            return null;
        }
        int length = this.getNbChildren();
        TmfLocationArray locationArray = location == null ? new TmfLocationArray(length) : ((TmfExperimentLocation)location).getLocationInfo();
        ITmfLocation[] locations = locationArray.getLocations();
        long[] ranks = locationArray.getRanks();
        TmfExperimentContext context = new TmfExperimentContext(length);
        long rank = 0L;
        int i = 0;
        while (i < length) {
            ITmfContext traceContext = ((ITmfTrace)this.getChild(i)).seekEvent(locations[i]);
            traceContext.setRank(ranks[i]);
            locations[i] = traceContext.getLocation();
            context.setContent(i, traceContext, ((ITmfTrace)this.getChild(i)).getNext(traceContext));
            rank += ranks[i];
            ++i;
        }
        context.setLocation(new TmfExperimentLocation(new TmfLocationArray(locations, ranks)));
        context.setRank(rank);
        return context;
    }

    @Override
    public ITmfContext seekEvent(double ratio) {
        ITmfContext context = this.seekEvent(Math.round(ratio * (double)this.getNbEvents()));
        return context;
    }

    @Override
    public double getLocationRatio(ITmfLocation location) {
        if (location instanceof TmfExperimentLocation) {
            long rank = 0L;
            TmfLocationArray locationArray = ((TmfExperimentLocation)location).getLocationInfo();
            int i = 0;
            while (i < locationArray.size()) {
                rank += locationArray.getRank(i);
                ++i;
            }
            return (double)rank / (double)this.getNbEvents();
        }
        return 0.0;
    }

    @Override
    public ITmfLocation getCurrentLocation() {
        return null;
    }

    @Override
    public synchronized ITmfEvent parseEvent(ITmfContext context) {
        ITmfContext tmpContext = this.seekEvent(context.getLocation());
        ITmfEvent event = this.getNext(tmpContext);
        return event;
    }

    @Override
    public synchronized ITmfEvent getNext(ITmfContext context) {
        if (this.getNbChildren() == 0) {
            return null;
        }
        if (!(context instanceof TmfExperimentContext)) {
            return null;
        }
        TmfExperimentContext experimentContext = (TmfExperimentContext)context;
        TmfExperimentContext.ContextTuple next = experimentContext.getNext();
        ITmfEvent event = null;
        if (next != null) {
            event = next.getEvent();
            this.updateAttributes(experimentContext, event);
            experimentContext.increaseRank();
            ITmfLocation location = experimentContext.getLocation();
            if (location instanceof TmfExperimentLocation) {
                int trace = next.getIndex();
                ITmfContext traceContext = next.getContext();
                TmfLocationArray locationArray = new TmfLocationArray(((TmfExperimentLocation)location).getLocationInfo(), trace, traceContext.getLocation(), traceContext.getRank());
                experimentContext.setLocation(new TmfExperimentLocation(locationArray));
                ITmfEvent nextEvent = ((ITmfTrace)this.getChild(trace)).getNext(traceContext);
                experimentContext.setContent(trace, traceContext, nextEvent);
            }
        }
        return event;
    }

    @Override
    public ITmfTimestamp getInitialRangeOffset() {
        List<ITmfTrace> children = this.getChildren(ITmfTrace.class);
        if (children.isEmpty()) {
            return super.getInitialRangeOffset();
        }
        ITmfTimestamp initTs = TmfTimestamp.BIG_CRUNCH;
        for (ITmfTrace trace : children) {
            ITmfTimestamp ts = trace.getInitialRangeOffset();
            if (ts.compareTo(initTs) >= 0) continue;
            initTs = ts;
        }
        return initTs;
    }

    public String getSynchronizationFolder(boolean absolute) {
        IResource resource = this.getResource();
        String syncDirectory = null;
        try {
            if (resource != null) {
                String fullDirectory = resource.getPersistentProperty(TmfCommonConstants.TRACE_SUPPLEMENTARY_FOLDER);
                if (fullDirectory != null) {
                    fullDirectory = String.valueOf(fullDirectory) + File.separator + SYNCHRONIZATION_DIRECTORY;
                    File syncDir = new File(fullDirectory);
                    syncDir.mkdirs();
                }
                syncDirectory = absolute ? fullDirectory : SYNCHRONIZATION_DIRECTORY;
            }
        }
        catch (CoreException e) {
            return null;
        }
        return syncDirectory;
    }

    public SynchronizationAlgorithm synchronizeTraces() {
        return this.synchronizeTraces(false);
    }

    public SynchronizationAlgorithm synchronizeTraces(boolean doSync) {
        this.fSyncLock.lock();
        try {
            String syncDirectory = this.getSynchronizationFolder(true);
            File syncFile = syncDirectory != null ? new File(String.valueOf(syncDirectory) + File.separator + SYNCHRONIZATION_FILE_NAME) : null;
            SynchronizationAlgorithm syncAlgo = SynchronizationManager.synchronizeTraces(syncFile, Collections.singleton(this), doSync);
            final TmfTraceSynchronizedSignal signal = new TmfTraceSynchronizedSignal((Object)this, syncAlgo);
            new Thread(){

                @Override
                public void run() {
                    TmfExperiment.this.broadcast(signal);
                }
            }.start();
            SynchronizationAlgorithm synchronizationAlgorithm = syncAlgo;
            return synchronizationAlgorithm;
        }
        finally {
            this.fSyncLock.unlock();
        }
    }

    @Override
    public synchronized String toString() {
        return "[TmfExperiment (" + this.getName() + ")]";
    }

    private synchronized void initializeStreamingMonitor() {
        if (this.fInitialized) {
            return;
        }
        this.fInitialized = true;
        if (this.getStreamingInterval() == 0L) {
            ITmfContext context = this.seekEvent(0L);
            ITmfEvent event = this.getNext(context);
            context.dispose();
            if (event == null) {
                return;
            }
            TmfTimeRange timeRange = new TmfTimeRange(event.getTimestamp(), TmfTimestamp.BIG_CRUNCH);
            final TmfTraceRangeUpdatedSignal signal = new TmfTraceRangeUpdatedSignal(this, this, timeRange);
            new Thread(){

                @Override
                public void run() {
                    TmfExperiment.this.broadcast(signal);
                }
            }.start();
            return;
        }
        Thread thread = new Thread("Streaming Monitor for experiment " + this.getName()){
            private ITmfTimestamp safeTimestamp;
            private ITmfTimestamp lastSafeTimestamp;
            private TmfTimeRange timeRange;
            {
                this.safeTimestamp = null;
                this.lastSafeTimestamp = null;
                this.timeRange = null;
            }

            @Override
            public void run() {
                while (!TmfExperiment.this.executorIsShutdown()) {
                    if (!TmfExperiment.this.getIndexer().isIndexing()) {
                        ITmfTimestamp startTimestamp = TmfTimestamp.BIG_CRUNCH;
                        ITmfTimestamp endTimestamp = TmfTimestamp.BIG_BANG;
                        for (ITmfTrace trace : TmfExperiment.this.getChildren(ITmfTrace.class)) {
                            if (trace.getStartTime().compareTo(startTimestamp) < 0) {
                                startTimestamp = trace.getStartTime();
                            }
                            if (trace.getStreamingInterval() == 0L || trace.getEndTime().compareTo(endTimestamp) <= 0) continue;
                            endTimestamp = trace.getEndTime();
                        }
                        ITmfTimestamp safeTs = this.safeTimestamp;
                        if (safeTs != null && (this.lastSafeTimestamp == null || safeTs.compareTo(this.lastSafeTimestamp) > 0)) {
                            this.timeRange = new TmfTimeRange(startTimestamp, safeTs);
                            this.lastSafeTimestamp = safeTs;
                        } else {
                            this.timeRange = null;
                        }
                        this.safeTimestamp = endTimestamp;
                        if (this.timeRange != null) {
                            TmfTraceRangeUpdatedSignal signal = new TmfTraceRangeUpdatedSignal(TmfExperiment.this, TmfExperiment.this, this.timeRange);
                            TmfExperiment.this.broadcast(signal);
                        }
                    }
                    try {
                        Thread.sleep(TmfExperiment.this.getStreamingInterval());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        };
        thread.start();
    }

    @Override
    public long getStreamingInterval() {
        long interval = 0L;
        for (ITmfTrace trace : this.getChildren(ITmfTrace.class)) {
            interval = Math.max(interval, trace.getStreamingInterval());
        }
        return interval;
    }

    @Override
    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        if (signal.getTrace() == this) {
            this.initializeStreamingMonitor();
            MultiStatus status = new MultiStatus("org.eclipse.tracecompass.tmf.core", 0, null, null);
            status.add(this.executeAnalysis());
            if (!status.isOK()) {
                Activator.log((IStatus)status);
            }
            new Thread("Refresh supplementary files"){

                @Override
                public void run() {
                    TmfTraceManager.refreshSupplementaryFiles(TmfExperiment.this);
                }
            }.start();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized int getCheckpointSize() {
        int totalCheckpointSize = 0;
        try {
            List<ITmfTrace> children = this.getChildren(ITmfTrace.class);
            Iterator<ITmfTrace> iterator = children.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return totalCheckpointSize;
                }
                ITmfTrace trace = iterator.next();
                if (!(trace instanceof ITmfPersistentlyIndexable)) {
                    return 0;
                }
                ITmfPersistentlyIndexable persistableIndexTrace = (ITmfPersistentlyIndexable)((Object)trace);
                int currentTraceCheckpointSize = persistableIndexTrace.getCheckpointSize();
                if (currentTraceCheckpointSize <= 0) {
                    return 0;
                }
                totalCheckpointSize += currentTraceCheckpointSize;
                totalCheckpointSize += 8;
            }
        }
        catch (UnsupportedOperationException e) {
            return 0;
        }
    }

    @Override
    public ITmfLocation restoreLocation(ByteBuffer bufferIn) {
        List<ITmfTrace> children = this.getChildren(ITmfTrace.class);
        int length = children.size();
        ITmfLocation[] locations = new ITmfLocation[length];
        long[] ranks = new long[length];
        int i = 0;
        while (i < length) {
            ITmfTrace trace = children.get(i);
            locations[i] = ((ITmfPersistentlyIndexable)((Object)trace)).restoreLocation(bufferIn);
            ranks[i] = bufferIn.getLong();
            ++i;
        }
        TmfLocationArray arr = new TmfLocationArray(locations, ranks);
        TmfExperimentLocation l = new TmfExperimentLocation(arr);
        return l;
    }
}

