/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts;

import java.util.Arrays;
import java.util.Formatter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.ITmfChartTimeProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfBaseProvider;
import org.swtchart.IAxis;
import org.swtchart.ISeries;

public class TmfCommonXLineChartTooltipProvider
extends TmfBaseProvider
implements MouseTrackListener {
    public TmfCommonXLineChartTooltipProvider(ITmfChartTimeProvider tmfChartViewer) {
        super(tmfChartViewer);
        this.register();
    }

    @Override
    public void register() {
        this.getChart().getPlotArea().addMouseTrackListener((MouseTrackListener)this);
    }

    @Override
    public void deregister() {
        if (this.getChartViewer().getControl() != null && !this.getChartViewer().getControl().isDisposed()) {
            this.getChart().getPlotArea().removeMouseTrackListener((MouseTrackListener)this);
        }
    }

    @Override
    public void refresh() {
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
    }

    public void mouseHover(MouseEvent e) {
        if (this.getChartViewer().getWindowDuration() != 0L) {
            IAxis xAxis = this.getChart().getAxisSet().getXAxis(0);
            double xCoordinate = xAxis.getDataCoordinate(e.x);
            ISeries[] series = this.getChart().getSeriesSet().getSeries();
            if (xCoordinate < 0.0 || series.length == 0) {
                return;
            }
            double[] xS = series[0].getXSeries();
            if (xS == null) {
                return;
            }
            int index = Arrays.binarySearch(xS, xCoordinate);
            index = index >= 0 ? index : -index - 1;
            int maxLen = 0;
            ISeries[] iSeriesArray = series;
            int n = series.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries serie = iSeriesArray[n2];
                if (TmfCommonXLineChartTooltipProvider.isValid(index, serie)) {
                    maxLen = Math.max(maxLen, serie.getId().length());
                }
                ++n2;
            }
            StringBuilder buffer = new StringBuilder(String.valueOf(Messages.TmfCommonXLineChartTooltipProvider_time) + "\t" + TmfTimestamp.fromNanos((long)((long)xCoordinate + this.getChartViewer().getTimeOffset())).toString() + "\n");
            String formatString = "%-" + maxLen + "s%12.2f%n";
            Throwable throwable = null;
            iSeriesArray = null;
            try (Formatter formatter = new Formatter(buffer);){
                ISeries[] iSeriesArray2 = series;
                int n3 = series.length;
                int n4 = 0;
                while (n4 < n3) {
                    ISeries serie = iSeriesArray2[n4];
                    double[] yS = serie.getYSeries();
                    if (TmfCommonXLineChartTooltipProvider.isValid(index, serie)) {
                        formatter.format(formatString, serie.getId(), yS[index]);
                    }
                    ++n4;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.getChart().getPlotArea().setToolTipText(buffer.toString());
            this.getChart().redraw();
        }
    }

    private static boolean isValid(int index, ISeries serie) {
        double[] ySeries = serie.getYSeries();
        return serie.isVisible() && ySeries != null && ySeries.length > index;
    }
}

