/**
 * Copyright (c) 2010-2015, Grill Balázs, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * Grill Balázs - initial API and implementation
 */
package org.eclipse.viatra.query.testing.core.api;

import com.google.common.base.Equivalence;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra.query.testing.core.SnapshotHelper;
import org.eclipse.viatra.query.testing.core.api.JavaObjectAccess;
import org.eclipse.viatra.query.testing.snapshot.MatchRecord;
import org.eclipse.viatra.query.testing.snapshot.MatchSubstitutionRecord;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * @author Grill Balázs
 */
@SuppressWarnings("all")
public abstract class MatchRecordEquivalence extends Equivalence<MatchRecord> {
  @Extension
  protected SnapshotHelper helper;
  
  protected Map<String, JavaObjectAccess> accessMap;
  
  public MatchRecordEquivalence(final Map<String, JavaObjectAccess> accessMap) {
    this.accessMap = accessMap;
    SnapshotHelper _snapshotHelper = new SnapshotHelper(accessMap);
    this.helper = _snapshotHelper;
  }
  
  public HashSet<Equivalence.Wrapper<MatchRecord>> wrap(final Iterable<MatchRecord> matches) {
    final Function1<MatchRecord, Equivalence.Wrapper<MatchRecord>> _function = (MatchRecord it) -> {
      return this.<MatchRecord>wrap(it);
    };
    return Sets.<Equivalence.Wrapper<MatchRecord>>newHashSet(IterableExtensions.<MatchRecord, Equivalence.Wrapper<MatchRecord>>map(matches, _function));
  }
  
  public HashSet<MatchRecord> unwrap(final Iterable<Equivalence.Wrapper<MatchRecord>> wrapped) {
    final Function1<Equivalence.Wrapper<MatchRecord>, MatchRecord> _function = (Equivalence.Wrapper<MatchRecord> it) -> {
      return it.get();
    };
    return Sets.<MatchRecord>newHashSet(IterableExtensions.<Equivalence.Wrapper<MatchRecord>, MatchRecord>map(wrapped, _function));
  }
  
  public HashMap<String, Object> toMap(final MatchRecord record) {
    final HashMap<String, Object> result = CollectionLiterals.<String, Object>newHashMap();
    EList<MatchSubstitutionRecord> _substitutions = record.getSubstitutions();
    for (final MatchSubstitutionRecord sub : _substitutions) {
      result.put(sub.getParameterName(), this.helper.derivedValue(sub));
    }
    return result;
  }
}
