/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.MigLayout.model.ui;

import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.internal.swing.MigLayout.model.CellConstraintsSupport;
import org.eclipse.wb.internal.swing.MigLayout.model.ui.ErrorMessageTextField;

public final class CellSpecificationComposite
extends Composite {
    private final ErrorMessageTextField m_field;
    private final Text m_textWidget;
    private final Listener m_listener = new Listener(){

        public void handleEvent(Event e) {
            String s = CellSpecificationComposite.this.m_textWidget.getText();
            CellSpecificationComposite.this.toCell(s);
        }
    };
    private boolean m_updatingCell;
    private CellConstraintsSupport m_cell;

    public CellSpecificationComposite(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.m_field = new ErrorMessageTextField(this, 2048);
        this.m_textWidget = (Text)this.m_field.getControl();
        this.m_textWidget.addListener(24, this.m_listener);
    }

    public boolean setFocus() {
        return this.m_textWidget.setFocus();
    }

    public void fromCell(CellConstraintsSupport cell) {
        if (!this.m_updatingCell) {
            this.m_cell = cell;
            String specification = this.m_cell.getString();
            if (!this.m_textWidget.getText().equals(specification)) {
                this.setText(specification);
            }
        }
    }

    private void toCell(String s) {
        this.m_updatingCell = true;
        try {
            try {
                this.m_cell.setString(s);
                this.notifyModified(true);
                this.m_field.setErrorMessage(null);
            }
            catch (Throwable e) {
                this.notifyModified(false);
                this.m_field.setErrorMessage(e.getMessage());
                this.m_updatingCell = false;
            }
        }
        finally {
            this.m_updatingCell = false;
        }
    }

    private void notifyModified(boolean valid) {
        Event event = new Event();
        event.doit = valid;
        this.notifyListeners(24, event);
    }

    private void setText(String text) {
        this.m_textWidget.removeListener(24, this.m_listener);
        try {
            this.m_textWidget.setText(text);
            this.m_field.setErrorMessage(null);
        }
        finally {
            this.m_textWidget.addListener(24, this.m_listener);
        }
    }
}

