/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.profiler.profilermodel.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xtend.profiler.profilermodel.CallGroup;
import org.eclipse.xtend.profiler.profilermodel.Cycle;
import org.eclipse.xtend.profiler.profilermodel.Item;
import org.eclipse.xtend.profiler.profilermodel.ModelPackage;
import org.eclipse.xtend.profiler.profilermodel.impl.CallableImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemImpl
extends CallableImpl
implements Item {
    protected static final String ITEM_NAME_EDEFAULT = "";
    protected String itemName = "";
    protected static final long ITEM_TIME_EDEFAULT = 0L;
    protected long itemTime = 0L;
    protected static final int CALL_COUNT_EDEFAULT = 0;
    protected EList<CallGroup> subroutines;
    protected EList<CallGroup> invocations;
    protected Cycle cycle;

    protected ItemImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return ModelPackage.Literals.ITEM;
    }

    @Override
    public String getName() {
        return String.valueOf(this.getItemName()) + (this.getCycle() == null ? ITEM_NAME_EDEFAULT : " <" + this.getCycle().getName() + ">");
    }

    @Override
    public long getBruttoTime() {
        return this.getItemTime();
    }

    @Override
    public long getTime() {
        return this.getSelfTime() + this.getOutboundChildTime();
    }

    @Override
    public String getItemName() {
        return this.itemName;
    }

    @Override
    public void setItemName(String newItemName) {
        String oldItemName = this.itemName;
        this.itemName = newItemName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldItemName, (Object)this.itemName));
        }
    }

    @Override
    public long getItemTime() {
        return this.itemTime;
    }

    @Override
    public void setItemTime(long newItemTime) {
        long oldItemTime = this.itemTime;
        this.itemTime = newItemTime;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, oldItemTime, this.itemTime));
        }
    }

    @Override
    public int getCallCount() {
        int result = 0;
        for (CallGroup invocation : this.getInvocations()) {
            result += invocation.getCount();
        }
        return result;
    }

    @Override
    public long getOutboundChildTime() {
        long result = 0L;
        for (CallGroup g : this.getSubroutines()) {
            Item s = g.getSubroutine();
            if (s.isSameCycle(this)) continue;
            result += g.getTime();
        }
        return result;
    }

    @Override
    public long getChildTime() {
        long result = 0L;
        for (CallGroup sub : this.getSubroutines()) {
            result += sub.getTime();
        }
        return result;
    }

    @Override
    public EList<CallGroup> getSubroutines() {
        if (this.subroutines == null) {
            this.subroutines = new EObjectWithInverseResolvingEList(CallGroup.class, (InternalEObject)this, 8, 0);
        }
        return this.subroutines;
    }

    @Override
    public EList<CallGroup> getInvocations() {
        if (this.invocations == null) {
            this.invocations = new EObjectWithInverseResolvingEList(CallGroup.class, (InternalEObject)this, 9, 1);
        }
        return this.invocations;
    }

    @Override
    public Cycle getCycle() {
        if (this.cycle != null && this.cycle.eIsProxy()) {
            InternalEObject oldCycle = (InternalEObject)this.cycle;
            this.cycle = (Cycle)this.eResolveProxy(oldCycle);
            if (this.cycle != oldCycle && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 10, (Object)oldCycle, (Object)this.cycle));
            }
        }
        return this.cycle;
    }

    public Cycle basicGetCycle() {
        return this.cycle;
    }

    public NotificationChain basicSetCycle(Cycle newCycle, NotificationChain msgs) {
        Cycle oldCycle = this.cycle;
        this.cycle = newCycle;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldCycle, (Object)newCycle);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setCycle(Cycle newCycle) {
        if (newCycle != this.cycle) {
            NotificationChain msgs = null;
            if (this.cycle != null) {
                msgs = ((InternalEObject)this.cycle).eInverseRemove((InternalEObject)this, 5, Cycle.class, msgs);
            }
            if (newCycle != null) {
                msgs = ((InternalEObject)newCycle).eInverseAdd((InternalEObject)this, 5, Cycle.class, msgs);
            }
            if ((msgs = this.basicSetCycle(newCycle, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)newCycle, (Object)newCycle));
        }
    }

    @Override
    public EList<CallGroup> getInboundInvocations() {
        BasicEList result = new BasicEList();
        for (CallGroup g : this.getInvocations()) {
            if (g.getInvoker().isSameCycle(this)) continue;
            result.add((Object)g);
        }
        return result;
    }

    @Override
    public boolean isSameCycle(Item item) {
        return this.getCycle() != null && this.getCycle().equals(item.getCycle());
    }

    @Override
    public int getCallCountInCycle(Cycle cycle) {
        int result = 0;
        for (CallGroup invocation : this.getInvocations()) {
            if (!cycle.equals(invocation.getInvoker().getCycle())) continue;
            result += invocation.getCount();
        }
        return result;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 8: {
                return ((InternalEList)this.getSubroutines()).basicAdd((Object)otherEnd, msgs);
            }
            case 9: {
                return ((InternalEList)this.getInvocations()).basicAdd((Object)otherEnd, msgs);
            }
            case 10: {
                if (this.cycle != null) {
                    msgs = ((InternalEObject)this.cycle).eInverseRemove((InternalEObject)this, 5, Cycle.class, msgs);
                }
                return this.basicSetCycle((Cycle)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 8: {
                return ((InternalEList)this.getSubroutines()).basicRemove((Object)otherEnd, msgs);
            }
            case 9: {
                return ((InternalEList)this.getInvocations()).basicRemove((Object)otherEnd, msgs);
            }
            case 10: {
                return this.basicSetCycle(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 5: {
                return this.getItemName();
            }
            case 6: {
                return this.getItemTime();
            }
            case 7: {
                return this.getCallCount();
            }
            case 8: {
                return this.getSubroutines();
            }
            case 9: {
                return this.getInvocations();
            }
            case 10: {
                if (resolve) {
                    return this.getCycle();
                }
                return this.basicGetCycle();
            }
            case 11: {
                return this.getInboundInvocations();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 5: {
                this.setItemName((String)newValue);
                return;
            }
            case 6: {
                this.setItemTime((Long)newValue);
                return;
            }
            case 8: {
                this.getSubroutines().clear();
                this.getSubroutines().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.getInvocations().clear();
                this.getInvocations().addAll((Collection)newValue);
                return;
            }
            case 10: {
                this.setCycle((Cycle)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 5: {
                this.setItemName(ITEM_NAME_EDEFAULT);
                return;
            }
            case 6: {
                this.setItemTime(0L);
                return;
            }
            case 8: {
                this.getSubroutines().clear();
                return;
            }
            case 9: {
                this.getInvocations().clear();
                return;
            }
            case 10: {
                this.setCycle(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 5: {
                return ITEM_NAME_EDEFAULT == null ? this.itemName != null : !ITEM_NAME_EDEFAULT.equals(this.itemName);
            }
            case 6: {
                return this.itemTime != 0L;
            }
            case 7: {
                return this.getCallCount() != 0;
            }
            case 8: {
                return this.subroutines != null && !this.subroutines.isEmpty();
            }
            case 9: {
                return this.invocations != null && !this.invocations.isEmpty();
            }
            case 10: {
                return this.cycle != null;
            }
            case 11: {
                return !this.getInboundInvocations().isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (ItemName: ");
        result.append(this.itemName);
        result.append(", ItemTime: ");
        result.append(this.itemTime);
        result.append(')');
        return result.toString();
    }
}

