/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableList;
import com.spotify.docker.client.messages.swarm.AutoValue_EndpointSpec;
import com.spotify.docker.client.messages.swarm.PortConfig;
import java.util.List;
import javax.annotation.Nullable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public abstract class EndpointSpec {
    @Nullable
    @JsonProperty(value="Mode")
    public abstract Mode mode();

    @JsonProperty(value="Ports")
    public abstract ImmutableList<PortConfig> ports();

    abstract Builder toBuilder();

    public EndpointSpec withVipMode() {
        return this.toBuilder().mode(Mode.RESOLUTION_MODE_VIP).build();
    }

    public EndpointSpec withDnsrrMode() {
        return this.toBuilder().mode(Mode.RESOLUTION_MODE_DNSRR).build();
    }

    public static Builder builder() {
        return new AutoValue_EndpointSpec.Builder();
    }

    @JsonCreator
    static EndpointSpec create(@JsonProperty(value="Mode") Mode mode, @JsonProperty(value="Ports") List<PortConfig> ports) {
        Builder builder = EndpointSpec.builder().mode(mode);
        if (ports != null) {
            builder.ports(ports);
        }
        return builder.build();
    }

    public static abstract class Builder {
        public abstract Builder mode(Mode var1);

        abstract ImmutableList.Builder<PortConfig> portsBuilder();

        public Builder addPort(PortConfig portConfig) {
            this.portsBuilder().add((Object)portConfig);
            return this;
        }

        public abstract Builder ports(PortConfig ... var1);

        public abstract Builder ports(List<PortConfig> var1);

        @Deprecated
        public Builder withPorts(PortConfig ... ports) {
            if (ports != null && ports.length > 0) {
                this.ports((List<PortConfig>)ImmutableList.copyOf((Object[])ports));
            }
            return this;
        }

        @Deprecated
        public Builder withPorts(List<PortConfig> ports) {
            if (ports != null && !ports.isEmpty()) {
                this.ports(ports);
            }
            return this;
        }

        public abstract EndpointSpec build();
    }

    public static enum Mode {
        RESOLUTION_MODE_VIP("vip"),
        RESOLUTION_MODE_DNSRR("dnsrr");

        private final String value;

        private Mode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

