/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.model.terms;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.bpel.model.BPELPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;

public class BPELTerms {
    public static final String PREF_BPEL_TERMS_PATH = "pref_bpel_terms_path";
    private ResourceBundle resourceBundle = null;
    private String currentTerms = null;
    private static String TERMS_PACKAGE = "org.eclipse.bpel.terms";
    public static String SPEC_TERMS_PATH = String.valueOf(TERMS_PACKAGE) + ".spec_terms";
    Preferences.IPropertyChangeListener prefListener = new Preferences.IPropertyChangeListener(){

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            if (BPELTerms.PREF_BPEL_TERMS_PATH.equals(event.getProperty())) {
                BPELTerms.this.loadTerms(BPELTerms.this.getPluginPreferences().getString(BPELTerms.PREF_BPEL_TERMS_PATH));
            }
        }
    };
    private static BPELTerms plugin;

    protected boolean loadTerms(String terms) {
        if (terms != null && terms.equals(this.currentTerms)) {
            return true;
        }
        this.currentTerms = terms;
        ResourceBundle newResourceBundle = null;
        try {
            newResourceBundle = ResourceBundle.getBundle(terms);
        }
        catch (MissingResourceException x) {
            return false;
        }
        this.resourceBundle = newResourceBundle;
        return true;
    }

    public BPELTerms() {
        plugin = this;
    }

    public static synchronized BPELTerms getDefault() {
        if (plugin == null) {
            plugin = new BPELTerms();
            plugin.loadTerms(SPEC_TERMS_PATH);
        }
        return plugin;
    }

    protected ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null && Platform.isRunning()) {
            Preferences prefs = this.getPluginPreferences();
            prefs.setDefault(PREF_BPEL_TERMS_PATH, SPEC_TERMS_PATH);
            this.loadTerms(prefs.getString(PREF_BPEL_TERMS_PATH));
            prefs.addPropertyChangeListener(this.prefListener);
        }
        return this.resourceBundle;
    }

    public static String getString(String key) {
        ResourceBundle bundle = BPELTerms.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public static String getString(String key, Object var) {
        return BPELTerms.getString(key, new Object[]{var});
    }

    public static String getString(String key, Object[] vars) {
        String text = BPELTerms.getString(key);
        return text == null ? null : MessageFormat.format(text, vars);
    }

    public static String getCatalogName() {
        if (Platform.isRunning()) {
            return BPELTerms.getDefault().getPluginPreferences().getString(PREF_BPEL_TERMS_PATH);
        }
        return SPEC_TERMS_PATH;
    }

    public Preferences getPluginPreferences() {
        return BPELPlugin.getPlugin().getPluginPreferences();
    }

    public void savePluginPreferences() {
        BPELPlugin.getPlugin().savePluginPreferences();
    }
}

