/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import javax.xml.namespace.QName;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.Filter;
import org.eclipse.bpel.validator.model.Filters;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.ValueFilter;
import org.eclipse.bpel.validator.rules.CatchAllValidator;

public class CatchValidator
extends CatchAllValidator {
    protected String fFaultName;
    protected QName fFaultQName;
    protected QName fFaultMessageType;
    protected QName fFaultElement;
    protected String fFaultVariableName;
    protected INode fFaultVariableType;
    static IFilter<QName> TYPE_DEFS = new ValueFilter<QName>(Filter.QNAME_COMPARATOR, AT_FAULT_MESSAGE_TYPE, AT_FAULT_ELEMENT);

    @Override
    protected void start() {
        super.start();
        this.fFaultName = this.mNode.getAttribute(AT_FAULT_NAME);
        this.fFaultVariableName = this.mNode.getAttribute(AT_FAULT_VARIABLE);
    }

    @ARule(date="01/10/2007", author="michal.chmielewski@oracle.com", desc="When exitOnStandardFault=yes, standard fault handlers cannot be present.", sa=3, errors="BPELC_CATCH__STANDARD_FAULT")
    public void rule_CheckExitStandardFaults_1() {
        if (this.fFaultName == null) {
            return;
        }
        this.fFaultQName = this.mModelQuery.createQName(this.mNode, this.fFaultName);
        if (!Filters.STANDARD_FAULTS.select(this.fFaultQName)) {
            return;
        }
        String value = this.getExitOnStandardFault(this.mNode);
        if (!"yes".equals(value)) {
            return;
        }
        IProblem problem = this.createError();
        problem.fill("BPELC_CATCH__STANDARD_FAULT", this.toString(this.mNode.nodeName()), this.fFaultQName);
    }

    @ARule(sa=81, desc="Fault variable must have message type or element set", author="michal.chmielewski@oracle.com", date="01/25/2007", errors="BPELC__AT_LEAST_ONE,BPELC__AT_MOST_ONE,BPELC__UNSET_ATTRIBUTE,BPELC__UNRESOLVED_ATTRIBUTE")
    public void rule_CheckFaultVariable_4() {
        String msgType = this.mNode.getAttribute(AT_FAULT_MESSAGE_TYPE);
        String elmDecl = this.mNode.getAttribute(AT_FAULT_ELEMENT);
        boolean bMsgTypeEmpty = CatchValidator.isEmptyOrWhitespace(msgType);
        boolean bElmDeclEmpty = CatchValidator.isEmptyOrWhitespace(elmDecl);
        if (!CatchValidator.isEmpty(this.fFaultVariableName)) {
            if (bElmDeclEmpty && bMsgTypeEmpty) {
                IProblem problem = this.createError();
                problem.fill("BPELC__AT_LEAST_ONE", this.toString(this.mNode.nodeName()), 0, TYPE_DEFS, 2);
                return;
            }
            if (!bElmDeclEmpty && !bMsgTypeEmpty) {
                IProblem problem = this.createError();
                problem.fill("BPELC__AT_MOST_ONE", this.toString(this.mNode.nodeName()), 0, TYPE_DEFS, 2);
            }
            if (!bElmDeclEmpty) {
                this.fFaultVariableType = this.mModelQuery.lookup(this.mNode, 8, elmDecl);
                this.checkAttributeNode(this.mNode, this.fFaultVariableType, AT_FAULT_ELEMENT, 0);
            }
            if (!bMsgTypeEmpty) {
                this.fFaultVariableType = this.mModelQuery.lookup(this.mNode, 7, msgType);
                this.checkAttributeNode(this.mNode, this.fFaultVariableType, AT_FAULT_MESSAGE_TYPE, 0);
            }
        } else if (!bElmDeclEmpty || !bMsgTypeEmpty) {
            IProblem problem = this.createError();
            problem.fill("BPELC__SPECIFY_NONE", this.toString(this.mNode.nodeName()), 0, TYPE_DEFS, 2);
        }
        this.setValue("fault.variable", this.fFaultVariableName);
        this.setValue("type", this.fFaultVariableType);
    }

    @ARule(sa=93, desc="Check to see if a duplicate catch has been specified", author="michal.chmielewski@oracle.com", date="01/20/2007", errors="BPELC_CATCH__EXIST")
    public void rule_CheckDuplicateCatch_10() {
        String key = "set.catch.";
        if (this.fFaultQName != null) {
            key = String.valueOf(key) + AT_FAULT_NAME + "=" + this.fFaultQName + ";";
        }
        if (this.fFaultElement != null) {
            key = String.valueOf(key) + AT_FAULT_MESSAGE_TYPE + "=" + this.fFaultElement + ";";
        } else if (this.fFaultMessageType != null) {
            key = String.valueOf(key) + AT_FAULT_ELEMENT + "=" + this.fFaultElement + ";";
        }
        if (this.containsValueKey(this.fParentNode, key)) {
            IProblem problem = this.createError();
            problem.fill("BPELC_CATCH__EXIST", this.toString(this.mNode.nodeName()), this.fFaultQName, this.fFaultMessageType == null ? this.fFaultElement : this.fFaultMessageType);
            return;
        }
        this.setValue(this.fParentNode, key, Boolean.TRUE);
    }
}

