/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICopyContext;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.features.AbstractCopyFeature;

public class DefaultCopyBPMNElementFeature
extends AbstractCopyFeature {
    public DefaultCopyBPMNElementFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canCopy(ICopyContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes == null || pes.length == 0) {
            return false;
        }
        PictogramElement[] pictogramElementArray = pes;
        int n = pes.length;
        int n2 = 0;
        while (n2 < n) {
            PictogramElement pe = pictogramElementArray[n2];
            BaseElement bo = BusinessObjectUtil.getFirstBaseElement(pe);
            if (!(bo instanceof BaseElement)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void copy(ICopyContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        ArrayList<PictogramElement> copied = new ArrayList<PictogramElement>();
        int i = 0;
        while (i < pes.length) {
            PictogramElement pe = pes[i];
            if (pe instanceof Connection) {
                Connection connection = (Connection)pe;
                AnchorContainer source = connection.getStart().getParent();
                AnchorContainer target = connection.getEnd().getParent();
                boolean containsSource = false;
                boolean containsTarget = false;
                PictogramElement[] pictogramElementArray = pes;
                int n = pes.length;
                int n2 = 0;
                while (n2 < n) {
                    PictogramElement p = pictogramElementArray[n2];
                    if (source == p) {
                        containsSource = true;
                    } else if (target == p) {
                        containsTarget = true;
                    }
                    ++n2;
                }
                if (containsSource && containsTarget) {
                    copied.add(pe);
                }
            } else {
                copied.add(pe);
            }
            ++i;
        }
        copied.addAll(DefaultCopyBPMNElementFeature.findAllConnections(copied));
        ArrayList<PictogramElement> ignored = new ArrayList<PictogramElement>();
        for (PictogramElement pe : copied) {
            if (!(pe instanceof ContainerShape)) continue;
            for (PictogramElement childPe : ((ContainerShape)pe).getChildren()) {
                if (!copied.contains(childPe)) continue;
                ignored.add(childPe);
            }
        }
        copied.removeAll(ignored);
        this.putToClipboard(copied.toArray());
    }

    public static List<Connection> findAllConnections(List<PictogramElement> shapes) {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        for (PictogramElement pe : shapes) {
            if (!(pe instanceof ContainerShape)) continue;
            ContainerShape shape = (ContainerShape)pe;
            for (Anchor a : shape.getAnchors()) {
                for (Connection c : a.getIncomingConnections()) {
                    if (!shapes.contains(c.getStart().getParent()) && !shapes.contains(c.getEnd().getParent()) || shapes.contains(c) || connections.contains(c)) continue;
                    connections.add(c);
                }
                for (Connection c : a.getOutgoingConnections()) {
                    if (!shapes.contains(c.getStart().getParent()) && !shapes.contains(c.getEnd().getParent()) || shapes.contains(c) || connections.contains(c)) continue;
                    connections.add(c);
                }
            }
        }
        return connections;
    }
}

