/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.containers.lane;

import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.modeler.core.features.containers.AbstractResizeContainerFeature;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.impl.ResizeShapeContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public class ResizeLaneFeature
extends AbstractResizeContainerFeature {
    public ResizeLaneFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public boolean canResizeShape(IResizeShapeContext context) {
        boolean doit = false;
        boolean isLane = FeatureSupport.isLane(context.getPictogramElement());
        if (isLane) {
            boolean isParentLane = FeatureSupport.isLane((PictogramElement)((ContainerShape)context.getPictogramElement()).getContainer());
            if (!isParentLane) {
                doit = true;
            } else if (context.getHeight() == -1 && context.getWidth() == -1) {
                doit = true;
            } else {
                GraphicsAlgorithm ga = ((ContainerShape)context.getPictogramElement()).getGraphicsAlgorithm();
                int i = this.compare(ga.getHeight(), ga.getWidth(), context.getHeight(), context.getWidth());
                BusinessObjectUtil.getFirstElementOfType(context.getPictogramElement(), Lane.class);
                if (i < 0) {
                    doit = true;
                } else if (i > 0) {
                    doit = true;
                }
            }
            if (doit && !super.canResizeShape(context)) {
                doit = false;
            }
        }
        return doit;
    }

    @Override
    public void resizeShape(IResizeShapeContext context) {
        this.preResizeShape(context);
        this.resizeHeight(context);
        this.resizeWidth(context);
        this.postResizeShape(context);
    }

    @Override
    protected void resizeHeight(IResizeShapeContext context) {
        ContainerShape laneShape = (ContainerShape)context.getShape();
        GraphicsAlgorithm ga = laneShape.getGraphicsAlgorithm();
        if (this.isHorizontal && ga.getHeight() != context.getHeight() || !this.isHorizontal && ga.getWidth() != context.getWidth()) {
            boolean useFirstLane = false;
            Object fetchFirstProperty = context.getProperty((Object)"resize.first.lane");
            if (fetchFirstProperty != null && ((Boolean)fetchFirstProperty).booleanValue()) {
                useFirstLane = true;
            } else if (this.isHorizontal && context.getY() != ga.getY() || !this.isHorizontal && context.getX() != ga.getX()) {
                useFirstLane = true;
                if (laneShape.equals(this.rootContainer)) {
                    Graphiti.getGaService().setLocation(ga, context.getX(), context.getY());
                }
            }
            ContainerShape lowestContainingLane = this.getLowestLane(laneShape, useFirstLane);
            GraphicsAlgorithm lowestLaneGA = lowestContainingLane.getGraphicsAlgorithm();
            int width = 0;
            int height = 0;
            if (this.isHorizontal) {
                int dHeight = context.getHeight() - ga.getHeight();
                height = lowestLaneGA.getHeight() + dHeight;
                if (height < 100) {
                    height = 100;
                }
                width = lowestLaneGA.getWidth();
            } else {
                int dWidth = context.getWidth() - ga.getWidth();
                width = lowestLaneGA.getWidth() + dWidth;
                if (width < 100) {
                    width = 100;
                }
                height = lowestLaneGA.getHeight();
            }
            ResizeShapeContext newContext = new ResizeShapeContext((Shape)lowestContainingLane);
            newContext.setX(lowestLaneGA.getX());
            newContext.setY(lowestLaneGA.getY());
            newContext.setHeight(height);
            newContext.setWidth(width);
            newContext.setDirection(context.getDirection());
            super.resizeShape((IResizeShapeContext)newContext);
        }
    }

    @Override
    protected void resizeWidth(IResizeShapeContext context) {
        block11: {
            GraphicsAlgorithm rootGA;
            int dHeight;
            int dWidth;
            GraphicsAlgorithm ga;
            ContainerShape laneShape;
            block13: {
                block12: {
                    laneShape = (ContainerShape)context.getShape();
                    ga = laneShape.getGraphicsAlgorithm();
                    if ((!this.isHorizontal || ga.getWidth() == context.getWidth()) && (this.isHorizontal || ga.getHeight() == context.getHeight())) break block11;
                    dWidth = 0;
                    dHeight = 0;
                    if (this.isHorizontal) {
                        dWidth = context.getWidth() - ga.getWidth();
                    } else {
                        dHeight = context.getHeight() - ga.getHeight();
                    }
                    Object poolResizeProperty = context.getProperty((Object)"pool.resize");
                    if (poolResizeProperty == null || !((Boolean)poolResizeProperty).booleanValue()) break block12;
                    if (this.isHorizontal) {
                        Graphiti.getGaService().setWidth(ga, context.getWidth());
                    } else {
                        Graphiti.getGaService().setHeight(ga, context.getHeight());
                    }
                    for (PictogramElement currentChild : BusinessObjectUtil.getChildElementsOfType(laneShape, Lane.class)) {
                        if (!(currentChild instanceof ContainerShape)) continue;
                        ContainerShape currentContainer = (ContainerShape)currentChild;
                        GraphicsAlgorithm currentGA = currentChild.getGraphicsAlgorithm();
                        ResizeShapeContext newContext = new ResizeShapeContext((Shape)currentContainer);
                        newContext.setX(currentGA.getX());
                        newContext.setY(currentGA.getY());
                        newContext.setHeight(currentGA.getHeight() + dHeight);
                        newContext.setWidth(currentGA.getWidth() + dWidth);
                        newContext.setDirection(context.getDirection());
                        newContext.putProperty((Object)"pool.resize", (Object)true);
                        this.resizeShape((IResizeShapeContext)newContext);
                    }
                    break block11;
                }
                rootGA = this.rootContainer.getGraphicsAlgorithm();
                if (!FeatureSupport.isParticipant((PictogramElement)this.rootContainer)) break block13;
                ResizeShapeContext newContext = new ResizeShapeContext((Shape)this.rootContainer);
                newContext.setX(rootGA.getX());
                newContext.setY(rootGA.getY());
                newContext.setWidth(rootGA.getWidth() + dWidth);
                newContext.setHeight(rootGA.getHeight() + dHeight);
                newContext.setDirection(context.getDirection());
                IResizeShapeFeature resizeFeature = this.getFeatureProvider().getResizeShapeFeature((IResizeShapeContext)newContext);
                if (!resizeFeature.canResizeShape((IResizeShapeContext)newContext)) break block11;
                resizeFeature.resizeShape((IResizeShapeContext)newContext);
                break block11;
            }
            ContainerShape container = null;
            Object rootIsLaneProperty = context.getProperty((Object)"lane.resize");
            if (rootIsLaneProperty != null && ((Boolean)rootIsLaneProperty).booleanValue()) {
                Graphiti.getGaService().setWidth(ga, context.getWidth());
                Graphiti.getGaService().setHeight(ga, context.getHeight());
                container = laneShape;
            } else {
                container = this.rootContainer;
                if (this.isHorizontal) {
                    Graphiti.getGaService().setWidth(rootGA, rootGA.getWidth() + dWidth);
                } else {
                    Graphiti.getGaService().setHeight(rootGA, rootGA.getHeight() + dHeight);
                }
                if (laneShape.equals(this.rootContainer)) {
                    Graphiti.getGaService().setLocation(ga, context.getX(), context.getY());
                }
            }
            for (PictogramElement currentChild : BusinessObjectUtil.getChildElementsOfType(container, Lane.class)) {
                if (!(currentChild instanceof ContainerShape)) continue;
                ContainerShape currentContainer = (ContainerShape)currentChild;
                GraphicsAlgorithm currentGA = currentChild.getGraphicsAlgorithm();
                ResizeShapeContext newContext = new ResizeShapeContext((Shape)currentContainer);
                newContext.setX(currentGA.getX());
                newContext.setY(currentGA.getY());
                newContext.setWidth(currentGA.getWidth() + dWidth);
                newContext.setHeight(currentGA.getHeight() + dHeight);
                newContext.setDirection(context.getDirection());
                newContext.putProperty((Object)"lane.resize", (Object)true);
                this.resizeShape((IResizeShapeContext)newContext);
            }
        }
    }

    @Override
    protected void preResizeShape(IResizeShapeContext context) {
        super.preResizeShape(context);
    }

    private ContainerShape getLowestLane(ContainerShape root, boolean useFirstLane) {
        ContainerShape result = useFirstLane ? FeatureSupport.getFirstLaneInContainer(root) : FeatureSupport.getLastLaneInContainer(root);
        if (!result.equals(root)) {
            return this.getLowestLane(result, useFirstLane);
        }
        return result;
    }

    private int compare(int heightBefore, int widthBefore, int heightAfter, int widthAfter) {
        if (heightAfter > heightBefore || widthAfter > widthBefore) {
            return 1;
        }
        if (heightAfter < heightBefore || widthAfter < widthBefore) {
            return -1;
        }
        return 0;
    }
}

