/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.transport;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import org.eclipse.cdt.debug.ui.memory.transport.ExportMemoryDialog;
import org.eclipse.cdt.debug.ui.memory.transport.MemoryTransportPlugin;
import org.eclipse.cdt.debug.ui.memory.transport.Messages;
import org.eclipse.cdt.debug.ui.memory.transport.model.IMemoryExporter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RAWBinaryExporter
implements IMemoryExporter {
    File fOutputFile;
    BigInteger fStartAddress;
    BigInteger fEndAddress;
    private Text fStartText;
    private Text fEndText;
    private Text fLengthText;
    private Text fFileText;
    private IMemoryBlock fMemoryBlock;
    private ExportMemoryDialog fParentDialog;
    private IDialogSettings fProperties;

    @Override
    public Control createControl(final Composite parent, IMemoryBlock memBlock, IDialogSettings properties, ExportMemoryDialog parentDialog) {
        this.fMemoryBlock = memBlock;
        this.fParentDialog = parentDialog;
        this.fProperties = properties;
        Composite composite = new Composite(parent, 0){

            public void dispose() {
                RAWBinaryExporter.this.fProperties.put("File", RAWBinaryExporter.this.fFileText.getText().trim());
                RAWBinaryExporter.this.fProperties.put("Start", RAWBinaryExporter.this.fStartText.getText().trim());
                RAWBinaryExporter.this.fProperties.put("End", RAWBinaryExporter.this.fEndText.getText().trim());
                try {
                    RAWBinaryExporter.this.fStartAddress = RAWBinaryExporter.this.getStartAddress();
                    RAWBinaryExporter.this.fEndAddress = RAWBinaryExporter.this.getEndAddress();
                    RAWBinaryExporter.this.fOutputFile = RAWBinaryExporter.this.getFile();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                super.dispose();
            }
        };
        FormLayout formLayout = new FormLayout();
        formLayout.spacing = 5;
        formLayout.marginHeight = 9;
        formLayout.marginWidth = 9;
        composite.setLayout((Layout)formLayout);
        Label startLabel = new Label(composite, 0);
        startLabel.setText(Messages.getString("RAWBinaryExporter.StartAddress"));
        FormData data = new FormData();
        startLabel.setLayoutData((Object)data);
        this.fStartText = new Text(composite, 2048);
        data = new FormData();
        data.left = new FormAttachment((Control)startLabel);
        data.width = 120;
        this.fStartText.setLayoutData((Object)data);
        Label endLabel = new Label(composite, 0);
        endLabel.setText(Messages.getString("RAWBinaryExporter.EndAddress"));
        data = new FormData();
        data.top = new FormAttachment((Control)this.fStartText, 0, 0x1000000);
        data.left = new FormAttachment((Control)this.fStartText);
        endLabel.setLayoutData((Object)data);
        this.fEndText = new Text(composite, 2048);
        data = new FormData();
        data.top = new FormAttachment((Control)this.fStartText, 0, 0x1000000);
        data.left = new FormAttachment((Control)endLabel);
        data.width = 120;
        this.fEndText.setLayoutData((Object)data);
        Label lengthLabel = new Label(composite, 0);
        lengthLabel.setText(Messages.getString("RAWBinaryExporter.Length"));
        data = new FormData();
        data.top = new FormAttachment((Control)this.fStartText, 0, 0x1000000);
        data.left = new FormAttachment((Control)this.fEndText);
        lengthLabel.setLayoutData((Object)data);
        this.fLengthText = new Text(composite, 2048);
        data = new FormData();
        data.top = new FormAttachment((Control)this.fStartText, 0, 0x1000000);
        data.left = new FormAttachment((Control)lengthLabel);
        data.width = 120;
        this.fLengthText.setLayoutData((Object)data);
        Label fileLabel = new Label(composite, 0);
        this.fFileText = new Text(composite, 2048);
        Button fileButton = new Button(composite, 8);
        fileLabel.setText(Messages.getString("Exporter.FileName"));
        data = new FormData();
        data.top = new FormAttachment((Control)fileButton, 0, 0x1000000);
        fileLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)fileButton, 0, 0x1000000);
        data.left = new FormAttachment((Control)fileLabel);
        data.width = 360;
        this.fFileText.setLayoutData((Object)data);
        fileButton.setText(Messages.getString("Exporter.Browse"));
        data = new FormData();
        data.top = new FormAttachment((Control)this.fLengthText);
        data.left = new FormAttachment((Control)this.fFileText);
        fileButton.setLayoutData((Object)data);
        String textValue = this.fProperties.get("File");
        this.fFileText.setText(textValue != null ? textValue : "");
        textValue = this.fProperties.get("Start");
        this.fStartText.setText(textValue != null ? textValue : "0x0");
        try {
            this.getStartAddress();
        }
        catch (Exception e) {
            this.fStartText.setForeground(Display.getDefault().getSystemColor(3));
        }
        textValue = this.fProperties.get("End");
        this.fEndText.setText(textValue != null ? textValue : "0x0");
        try {
            this.getEndAddress();
        }
        catch (Exception e) {
            this.fEndText.setForeground(Display.getDefault().getSystemColor(3));
        }
        try {
            BigInteger length = this.getEndAddress().subtract(this.getStartAddress());
            this.fLengthText.setText(length.toString());
            if (length.compareTo(BigInteger.ZERO) <= 0) {
                this.fLengthText.setForeground(Display.getDefault().getSystemColor(3));
            }
        }
        catch (Exception e) {
            this.fLengthText.setText("0");
            this.fLengthText.setForeground(Display.getDefault().getSystemColor(3));
        }
        fileButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(parent.getShell(), 8192);
                dialog.setText(Messages.getString("RAWBinaryExporter.ChooseFile"));
                dialog.setFilterExtensions(new String[]{"*.*;*"});
                dialog.setFilterNames(new String[]{Messages.getString("Exporter.AllFiles")});
                dialog.setFileName(RAWBinaryExporter.this.fFileText.getText().trim());
                dialog.open();
                String filename = dialog.getFileName();
                if (filename != null && filename.length() != 0) {
                    RAWBinaryExporter.this.fFileText.setText(String.valueOf(dialog.getFilterPath()) + File.separator + filename);
                }
                RAWBinaryExporter.this.validate();
            }
        });
        this.fStartText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                try {
                    BigInteger endAddress;
                    RAWBinaryExporter.this.fStartText.setForeground(Display.getDefault().getSystemColor(2));
                    RAWBinaryExporter.this.fEndText.setForeground(Display.getDefault().getSystemColor(2));
                    RAWBinaryExporter.this.fLengthText.setForeground(Display.getDefault().getSystemColor(2));
                    BigInteger startAddress = RAWBinaryExporter.this.getStartAddress();
                    BigInteger actualLength = RAWBinaryExporter.this.getEndAddress().subtract(startAddress);
                    RAWBinaryExporter.this.fLengthText.setText(actualLength.toString());
                    if (actualLength.compareTo(BigInteger.ZERO) <= 0) {
                        RAWBinaryExporter.this.fStartText.setForeground(Display.getDefault().getSystemColor(3));
                        RAWBinaryExporter.this.fLengthText.setForeground(Display.getDefault().getSystemColor(3));
                    }
                    if (startAddress.compareTo(BigInteger.ZERO) < 0) {
                        RAWBinaryExporter.this.fStartText.setForeground(Display.getDefault().getSystemColor(3));
                        RAWBinaryExporter.this.fLengthText.setForeground(Display.getDefault().getSystemColor(3));
                    }
                    if ((endAddress = RAWBinaryExporter.this.getEndAddress()).compareTo(BigInteger.ZERO) < 0) {
                        RAWBinaryExporter.this.fEndText.setForeground(Display.getDefault().getSystemColor(3));
                        RAWBinaryExporter.this.fLengthText.setForeground(Display.getDefault().getSystemColor(3));
                    }
                }
                catch (Exception ex) {
                    RAWBinaryExporter.this.fStartText.setForeground(Display.getDefault().getSystemColor(3));
                    RAWBinaryExporter.this.fLengthText.setForeground(Display.getDefault().getSystemColor(3));
                }
                RAWBinaryExporter.this.validate();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.fEndText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                try {
                    BigInteger endAddress;
                    BigInteger startAddress;
                    RAWBinaryExporter.this.fStartText.setForeground(Display.getDefault().getSystemColor(2));
                    RAWBinaryExporter.this.fEndText.setForeground(Display.getDefault().getSystemColor(2));
                    RAWBinaryExporter.this.fLengthText.setForeground(Display.getDefault().getSystemColor(2));
                    BigInteger actualLength = RAWBinaryExporter.this.getEndAddress().subtract(RAWBinaryExporter.this.getStartAddress());
                    RAWBinaryExporter.this.fLengthText.setText(actualLength.toString());
                    if (actualLength.compareTo(BigInteger.ZERO) <= 0) {
                        RAWBinaryExporter.this.fEndText.setForeground(Display.getDefault().getSystemColor(3));
                        RAWBinaryExporter.this.fLengthText.setForeground(Display.getDefault().getSystemColor(3));
                    }
                    if ((startAddress = RAWBinaryExporter.this.getStartAddress()).compareTo(BigInteger.ZERO) < 0) {
                        RAWBinaryExporter.this.fStartText.setForeground(Display.getDefault().getSystemColor(3));
                        RAWBinaryExporter.this.fLengthText.setForeground(Display.getDefault().getSystemColor(3));
                    }
                    if ((endAddress = RAWBinaryExporter.this.getEndAddress()).compareTo(BigInteger.ZERO) < 0) {
                        RAWBinaryExporter.this.fEndText.setForeground(Display.getDefault().getSystemColor(3));
                        RAWBinaryExporter.this.fLengthText.setForeground(Display.getDefault().getSystemColor(3));
                    }
                }
                catch (Exception ex) {
                    RAWBinaryExporter.this.fEndText.setForeground(Display.getDefault().getSystemColor(3));
                    RAWBinaryExporter.this.fLengthText.setForeground(Display.getDefault().getSystemColor(3));
                }
                RAWBinaryExporter.this.validate();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.fLengthText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                try {
                    RAWBinaryExporter.this.fStartText.setForeground(Display.getDefault().getSystemColor(2));
                    RAWBinaryExporter.this.fEndText.setForeground(Display.getDefault().getSystemColor(2));
                    RAWBinaryExporter.this.fLengthText.setForeground(Display.getDefault().getSystemColor(2));
                    RAWBinaryExporter.this.fStartText.setText(RAWBinaryExporter.this.fStartText.getText().trim());
                    BigInteger length = RAWBinaryExporter.this.getLength();
                    BigInteger startAddress = RAWBinaryExporter.this.getStartAddress();
                    BigInteger endAddress = startAddress.add(length);
                    String endString = length.compareTo(BigInteger.ZERO) <= 0 ? (endAddress.compareTo(BigInteger.ZERO) < 0 ? endAddress.toString(16) : "0x" + endAddress.toString(16)) : "0x" + endAddress.toString(16);
                    RAWBinaryExporter.this.fEndText.setText(endString);
                    if (length.compareTo(BigInteger.ZERO) <= 0) {
                        RAWBinaryExporter.this.fEndText.setForeground(Display.getDefault().getSystemColor(3));
                        RAWBinaryExporter.this.fLengthText.setForeground(Display.getDefault().getSystemColor(3));
                    }
                    if (startAddress.compareTo(BigInteger.ZERO) < 0) {
                        RAWBinaryExporter.this.fStartText.setForeground(Display.getDefault().getSystemColor(3));
                    }
                    if (endAddress.compareTo(BigInteger.ZERO) < 0) {
                        RAWBinaryExporter.this.fEndText.setForeground(Display.getDefault().getSystemColor(3));
                    }
                }
                catch (Exception ex) {
                    if (RAWBinaryExporter.this.fLengthText.getText().trim().length() != 0) {
                        RAWBinaryExporter.this.fEndText.setForeground(Display.getDefault().getSystemColor(3));
                    }
                    RAWBinaryExporter.this.fLengthText.setForeground(Display.getDefault().getSystemColor(3));
                }
                RAWBinaryExporter.this.validate();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.fFileText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                RAWBinaryExporter.this.validate();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        composite.pack();
        parent.pack();
        Display.getDefault().asyncExec(() -> this.validate());
        return composite;
    }

    public BigInteger getEndAddress() {
        String text = this.fEndText.getText();
        boolean hex = (text = text.trim()).startsWith("0x");
        BigInteger endAddress = new BigInteger(hex ? text.substring(2) : text, hex ? 16 : 10);
        return endAddress;
    }

    public BigInteger getStartAddress() {
        String text = this.fStartText.getText();
        boolean hex = (text = text.trim()).startsWith("0x");
        BigInteger startAddress = new BigInteger(hex ? text.substring(2) : text, hex ? 16 : 10);
        return startAddress;
    }

    public BigInteger getLength() {
        String text = this.fLengthText.getText();
        boolean hex = (text = text.trim()).startsWith("0x");
        BigInteger lengthAddress = new BigInteger(hex ? text.substring(2) : text, hex ? 16 : 10);
        return lengthAddress;
    }

    public File getFile() {
        return new File(this.fFileText.getText().trim());
    }

    private void validate() {
        boolean isValid = true;
        try {
            File file;
            this.getEndAddress();
            this.getStartAddress();
            BigInteger length = this.getLength();
            if (length.compareTo(BigInteger.ZERO) <= 0) {
                isValid = false;
            }
            if (this.fFileText.getText().trim().length() == 0) {
                isValid = false;
            }
            if ((file = this.getFile()) != null) {
                File parentFile = file.getParentFile();
                if (parentFile != null && !parentFile.exists()) {
                    isValid = false;
                }
                if (!(parentFile == null || !parentFile.exists() || parentFile.canRead() && parentFile.isDirectory())) {
                    isValid = false;
                }
                if (file.isDirectory()) {
                    isValid = false;
                }
            }
        }
        catch (Exception e) {
            isValid = false;
        }
        this.fParentDialog.setValid(isValid);
    }

    @Override
    public String getId() {
        return "rawbinary";
    }

    @Override
    public String getName() {
        return Messages.getString("RAWBinaryExporter.Name");
    }

    @Override
    public void exportMemory() {
        Job job = new Job("Memory Export to RAW Binary File"){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    BigInteger DATA_PER_RECORD = BigInteger.valueOf(1024L);
                    BigInteger transferAddress = RAWBinaryExporter.this.fStartAddress;
                    FileOutputStream writer = new FileOutputStream(RAWBinaryExporter.this.fOutputFile);
                    BigInteger jobs = RAWBinaryExporter.this.fEndAddress.subtract(transferAddress).divide(DATA_PER_RECORD);
                    BigInteger factor = BigInteger.ONE;
                    if (jobs.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
                        factor = jobs.divide(BigInteger.valueOf(Integer.MAX_VALUE));
                        jobs = jobs.divide(factor);
                    }
                    monitor.beginTask(Messages.getString("Exporter.ProgressTitle"), jobs.intValue());
                    BigInteger jobCount = BigInteger.ZERO;
                    while (transferAddress.compareTo(RAWBinaryExporter.this.fEndAddress) < 0 && !monitor.isCanceled()) {
                        BigInteger length = DATA_PER_RECORD;
                        if (RAWBinaryExporter.this.fEndAddress.subtract(transferAddress).compareTo(length) < 0) {
                            length = RAWBinaryExporter.this.fEndAddress.subtract(transferAddress);
                        }
                        monitor.subTask(String.format(Messages.getString("Exporter.Progress"), length.toString(10), transferAddress.toString(16)));
                        byte[] byteValues = new byte[length.intValue()];
                        MemoryByte[] bytes = ((IMemoryBlockExtension)RAWBinaryExporter.this.fMemoryBlock).getBytesFromAddress(transferAddress, length.longValue() / (long)((IMemoryBlockExtension)RAWBinaryExporter.this.fMemoryBlock).getAddressableSize());
                        int byteIndex = 0;
                        while (byteIndex < bytes.length) {
                            byteValues[byteIndex] = bytes[byteIndex].getValue();
                            ++byteIndex;
                        }
                        writer.write(byteValues);
                        transferAddress = transferAddress.add(length);
                        jobCount = jobCount.add(BigInteger.ONE);
                        if (jobCount.compareTo(factor) != 0) continue;
                        jobCount = BigInteger.ZERO;
                        monitor.worked(1);
                    }
                    writer.close();
                    monitor.done();
                }
                catch (IOException ex) {
                    MemoryTransportPlugin.getDefault().getLog().log((IStatus)new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5012, Messages.getString("Exporter.ErrFile"), (Throwable)ex));
                    return new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5012, Messages.getString("Exporter.ErrFile"), (Throwable)ex);
                }
                catch (DebugException ex) {
                    MemoryTransportPlugin.getDefault().getLog().log((IStatus)new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5012, Messages.getString("Exporter.ErrReadTarget"), (Throwable)ex));
                    return new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5012, Messages.getString("Exporter.ErrReadTarget"), (Throwable)ex);
                }
                catch (Exception ex) {
                    MemoryTransportPlugin.getDefault().getLog().log((IStatus)new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5013, Messages.getString("Exporter.Falure"), (Throwable)ex));
                    return new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5013, Messages.getString("Exporter.Falure"), (Throwable)ex);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }
}

