/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.cdt.internal.ui.util.CoreUtility;
import org.eclipse.cdt.internal.ui.wizards.AbstractOpenWizardAction;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.Wizard;

public class OpenNewWizardAction
extends AbstractOpenWizardAction {
    private static final String TAG_DESCRIPTION = "description";
    private static final String ATT_NAME = "name";
    private static final String ATT_CLASS = "class";
    private static final String ATT_ICON = "icon";
    private IConfigurationElement fConfigurationElement;

    public OpenNewWizardAction(IConfigurationElement element) {
        this.fConfigurationElement = element;
        this.setText(element.getAttribute(ATT_NAME));
        String description = this.getDescriptionFromConfig(this.fConfigurationElement);
        this.setDescription(description);
        this.setToolTipText(description);
        this.setImageDescriptor(this.getIconFromConfig(this.fConfigurationElement));
    }

    private String getDescriptionFromConfig(IConfigurationElement config) {
        IConfigurationElement[] children = config.getChildren(TAG_DESCRIPTION);
        if (children.length >= 1) {
            return children[0].getValue();
        }
        return "";
    }

    private ImageDescriptor getIconFromConfig(IConfigurationElement config) {
        try {
            String iconName = config.getAttribute(ATT_ICON);
            if (iconName != null) {
                URL pluginInstallUrl = Platform.getBundle((String)config.getDeclaringExtension().getContributor().getName()).getEntry("/");
                return ImageDescriptor.createFromURL((URL)new URL(pluginInstallUrl, iconName));
            }
            return null;
        }
        catch (MalformedURLException exception) {
            CUIPlugin.logError("Unable to load wizard icon");
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    @Override
    protected Wizard createWizard() throws CoreException {
        return (Wizard)CoreUtility.createExtension(this.fConfigurationElement, ATT_CLASS);
    }
}

