/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.actions;

import org.eclipse.cft.server.ui.internal.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.IServerModule;

public abstract class BaseCommandHandler
extends AbstractHandler
implements IHandler {
    protected IServer selectedServer;
    protected IModule selectedModule;
    protected IWorkbenchPartSite partSite;

    protected void initializeSelection(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart != null) {
            this.partSite = activePart.getSite();
            if (this.partSite != null) {
                ISelectionProvider selectionProvider = this.partSite.getSelectionProvider();
                if (selectionProvider != null) {
                    ISelection selection = selectionProvider.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        Object obj = ((IStructuredSelection)selection).getFirstElement();
                        if (obj instanceof IServer) {
                            this.selectedServer = (IServer)obj;
                        } else if (obj instanceof IServerModule) {
                            IServerModule sm = (IServerModule)obj;
                            IModule[] module = sm.getModule();
                            this.selectedModule = module[module.length - 1];
                            if (this.selectedModule != null) {
                                this.selectedServer = sm.getServer();
                            }
                        }
                    }
                } else {
                    this.logSelectionDetectionFailure();
                }
            } else {
                this.logSelectionDetectionFailure();
            }
        } else {
            this.logSelectionDetectionFailure();
        }
    }

    private void logSelectionDetectionFailure() {
        if (Logger.WARNING) {
            Logger.println("/debug/warning", (Object)this, "logSelectionDetectionFailure", "Failed to initialize command selection.");
        }
    }
}

