/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.ui.Activator;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class MessagePopupTextCellEditor
extends TextCellEditor {
    private static final int DEFAULT_DELAY_MILLIS = 200;
    private static final RGB DEFAULT_BACKGROUND = new RGB(255, 150, 150);
    private final boolean cancelOnFocusLost;
    private DefaultToolTip errorPopup;

    public MessagePopupTextCellEditor(Composite parent) {
        this(parent, false);
    }

    public MessagePopupTextCellEditor(Composite parent, boolean cancelOnFocusLost) {
        super(parent);
        this.cancelOnFocusLost = cancelOnFocusLost;
    }

    public MessagePopupTextCellEditor(Composite parent, int style) {
        this(parent, false, style);
    }

    public MessagePopupTextCellEditor(Composite parent, boolean cancelOnFocusLost, int style) {
        super(parent, style);
        this.cancelOnFocusLost = cancelOnFocusLost;
    }

    protected boolean dependsOnExternalFocusListener() {
        return false;
    }

    protected void focusLost() {
        if (this.cancelOnFocusLost) {
            if (this.isActivated()) {
                this.fireCancelEditor();
            }
        } else {
            super.focusLost();
        }
    }

    protected Control createControl(Composite parent) {
        Control control = super.createControl(parent);
        this.errorPopup = new DefaultToolTip(control, 2, true);
        this.errorPopup.setPopupDelay(200);
        this.errorPopup.setBackgroundColor(Activator.getDefault().getResourceManager().createColor(DEFAULT_BACKGROUND));
        control.addDisposeListener(event -> this.errorPopup.hide());
        this.addListener(new ICellEditorListener(){

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                if (newValidState) {
                    MessagePopupTextCellEditor.this.errorPopup.hide();
                    return;
                }
                Control editor = MessagePopupTextCellEditor.this.getControl();
                Point pos = editor.getSize();
                MessagePopupTextCellEditor.this.errorPopup.setText(MessagePopupTextCellEditor.this.getErrorMessage());
                pos.x = 0;
                MessagePopupTextCellEditor.this.errorPopup.show(pos);
            }

            public void cancelEditor() {
                MessagePopupTextCellEditor.this.errorPopup.hide();
            }

            public void applyEditorValue() {
                MessagePopupTextCellEditor.this.errorPopup.hide();
            }
        });
        if ((this.text.getStyle() & 4) != 0) {
            this.text.addVerifyListener(event -> {
                String string = event.text = Utils.firstLine((String)event.text);
            });
        }
        return control;
    }

    public DefaultToolTip getToolTip() {
        return this.errorPopup;
    }
}

