/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOFeatureType;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOClearFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOMoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.mapping.IClassMapping;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping3;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping4;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.DBIndexAnnotation;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.AbstractMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractBasicListTableMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.IMappingConstants;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.commit.CDOChangeSetSegment;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOList;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBDatabase;
import org.eclipse.net4j.db.IDBPreparedStatement;
import org.eclipse.net4j.db.IDBResultSet;
import org.eclipse.net4j.db.IDBSchemaTransaction;
import org.eclipse.net4j.db.ddl.IDBElement;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.lifecycle.IDeactivateable;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHorizontalClassMapping
implements IClassMapping,
IMappingConstants,
IDeactivateable {
    protected static final int UNSET_LIST = -1;
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, AbstractHorizontalClassMapping.class);
    private EClass eClass;
    private IDBTable table;
    private AbstractHorizontalMappingStrategy mappingStrategy;
    private List<ITypeMapping> valueMappings;
    private List<IListMapping> listMappings;
    private Map<EStructuralFeature, IDBField> listSizeFields;
    private Map<EStructuralFeature, IDBField> unsettableFields;
    private String sqlSelectForHandle;
    private String sqlSelectForChangeSet;

    public AbstractHorizontalClassMapping(AbstractHorizontalMappingStrategy mappingStrategy, EClass eClass) {
        this.mappingStrategy = mappingStrategy;
        this.eClass = eClass;
        IDBStoreAccessor accessor = null;
        if (AbstractHorizontalMappingStrategy.isEagerTableCreation(mappingStrategy)) {
            accessor = (IDBStoreAccessor)StoreThreadLocal.getAccessor();
        }
        this.initTable(accessor);
    }

    protected void initTable(IDBStoreAccessor accessor) {
        IDBStore store = this.mappingStrategy.getStore();
        IDBDatabase database = store.getDatabase();
        String tableName = this.mappingStrategy.getTableName((ENamedElement)this.eClass);
        this.table = database.getSchema().getTable(tableName);
        if (this.table == null) {
            if (accessor != null) {
                IDBSchemaTransaction schemaTransaction = database.openSchemaTransaction();
                try {
                    IDBField field;
                    DBType idType = store.getIDHandler().getDBType();
                    int idLength = store.getIDColumnLength();
                    IDBSchema workingCopy = schemaTransaction.getWorkingCopy();
                    IDBTable table = workingCopy.addTable(tableName);
                    table.addField("CDO_ID", idType, idLength, true);
                    table.addField("CDO_VERSION", DBType.INTEGER, true);
                    IDBField branchField = this.addBranchField(table);
                    table.addField("CDO_CREATED", DBType.BIGINT, true);
                    table.addField("CDO_REVISED", DBType.BIGINT, true);
                    table.addField("CDO_RESOURCE", idType, idLength, true);
                    this.addContainerField(table, idType, idLength);
                    table.addField("CDO_FEATURE", DBType.INTEGER, true);
                    IDBIndex primaryKey = table.addIndex(IDBIndex.Type.PRIMARY_KEY, new String[]{"CDO_ID", "CDO_VERSION"});
                    if (branchField != null) {
                        primaryKey.addIndexField(branchField);
                    }
                    table.addIndex(IDBIndex.Type.NON_UNIQUE, new String[]{"CDO_REVISED"});
                    EStructuralFeature[] allPersistentFeatures = CDOModelUtil.getClassInfo((EClass)this.eClass).getAllPersistentFeatures();
                    HashMap<EStructuralFeature, ITypeMapping> valueMappings = new HashMap<EStructuralFeature, ITypeMapping>();
                    ArrayList<EStructuralFeature> unsettableFeatures = new ArrayList<EStructuralFeature>();
                    EStructuralFeature[] eStructuralFeatureArray = allPersistentFeatures;
                    int n = allPersistentFeatures.length;
                    int n2 = 0;
                    while (n2 < n) {
                        EStructuralFeature eStructuralFeature = eStructuralFeatureArray[n2];
                        String fieldName = this.mappingStrategy.getFieldName(eStructuralFeature);
                        if (eStructuralFeature.isMany()) {
                            IListMapping mapping = this.createListMapping(eStructuralFeature);
                            if (mapping != null) {
                                table.addField(fieldName, DBType.INTEGER);
                            }
                        } else {
                            ITypeMapping valueMapping = this.mappingStrategy.createValueMapping(eStructuralFeature);
                            valueMapping.createDBField(table, fieldName);
                            valueMappings.put(eStructuralFeature, valueMapping);
                            Set<CDOFeatureType> forceIndexes = AbstractMappingStrategy.getForceIndexes(this.mappingStrategy);
                            if (CDOFeatureType.matchesCombination((EStructuralFeature)eStructuralFeature, forceIndexes)) {
                                field = table.getField(fieldName);
                                if (!table.hasIndexFor(new IDBField[]{field})) {
                                    IDBIndex index = table.addIndex(IDBIndex.Type.NON_UNIQUE, new IDBField[]{field});
                                    DBUtil.setOptional((IDBElement)index, (boolean)true);
                                }
                            }
                            if (eStructuralFeature.isUnsettable()) {
                                unsettableFeatures.add(eStructuralFeature);
                            }
                        }
                        ++n2;
                    }
                    for (EStructuralFeature eStructuralFeature : unsettableFeatures) {
                        String fieldName = this.mappingStrategy.getUnsettableFieldName(eStructuralFeature);
                        table.addField(fieldName, DBType.BOOLEAN);
                    }
                    for (List list : DBIndexAnnotation.getIndices(this.eClass, allPersistentFeatures)) {
                        int size = list.size();
                        IDBField[] fields = new IDBField[size];
                        int i = 0;
                        while (i < size) {
                            EStructuralFeature feature = (EStructuralFeature)list.get(i);
                            ITypeMapping valueMapping = (ITypeMapping)valueMappings.get(feature);
                            fields[i] = field = valueMapping.getField();
                            ++i;
                        }
                        if (table.hasIndexFor(fields)) continue;
                        IDBIndex index = table.addIndex(IDBIndex.Type.NON_UNIQUE, fields);
                        DBUtil.setOptional((IDBElement)index, (boolean)true);
                    }
                    schemaTransaction.commit();
                }
                finally {
                    schemaTransaction.close();
                }
                this.initTable(null);
                accessor.tableCreated(this.table);
            }
        } else {
            this.valueMappings = null;
            this.listMappings = null;
            this.listSizeFields = null;
            this.unsettableFields = null;
            EStructuralFeature[] allPersistentFeatures = CDOModelUtil.getClassInfo((EClass)this.eClass).getAllPersistentFeatures();
            ArrayList<EStructuralFeature> unsettableFeatures = new ArrayList<EStructuralFeature>();
            EStructuralFeature[] branchField = allPersistentFeatures;
            int table = allPersistentFeatures.length;
            int n = 0;
            while (n < table) {
                Object mapping;
                EStructuralFeature feature = branchField[n];
                String fieldName = this.mappingStrategy.getFieldName(feature);
                if (feature.isMany()) {
                    mapping = this.createListMapping(feature);
                    if (mapping != null) {
                        if (mapping instanceof IListMapping3) {
                            ((IListMapping3)mapping).setClassMapping(this);
                        }
                        if (this.listMappings == null) {
                            this.listMappings = new ArrayList<IListMapping>();
                        }
                        this.listMappings.add((IListMapping)mapping);
                        IDBField listSizeField = this.table.getField(fieldName);
                        if (this.listSizeFields == null) {
                            this.listSizeFields = new LinkedHashMap<EStructuralFeature, IDBField>();
                        }
                        this.listSizeFields.put(feature, listSizeField);
                    }
                } else {
                    mapping = this.mappingStrategy.createValueMapping(feature);
                    mapping.setDBField(this.table, fieldName);
                    if (this.valueMappings == null) {
                        this.valueMappings = new ArrayList<ITypeMapping>();
                    }
                    this.valueMappings.add((ITypeMapping)mapping);
                    if (feature.isUnsettable()) {
                        unsettableFeatures.add(feature);
                    }
                }
                ++n;
            }
            if (!unsettableFeatures.isEmpty()) {
                this.unsettableFields = new LinkedHashMap<EStructuralFeature, IDBField>();
                for (EStructuralFeature feature : unsettableFeatures) {
                    String fieldName = this.mappingStrategy.getUnsettableFieldName(feature);
                    IDBField field = this.table.getField(fieldName);
                    this.unsettableFields.put(feature, field);
                }
            }
            if (this.valueMappings == null) {
                this.valueMappings = Collections.emptyList();
            }
            if (this.listMappings == null) {
                this.listMappings = Collections.emptyList();
            }
            this.initSQLStrings();
        }
    }

    private IListMapping createListMapping(EStructuralFeature feature) {
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
            return this.mappingStrategy.createFeatureMapMapping(this.eClass, feature);
        }
        return this.mappingStrategy.createListMapping(this.eClass, feature);
    }

    protected void initSQLStrings() {
        StringBuilder builder = new StringBuilder("SELECT ");
        builder.append("CDO_ID");
        builder.append(", ");
        builder.append("CDO_VERSION");
        this.appendSelectForHandleFields(builder);
        builder.append(" FROM ");
        builder.append(this.table);
        this.sqlSelectForHandle = builder.toString();
        builder = new StringBuilder("SELECT DISTINCT ");
        builder.append("CDO_ID");
        builder.append(" FROM ");
        builder.append(this.table);
        builder.append(" WHERE ");
        this.sqlSelectForChangeSet = builder.toString();
    }

    protected void appendSelectForHandleFields(StringBuilder builder) {
    }

    protected String getSQLSelectForHandle() {
        return this.sqlSelectForHandle;
    }

    protected String getSQLSelectForChangeSet() {
        return this.sqlSelectForChangeSet;
    }

    protected IDBField addContainerField(IDBTable table, DBType idType, int idLength) {
        return table.addField("CDO_CONTAINER", idType, idLength, true);
    }

    protected IDBField addBranchField(IDBTable table) {
        return null;
    }

    protected final boolean readValuesFromStatement(PreparedStatement stmt, InternalCDORevision revision, IDBStoreAccessor accessor) {
        ResultSet resultSet;
        block5: {
            block6: {
                resultSet = null;
                try {
                    if (TRACER.isEnabled()) {
                        TRACER.format("Executing Query: {0}", new Object[]{stmt.toString()});
                    }
                    stmt.setMaxRows(1);
                    resultSet = stmt.executeQuery();
                    IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
                    if (this.readValuesFromResultSet(resultSet, idHandler, revision, false)) break block5;
                    if (!TRACER.isEnabled()) break block6;
                    TRACER.format("Resultset was empty", new Object[0]);
                }
                catch (SQLException ex) {
                    try {
                        throw new DBException((Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        DBUtil.close(resultSet);
                        throw throwable;
                    }
                }
            }
            DBUtil.close((ResultSet)resultSet);
            return false;
        }
        DBUtil.close((ResultSet)resultSet);
        return true;
    }

    protected final boolean readValuesFromResultSet(ResultSet resultSet, IIDHandler idHandler, InternalCDORevision revision, boolean forUnit) {
        try {
            if (resultSet.next()) {
                IDBField field;
                EStructuralFeature feature;
                long timeStamp = resultSet.getLong("CDO_CREATED");
                CDOBranchPoint branchPoint = revision.getBranch().getPoint(timeStamp);
                if (forUnit) {
                    revision.setID(idHandler.getCDOID(resultSet, "CDO_ID"));
                }
                revision.setBranchPoint(branchPoint);
                revision.setVersion(resultSet.getInt("CDO_VERSION"));
                revision.setRevised(resultSet.getLong("CDO_REVISED"));
                revision.setResourceID(idHandler.getCDOID(resultSet, "CDO_RESOURCE"));
                revision.setContainerID((Object)idHandler.getCDOID(resultSet, "CDO_CONTAINER"));
                revision.setContainingFeatureID(resultSet.getInt("CDO_FEATURE"));
                for (ITypeMapping iTypeMapping : this.valueMappings) {
                    feature = iTypeMapping.getFeature();
                    if (feature.isUnsettable() && !resultSet.getBoolean((field = this.unsettableFields.get(feature)).getName())) {
                        revision.setValue(feature, null);
                        continue;
                    }
                    iTypeMapping.readValueToRevision(resultSet, revision);
                }
                if (this.listSizeFields != null) {
                    for (Map.Entry entry : this.listSizeFields.entrySet()) {
                        feature = (EStructuralFeature)entry.getKey();
                        field = (IDBField)entry.getValue();
                        int size = resultSet.getInt(field.getName());
                        if (size == -1) continue;
                        CDOList list = revision.getOrCreateList(feature, size);
                        int i = 0;
                        while (i < size) {
                            list.add(InternalCDOList.UNINITIALIZED);
                            ++i;
                        }
                    }
                }
                return true;
            }
            return false;
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }

    protected final void readLists(IDBStoreAccessor accessor, InternalCDORevision revision, int listChunk) {
        for (IListMapping listMapping : this.listMappings) {
            listMapping.readValues(accessor, revision, listChunk);
        }
    }

    protected final IMappingStrategy getMappingStrategy() {
        return this.mappingStrategy;
    }

    @Override
    public final EClass getEClass() {
        return this.eClass;
    }

    protected final Map<EStructuralFeature, IDBField> getUnsettableFields() {
        return this.unsettableFields;
    }

    protected final Map<EStructuralFeature, IDBField> getListSizeFields() {
        return this.listSizeFields;
    }

    @Override
    public final List<ITypeMapping> getValueMappings() {
        return this.valueMappings;
    }

    public final ITypeMapping getValueMapping(EStructuralFeature feature) {
        for (ITypeMapping mapping : this.valueMappings) {
            if (mapping.getFeature() != feature) continue;
            return mapping;
        }
        return null;
    }

    @Override
    public final List<IListMapping> getListMappings() {
        return this.listMappings;
    }

    @Override
    public final IListMapping getListMapping(EStructuralFeature feature) {
        for (IListMapping mapping : this.listMappings) {
            if (mapping.getFeature() != feature) continue;
            return mapping;
        }
        throw new IllegalArgumentException("List mapping for feature " + feature + " does not exist");
    }

    protected final IDBTable getTable() {
        return this.table;
    }

    @Override
    public List<IDBTable> getDBTables() {
        ArrayList<IDBTable> tables = new ArrayList<IDBTable>();
        tables.add(this.table);
        if (this.listMappings != null) {
            for (IListMapping listMapping : this.listMappings) {
                tables.addAll(listMapping.getDBTables());
            }
        }
        return tables;
    }

    public String toString() {
        return MessageFormat.format("{0}[{1} -> {2}]", this.getClass().getSimpleName(), this.eClass, this.table);
    }

    protected void checkDuplicateResources(IDBStoreAccessor accessor, CDORevision revision) throws IllegalStateException {
        String name;
        CDOID folderID = (CDOID)revision.data().getContainerID();
        CDOID existingID = accessor.readResourceID(folderID, name = (String)revision.data().get((EStructuralFeature)EresourcePackage.eINSTANCE.getCDOResourceNode_Name(), 0), revision.getBranch().getHead());
        if (existingID != null && !existingID.equals(revision.getID())) {
            throw new IllegalStateException("Duplicate resource node in folder " + folderID + ": " + name);
        }
    }

    protected void writeLists(IDBStoreAccessor accessor, InternalCDORevision revision, boolean firstRevision, boolean raw) {
        for (IListMapping listMapping : this.listMappings) {
            if (listMapping instanceof IListMapping4) {
                ((IListMapping4)((Object)listMapping)).writeValues(accessor, (CDORevision)revision, firstRevision, raw);
                continue;
            }
            listMapping.writeValues(accessor, revision);
        }
    }

    @Override
    public void writeRevision(IDBStoreAccessor accessor, InternalCDORevision revision, boolean firstRevision, boolean revise, OMMonitor monitor) {
        if (this.table == null) {
            this.initTable(accessor);
        }
        CDOID id = revision.getID();
        InternalCDOBranch branch = revision.getBranch();
        long timeStamp = revision.getTimeStamp();
        if (revision instanceof DetachedCDORevision) {
            int version = revision.getVersion();
            this.detachAttributes(accessor, id, version, (CDOBranch)branch, timeStamp, monitor);
            long revised = revision.getRevised();
            if (revised != 0L) {
                this.reviseOldRevision(accessor, id, (CDOBranch)branch, revised);
            }
            return;
        }
        boolean duplicateResourcesCheckNeeded = revision.isResourceNode() && this.mappingStrategy.getStore().getRepository().getRootResourceID() != null;
        monitor.begin((double)(duplicateResourcesCheckNeeded ? 10 : 9));
        OMMonitor.Async async = null;
        try {
            try {
                async = monitor.forkAsync();
                if (firstRevision) {
                    this.mappingStrategy.putObjectType(accessor, timeStamp, id, this.eClass);
                } else if (revise) {
                    long revised = timeStamp - 1L;
                    this.reviseOldRevision(accessor, id, (CDOBranch)branch, revised);
                    for (IListMapping mapping : this.getListMappings()) {
                        mapping.objectDetached(accessor, id, revised);
                    }
                }
            }
            finally {
                if (async != null) {
                    async.stop();
                }
            }
            if (duplicateResourcesCheckNeeded) {
                try {
                    async = monitor.forkAsync();
                    this.checkDuplicateResources(accessor, (CDORevision)revision);
                }
                finally {
                    if (async != null) {
                        async.stop();
                    }
                }
            }
            try {
                async = monitor.forkAsync();
                this.writeValues(accessor, revision);
            }
            finally {
                if (async != null) {
                    async.stop();
                }
            }
            try {
                if (this.listMappings != null) {
                    async = monitor.forkAsync(7.0);
                    this.writeLists(accessor, revision, firstRevision, !revise);
                } else {
                    monitor.worked(7.0);
                }
            }
            finally {
                if (async != null) {
                    async.stop();
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void handleRevisions(IDBStoreAccessor accessor, CDOBranch branch, long timeStamp, boolean exactTime, CDORevisionHandler handler) {
        if (this.table == null) {
            return;
        }
        IRepository repository = accessor.getStore().getRepository();
        CDORevisionManager revisionManager = repository.getRevisionManager();
        CDOBranchManager branchManager = repository.getBranchManager();
        CDOBranch mainBranch = branchManager.getMainBranch();
        StringBuilder builder = new StringBuilder(this.sqlSelectForHandle);
        int timeParameters = 0;
        if (timeStamp != -1L) {
            if (exactTime) {
                if (timeStamp != 0L) {
                    builder.append(" WHERE ");
                    builder.append("CDO_CREATED");
                    builder.append("=?");
                    timeParameters = 1;
                }
            } else {
                builder.append(" WHERE ");
                if (timeStamp != 0L) {
                    builder.append("CDO_CREATED");
                    builder.append("<=?");
                    builder.append(" AND (");
                    builder.append("CDO_REVISED");
                    builder.append(">=? OR ");
                    builder.append("CDO_REVISED");
                    builder.append("=0)");
                    timeParameters = 2;
                } else {
                    builder.append("CDO_REVISED");
                    builder.append("=0");
                }
            }
        }
        builder.append(" ORDER BY ");
        builder.append("CDO_ID");
        builder.append(", ");
        builder.append("CDO_VERSION");
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(builder.toString(), IDBPreparedStatement.ReuseProbability.LOW);
        IDBResultSet resultSet = null;
        try {
            try {
                int i = 0;
                while (i < timeParameters) {
                    stmt.setLong(i + 1, timeStamp);
                    ++i;
                }
                resultSet = stmt.executeQuery();
                while (resultSet.next()) {
                    CDOBranchVersion branchVersion;
                    InternalCDORevision revision;
                    long revised;
                    long created;
                    EClass eClass;
                    DetachedCDORevision revision2;
                    CDOID id = idHandler.getCDOID((ResultSet)resultSet, 1);
                    int version = resultSet.getInt(2);
                    if (!(version < 1 ? !handler.handleRevision((CDORevision)(revision2 = new DetachedCDORevision(eClass = this.getEClass(), id, mainBranch, -version, created = resultSet.getLong(3), revised = resultSet.getLong(4)))) : !handler.handleRevision((CDORevision)(revision = (InternalCDORevision)revisionManager.getRevisionByVersion(id, branchVersion = mainBranch.getVersion(version), -1, true))))) {
                        continue;
                    }
                    break;
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            DBUtil.close((Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
    }

    @Override
    public Set<CDOID> readChangeSet(IDBStoreAccessor accessor, CDOChangeSetSegment[] segments) {
        HashSet<CDOID> hashSet;
        HashSet<CDOID> result = new HashSet<CDOID>();
        if (this.table == null) {
            return result;
        }
        StringBuilder builder = new StringBuilder(this.sqlSelectForChangeSet);
        boolean isFirst = true;
        int i = 0;
        while (i < segments.length) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(" OR ");
            }
            builder.append("CDO_CREATED");
            builder.append(">=?");
            builder.append(" AND (");
            builder.append("CDO_REVISED");
            builder.append("<=? OR ");
            builder.append("CDO_REVISED");
            builder.append("=0)");
            ++i;
        }
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(builder.toString(), IDBPreparedStatement.ReuseProbability.LOW);
        IDBResultSet resultSet = null;
        try {
            int column = 1;
            CDOChangeSetSegment[] cDOChangeSetSegmentArray = segments;
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                CDOChangeSetSegment segment = cDOChangeSetSegmentArray[n2];
                stmt.setLong(column++, segment.getTimeStamp());
                stmt.setLong(column++, segment.getEndTime());
                ++n2;
            }
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                CDOID id = idHandler.getCDOID((ResultSet)resultSet, 1);
                result.add(id);
            }
            hashSet = result;
        }
        catch (SQLException e) {
            try {
                throw new DBException((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                DBUtil.close((Statement)stmt);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
        return hashSet;
    }

    @Override
    public void detachObject(IDBStoreAccessor accessor, CDOID id, int version, CDOBranch branch, long timeStamp, OMMonitor monitor) {
        if (this.table == null) {
            return;
        }
        OMMonitor.Async async = null;
        monitor.begin((double)(1 + this.listMappings.size()));
        try {
            if (version >= 1) {
                this.reviseOldRevision(accessor, id, branch, timeStamp - 1L);
            }
            this.detachAttributes(accessor, id, version, branch, timeStamp, monitor.fork());
            for (IListMapping mapping : this.getListMappings()) {
                try {
                    async = monitor.forkAsync();
                    mapping.objectDetached(accessor, id, timeStamp);
                }
                finally {
                    if (async != null) {
                        async.stop();
                    }
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    public void rawDelete(IDBStoreAccessor accessor, CDOID id, int version, CDOBranch branch, OMMonitor monitor) {
        if (this.table == null) {
            return;
        }
        OMMonitor.Async async = null;
        monitor.begin((double)(1 + this.listMappings.size()));
        try {
            this.rawDeleteAttributes(accessor, id, branch, version, monitor.fork());
            for (IListMapping mapping : this.getListMappings()) {
                if (mapping instanceof AbstractBasicListTableMapping) {
                    try {
                        async = monitor.forkAsync();
                        AbstractBasicListTableMapping m = (AbstractBasicListTableMapping)mapping;
                        m.rawDeleted(accessor, id, branch, version);
                        continue;
                    }
                    finally {
                        if (async != null) {
                            async.stop();
                        }
                    }
                }
                throw new UnsupportedOperationException("rawDeleted() is not supported by " + mapping.getClass().getName());
            }
        }
        finally {
            monitor.done();
        }
    }

    protected abstract void rawDeleteAttributes(IDBStoreAccessor var1, CDOID var2, CDOBranch var3, int var4, OMMonitor var5);

    @Override
    public final boolean queryXRefs(IDBStoreAccessor accessor, IStoreAccessor.QueryXRefsContext context, String idString) {
        boolean more;
        if (this.table == null) {
            return true;
        }
        String tableName = this.table.getName();
        List refs = (List)context.getSourceCandidates().get(this.eClass);
        ArrayList<EReference> scalarRefs = new ArrayList<EReference>();
        for (EReference ref : refs) {
            if (ref.isMany()) {
                String where;
                IListMapping listMapping = this.getListMapping((EStructuralFeature)ref);
                boolean more2 = listMapping.queryXRefs(accessor, tableName, where = this.getListXRefsWhere(context), context, idString);
                if (more2) continue;
                return false;
            }
            scalarRefs.add(ref);
        }
        return scalarRefs.isEmpty() || (more = this.queryScalarXRefs(accessor, scalarRefs, context, idString));
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final boolean queryScalarXRefs(IDBStoreAccessor accessor, List<EReference> scalarRefs, IStoreAccessor.QueryXRefsContext context, String idString) {
        IDBResultSet resultSet;
        IDBPreparedStatement stmt;
        String tableName = this.table.getName();
        String where = this.getListXRefsWhere(context);
        for (EReference ref : scalarRefs) {
            ITypeMapping valueMapping = this.getValueMapping((EStructuralFeature)ref);
            String valueField = valueMapping.getField().getName();
            StringBuilder builder = new StringBuilder();
            builder.append("SELECT ");
            builder.append("CDO_ID");
            builder.append(", ");
            builder.append(valueField);
            builder.append(" FROM ");
            builder.append(tableName);
            builder.append(" WHERE ");
            builder.append("CDO_VERSION");
            builder.append(">0 AND ");
            builder.append(where);
            builder.append(" AND ");
            builder.append(valueField);
            builder.append(" IN ");
            builder.append(idString);
            String sql = builder.toString();
            if (TRACER.isEnabled()) {
                TRACER.format("Query XRefs (attributes): {0}", new Object[]{sql});
            }
            IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
            stmt = accessor.getDBConnection().prepareStatement(sql, IDBPreparedStatement.ReuseProbability.MEDIUM);
            resultSet = null;
            resultSet = stmt.executeQuery();
            boolean bl = true;
            while (true) {
                if (!bl || (bl = false) || !true) {
                    CDOID sourceID = idHandler.getCDOID((ResultSet)resultSet, 1);
                    CDOID targetID = idHandler.getCDOID((ResultSet)resultSet, 2);
                    boolean more = context.addXRef(targetID, sourceID, ref, 0);
                    if (TRACER.isEnabled()) {
                        TRACER.format("  add XRef to context: src={0}, tgt={1}, idx=0", new Object[]{sourceID, targetID});
                    }
                    if (!more) {
                        if (!TRACER.isEnabled()) return false;
                        TRACER.format("  result limit reached. Ignoring further results.", new Object[0]);
                        return false;
                    }
                }
                if (resultSet.next()) continue;
                break;
            }
            {
                continue;
                catch (SQLException ex) {}
                throw new DBException((Throwable)ex);
                return true;
            }
        }
        finally {
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmt);
        }
    }

    protected abstract String getListXRefsWhere(IStoreAccessor.QueryXRefsContext var1);

    protected abstract void detachAttributes(IDBStoreAccessor var1, CDOID var2, int var3, CDOBranch var4, long var5, OMMonitor var7);

    protected abstract void reviseOldRevision(IDBStoreAccessor var1, CDOID var2, CDOBranch var3, long var4);

    protected abstract void writeValues(IDBStoreAccessor var1, InternalCDORevision var2);

    public Exception deactivate() {
        return null;
    }

    protected static void appendTypeMappingNames(StringBuilder builder, Collection<ITypeMapping> typeMappings) {
        if (typeMappings != null) {
            for (ITypeMapping typeMapping : typeMappings) {
                builder.append(", ");
                builder.append(typeMapping.getField());
            }
        }
    }

    protected static void appendFieldNames(StringBuilder builder, Map<EStructuralFeature, IDBField> fields) {
        if (fields != null) {
            for (IDBField field : fields.values()) {
                builder.append(", ");
                builder.append(field);
            }
        }
    }

    protected static void appendTypeMappingParameters(StringBuilder builder, Collection<ITypeMapping> typeMappings) {
        if (typeMappings != null) {
            int i = 0;
            while (i < typeMappings.size()) {
                builder.append(", ?");
                ++i;
            }
        }
    }

    protected static void appendFieldParameters(StringBuilder builder, Map<EStructuralFeature, IDBField> fields) {
        if (fields != null) {
            int i = 0;
            while (i < fields.size()) {
                builder.append(", ?");
                ++i;
            }
        }
    }

    protected abstract class AbstractFeatureDeltaWriter
    implements CDOFeatureDeltaVisitor {
        protected IDBStoreAccessor accessor;
        protected long created;
        protected CDOID id;

        protected AbstractFeatureDeltaWriter() {
        }

        public final void process(IDBStoreAccessor accessor, InternalCDORevisionDelta delta, long created) {
            this.accessor = accessor;
            this.created = created;
            this.id = delta.getID();
            if (AbstractHorizontalClassMapping.this.table == null) {
                AbstractHorizontalClassMapping.this.initTable(accessor);
            }
            this.doProcess(delta);
        }

        protected abstract void doProcess(InternalCDORevisionDelta var1);

        @Deprecated
        public final void visit(CDOAddFeatureDelta delta) {
            throw new ImplementationError("Should not be called");
        }

        @Deprecated
        public final void visit(CDORemoveFeatureDelta delta) {
            throw new ImplementationError("Should not be called");
        }

        @Deprecated
        public final void visit(CDOMoveFeatureDelta delta) {
            throw new ImplementationError("Should not be called");
        }

        @Deprecated
        public final void visit(CDOClearFeatureDelta delta) {
            throw new ImplementationError("Should not be called");
        }
    }
}

