/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerIndicationWithMonitoring;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.spi.server.IAuthenticationProtocol;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.security.CredentialsUpdateOperation;
import org.eclipse.net4j.util.security.NotAuthenticatedException;

public class ChangeCredentialsIndication
extends CDOServerIndicationWithMonitoring {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, ChangeCredentialsIndication.class);
    private CredentialsUpdateOperation operation;
    private String userID;

    public ChangeCredentialsIndication(CDOServerProtocol protocol) {
        super(protocol, (short)56);
    }

    protected int getIndicatingWorkPercent() {
        return 20;
    }

    protected void indicating(CDODataInput in, OMMonitor monitor) throws Exception {
        this.operation = (CredentialsUpdateOperation)in.readEnum(CredentialsUpdateOperation.class);
        this.userID = in.readString();
        if (TRACER.isEnabled()) {
            TRACER.format("Initiating {0} of user credentials", new Object[]{this.operation});
        }
    }

    protected void responding(CDODataOutput out, OMMonitor monitor) throws Exception {
        monitor.begin();
        OMMonitor.Async async = monitor.forkAsync();
        try {
            try {
                InternalSessionManager sessionManager = this.getRepository().getSessionManager();
                switch (this.operation) {
                    case CHANGE_PASSWORD: {
                        sessionManager.changeUserCredentials((IAuthenticationProtocol)this.getProtocol(), this.getSession().getUserID());
                        break;
                    }
                    case RESET_PASSWORD: {
                        sessionManager.resetUserCredentials((IAuthenticationProtocol)this.getProtocol(), this.userID);
                    }
                }
                if (TRACER.isEnabled()) {
                    TRACER.format("Credentials %s processed.", new Object[]{this.operation});
                }
                out.writeBoolean(true);
            }
            catch (NotAuthenticatedException ex) {
                out.writeBoolean(false);
            }
        }
        finally {
            async.stop();
            monitor.done();
        }
    }
}

