/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.impl.policies;

import java.util.Comparator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.api.scopes.IModelScope;
import org.eclipse.emf.diffmerge.api.scopes.IPersistentModelScope;
import org.eclipse.emf.diffmerge.util.ModelImplUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DefaultMatchPolicy
implements IMatchPolicy {
    private boolean _keepMatchIDs = false;

    protected Comparable<?> getExtrinsicID(EObject element_p, IModelScope scope_p) {
        Object extrinsic;
        Object result = null;
        if (scope_p instanceof IPersistentModelScope && (extrinsic = ((IPersistentModelScope)scope_p).getExtrinsicID(element_p)) instanceof Comparable) {
            result = (Comparable)extrinsic;
        }
        if (result == null) {
            result = ModelImplUtil.getXMLID(element_p);
        }
        return result;
    }

    protected String getIntrinsicID(EObject element_p) {
        return ModelImplUtil.getIntrinsicID(element_p);
    }

    @Override
    public Object getMatchID(EObject element_p, IModelScope scope_p) {
        Object result = this.getIntrinsicID(element_p);
        if (result == null) {
            result = this.getExtrinsicID(element_p, scope_p);
        }
        if (result == null) {
            result = this.getURIBasedMatchID(element_p);
        }
        return result;
    }

    public Comparator<Object> getMatchIDComparator() {
        return NATURAL_ORDER_COMPARATOR;
    }

    protected String getURIBasedMatchID(EObject element_p) {
        String result = null;
        URI uri = EcoreUtil.getURI((EObject)element_p);
        if (uri != null) {
            result = uri.isPlatformResource() && uri.fragment() != null ? uri.fragment() : uri.toString();
        }
        return result;
    }

    @Override
    public boolean keepMatchIDs() {
        return this._keepMatchIDs;
    }

    public void setKeepMatchIDs(boolean keep_p) {
        this._keepMatchIDs = keep_p;
    }
}

