/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication;

import java.util.Properties;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.verifiers.EMFModelUserVerifier;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.verifiers.LDAPUserVerifier;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.verifiers.SimplePropertyFileUserVerifier;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.verifiers.UserVerifierChain;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.internal.server.exceptions.InvalidPropertyException;
import org.eclipse.emf.emfstore.server.auth.ESAuthenticationControlType;
import org.eclipse.emf.emfstore.server.auth.ESUserVerifier;
import org.eclipse.emf.emfstore.server.model.ESOrgUnitProvider;

public final class ESUserVerifierFactory {
    private static ESUserVerifierFactory instance = new ESUserVerifierFactory();

    private ESUserVerifierFactory() {
    }

    public static ESUserVerifierFactory getInstance() {
        return instance;
    }

    public ESUserVerifier createUserVerifier(ESAuthenticationControlType authenticationControlType, ESOrgUnitProvider orgUnitProvider) throws FatalESException {
        if (authenticationControlType.equals((Object)ESAuthenticationControlType.ldap)) {
            UserVerifierChain chain = new UserVerifierChain(orgUnitProvider);
            Properties properties = ServerConfiguration.getProperties();
            int count = 1;
            while (count != -1) {
                String ldapUrl = properties.getProperty("emfstore.accesscontrol.authentication.ldap." + count + "." + "url");
                String ldapBase = properties.getProperty("emfstore.accesscontrol.authentication.ldap." + count + "." + "base");
                String searchDn = properties.getProperty("emfstore.accesscontrol.authentication.ldap." + count + "." + "searchdn");
                String authUser = properties.getProperty("emfstore.accesscontrol.authentication.ldap." + count + "." + "authuser");
                String authPassword = properties.getProperty("emfstore.accesscontrol.authentication.ldap." + count + "." + "authpass");
                if (ldapUrl != null && ldapBase != null && searchDn != null) {
                    LDAPUserVerifier ldapVerifier = new LDAPUserVerifier(orgUnitProvider, ldapUrl, ldapBase, searchDn, authUser, authPassword);
                    chain.getVerifiers().add(ldapVerifier);
                    ++count;
                    continue;
                }
                count = -1;
            }
            return chain;
        }
        if (authenticationControlType.equals((Object)ESAuthenticationControlType.spfv)) {
            return new SimplePropertyFileUserVerifier(orgUnitProvider, ServerConfiguration.getProperties().getProperty("emfstore.accesscontrol.authentication.spfv", ServerConfiguration.getDefaultSPFVFilePath()));
        }
        if (authenticationControlType.equals((Object)ESAuthenticationControlType.model)) {
            return new EMFModelUserVerifier(orgUnitProvider);
        }
        throw new InvalidPropertyException();
    }
}

