/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.logging.aeri.core.handlers;

import java.util.concurrent.TimeUnit;

import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.epp.logging.aeri.core.ISystemSettings;
import org.eclipse.epp.logging.aeri.core.ResetSendMode;
import org.eclipse.epp.logging.aeri.core.SendMode;

public class SetSendModeHandler {

    @Execute
    public void execute(SendMode mode, ResetSendMode when, ISystemSettings system) {
        system.setSendMode(mode);
        system.setResetSendMode(when);
        switch (when) {
        case HOURS_24:
            system.setResetSendModeOn(in24Hours());
        case RESTART:
        case KEEP:
        case PERMANENT:
            system.setResetSendModeOn(0);
        }
    }

    private static long in24Hours() {
        return System.currentTimeMillis() + TimeUnit.DAYS.toMillis(1);
    }

}
