/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.common.collections;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;

public class MapListenerHelperEx<K, V> {
    private List<InvalidationListener> invalidationListeners = null;
    private boolean lockInvalidationListeners;
    private boolean lockMapChangeListeners;
    private List<MapChangeListener<? super K, ? super V>> mapChangeListeners = null;
    private ObservableMap<K, V> source;

    public MapListenerHelperEx(ObservableMap<K, V> source) {
        this.source = source;
    }

    public void addListener(InvalidationListener listener) {
        if (this.invalidationListeners == null) {
            this.invalidationListeners = new ArrayList<InvalidationListener>();
        }
        if (this.lockInvalidationListeners) {
            this.invalidationListeners = new ArrayList<InvalidationListener>(this.invalidationListeners);
        }
        this.invalidationListeners.add(listener);
    }

    public void addListener(MapChangeListener<? super K, ? super V> listener) {
        if (this.mapChangeListeners == null) {
            this.mapChangeListeners = new ArrayList<MapChangeListener<? super K, ? super V>>();
        }
        if (this.lockMapChangeListeners) {
            this.mapChangeListeners = new ArrayList<MapChangeListener<K, V>>(this.mapChangeListeners);
        }
        this.mapChangeListeners.add(listener);
    }

    public void fireValueChangedEvent(MapChangeListener.Change<? extends K, ? extends V> change) {
        this.notifyInvalidationListeners();
        if (change != null) {
            this.notifyMapChangeListeners(change);
        }
    }

    protected ObservableMap<K, V> getSource() {
        return this.source;
    }

    protected void notifyInvalidationListeners() {
        if (this.invalidationListeners != null) {
            try {
                this.lockInvalidationListeners = true;
                for (InvalidationListener l : this.invalidationListeners) {
                    try {
                        l.invalidated(this.source);
                    }
                    catch (Exception e) {
                        Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
                    }
                }
            }
            finally {
                this.lockInvalidationListeners = false;
            }
        }
    }

    protected void notifyMapChangeListeners(MapChangeListener.Change<? extends K, ? extends V> change) {
        if (this.mapChangeListeners != null && !this.mapChangeListeners.isEmpty()) {
            try {
                this.lockMapChangeListeners = true;
                for (MapChangeListener<? super K, ? super V> mapChangeListener : this.mapChangeListeners) {
                    try {
                        mapChangeListener.onChanged(change);
                    }
                    catch (Exception e) {
                        Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
                    }
                }
            }
            finally {
                this.lockMapChangeListeners = false;
            }
        }
    }

    public void removeListener(InvalidationListener listener) {
        if (this.invalidationListeners == null) {
            return;
        }
        if (this.lockInvalidationListeners) {
            this.invalidationListeners = new ArrayList<InvalidationListener>(this.invalidationListeners);
        }
        Iterator<InvalidationListener> iterator = this.invalidationListeners.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(listener)) continue;
            iterator.remove();
            break;
        }
        if (this.invalidationListeners.isEmpty()) {
            this.invalidationListeners = null;
        }
    }

    public void removeListener(MapChangeListener<? super K, ? super V> listener) {
        if (this.mapChangeListeners == null) {
            return;
        }
        if (this.lockMapChangeListeners) {
            this.mapChangeListeners = new ArrayList<MapChangeListener<K, V>>(this.mapChangeListeners);
        }
        Iterator<MapChangeListener<K, V>> iterator = this.mapChangeListeners.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(listener)) continue;
            iterator.remove();
            break;
        }
        if (this.mapChangeListeners.isEmpty()) {
            this.mapChangeListeners = null;
        }
    }

    public static class AtomicChange<K, V>
    extends MapChangeListener.Change<K, V> {
        private K key;
        private V removedValue;
        private V addedValue;

        public AtomicChange(ObservableMap<K, V> source, K key, V removedValue, V addedValue) {
            super(source);
            this.key = key;
            this.removedValue = removedValue;
            this.addedValue = addedValue;
        }

        public AtomicChange(ObservableMap<K, V> source, MapChangeListener.Change<? extends K, ? extends V> change) {
            super(source);
            this.key = change.getKey();
            this.addedValue = change.getValueAdded();
            this.removedValue = change.getValueRemoved();
        }

        public K getKey() {
            return this.key;
        }

        public V getValueAdded() {
            return this.addedValue;
        }

        public V getValueRemoved() {
            return this.removedValue;
        }

        public String toString() {
            if (this.wasAdded()) {
                if (this.wasRemoved()) {
                    return "Replaced " + this.removedValue + " by " + this.addedValue + " for key " + this.key + ".";
                }
                return "Added " + this.addedValue + " for key " + this.key + ".";
            }
            return "Removed " + this.removedValue + " for key " + this.key + ".";
        }

        public boolean wasAdded() {
            return this.addedValue != null;
        }

        public boolean wasRemoved() {
            return this.removedValue != null;
        }
    }
}

