/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.internal.impl.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Class representing the TableComponentActionHandler component from the concrete toolkit.
 * @since 4.0
 */
@RealizedType(realizedType="guidancer.abstract.TextInputSupport")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2019-11-26T06:47:22.990Z")
public class TableComponentActionHandler extends org.eclipse.jubula.toolkit.base.internal.impl.handler.TextInputComponentActionHandler implements org.eclipse.jubula.toolkit.concrete.components.handler.TableComponentActionHandler {
            public TableComponentActionHandler(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @param text 
         *        the text to use
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * 
         */
        public Result inputTextSpecifyCell(
            @Nullable String text,
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator
        )  {
            if (text == null) return null;
            
            if (row == null) return null;
            
            if (rowOperator == null) return null;
            
            if (column == null) return null;
            
            if (columnOperator == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcInputText")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(text)
                            .addParameter(row)
                            .addParameter(rowOperator.rcValue())
                            .addParameter(column)
                            .addParameter(columnOperator.rcValue())
                            .build(), null);
        }
        
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * 
         */
        public Result replaceTextSpecifyCell(
            @Nullable String text,
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator
        )  {
            if (text == null) return null;
            
            if (row == null) return null;
            
            if (rowOperator == null) return null;
            
            if (column == null) return null;
            
            if (columnOperator == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcReplaceText")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(text)
                            .addParameter(row)
                            .addParameter(rowOperator.rcValue())
                            .addParameter(column)
                            .addParameter(columnOperator.rcValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param numberOfClicks 
         *        the amount of interactions
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param extendSelection 
         *        whether to extend the selection or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public Result selectCell(
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable Integer numberOfClicks,
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable BinaryChoice extendSelection,
            @Nullable InteractionMode mouseButton
        )  {
            if (row == null) return null;
            
            if (rowOperator == null) return null;
            
            if (column == null) return null;
            
            if (columnOperator == null) return null;
            
            if (numberOfClicks == null) return null;
            
            if (xPosition == null) return null;
            
            if (xUnits == null) return null;
            
            if (yPosition == null) return null;
            
            if (yUnits == null) return null;
            
            if (extendSelection == null) return null;
            
            if (mouseButton == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcSelectCell")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(row)
                            .addParameter(rowOperator.rcValue())
                            .addParameter(column)
                            .addParameter(columnOperator.rcValue())
                            .addParameter(numberOfClicks)
                            .addParameter(xPosition)
                            .addParameter(xUnits.rcValue())
                            .addParameter(yPosition)
                            .addParameter(yUnits.rcValue())
                            .addParameter(extendSelection.rcValue())
                            .addParameter(mouseButton.rcIntValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param direction 
         *        the direction
         * @param numberOfCells 
         *        the number of cells
         * @param numberOfClicks 
         *        the amount of interactions
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param extendSelection 
         *        whether to extend the selection or not
         * 
         */
        public Result move(
            @Nullable Direction direction,
            @Nullable Integer numberOfCells,
            @Nullable Integer numberOfClicks,
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable BinaryChoice extendSelection
        )  {
            if (direction == null) return null;
            
            if (numberOfCells == null) return null;
            
            if (numberOfClicks == null) return null;
            
            if (xPosition == null) return null;
            
            if (xUnits == null) return null;
            
            if (yPosition == null) return null;
            
            if (yUnits == null) return null;
            
            if (extendSelection == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcMove")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(direction.rcValue())
                            .addParameter(numberOfCells)
                            .addParameter(numberOfClicks)
                            .addParameter(xPosition)
                            .addParameter(xUnits.rcValue())
                            .addParameter(yPosition)
                            .addParameter(yUnits.rcValue())
                            .addParameter(extendSelection.rcValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param editable 
         *        whether the component is expected to be editable or not
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkEditabilitySpecifyCell(
            @Nullable Boolean editable,
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable Integer timeoutInMs
        )  {
            if (editable == null) return null;
            
            if (row == null) return null;
            
            if (rowOperator == null) return null;
            
            if (column == null) return null;
            
            if (columnOperator == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyEditable")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(editable)
                            .addParameter(row)
                            .addParameter(rowOperator.rcValue())
                            .addParameter(column)
                            .addParameter(columnOperator.rcValue())
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param editable 
         *        whether the component is expected to be editable or not
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @since 4.1
         */
        public Result checkEditabilitySpecifyCell(
            @Nullable Boolean editable,
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator
        )  {
            if (editable == null) return null;
            
            if (row == null) return null;
            
            if (rowOperator == null) return null;
            
            if (column == null) return null;
            
            if (columnOperator == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyEditable")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(editable)
                            .addParameter(row)
                            .addParameter(rowOperator.rcValue())
                            .addParameter(column)
                            .addParameter(columnOperator.rcValue())
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param editable 
         *        whether the component is expected to be editable or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkEditabilityOfSelectedCell(
            @Nullable Boolean editable,
            @Nullable Integer timeoutInMs
        )  {
            if (editable == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyEditableSelected")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(editable)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param editable 
         *        whether the component is expected to be editable or not
         * @since 4.1
         */
        public Result checkEditabilityOfSelectedCell(
            @Nullable Boolean editable
        )  {
            if (editable == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyEditableSelected")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(editable)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param editable 
         *        whether the component is expected to be editable or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkEditabilityOfCellMousePosition(
            @Nullable Boolean editable,
            @Nullable Integer timeoutInMs
        )  {
            if (editable == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyEditableMousePosition")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(editable)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param editable 
         *        whether the component is expected to be editable or not
         * @since 4.1
         */
        public Result checkEditabilityOfCellMousePosition(
            @Nullable Boolean editable
        )  {
            if (editable == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyEditableMousePosition")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(editable)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param textOperator 
         *        the text operator
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkTextSpecifyCell(
            @Nullable String text,
            @Nullable Operator textOperator,
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable Integer timeoutInMs
        )  {
            if (text == null) return null;
            
            if (textOperator == null) return null;
            
            if (row == null) return null;
            
            if (rowOperator == null) return null;
            
            if (column == null) return null;
            
            if (columnOperator == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyText")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(text)
                            .addParameter(textOperator.rcValue())
                            .addParameter(row)
                            .addParameter(rowOperator.rcValue())
                            .addParameter(column)
                            .addParameter(columnOperator.rcValue())
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param text 
         *        the text to use
         * @param textOperator 
         *        the text operator
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @since 4.1
         */
        public Result checkTextSpecifyCell(
            @Nullable String text,
            @Nullable Operator textOperator,
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator
        )  {
            if (text == null) return null;
            
            if (textOperator == null) return null;
            
            if (row == null) return null;
            
            if (rowOperator == null) return null;
            
            if (column == null) return null;
            
            if (columnOperator == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyText")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(text)
                            .addParameter(textOperator.rcValue())
                            .addParameter(row)
                            .addParameter(rowOperator.rcValue())
                            .addParameter(column)
                            .addParameter(columnOperator.rcValue())
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkTextMousePosition(
            @Nullable String text,
            @Nullable Operator operator,
            @Nullable Integer timeoutInMs
        )  {
            if (text == null) return null;
            
            if (operator == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyTextAtMousePosition")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(text)
                            .addParameter(operator.rcValue())
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @since 4.1
         */
        public Result checkTextMousePosition(
            @Nullable String text,
            @Nullable Operator operator
        )  {
            if (text == null) return null;
            
            if (operator == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyTextAtMousePosition")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(text)
                            .addParameter(operator.rcValue())
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkExistenceOfValueInRow(
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable SearchType searchType,
            @Nullable Boolean exists,
            @Nullable Integer timeoutInMs
        )  {
            if (row == null) return null;
            
            if (rowOperator == null) return null;
            
            if (value == null) return null;
            
            if (valueOperator == null) return null;
            
            if (searchType == null) return null;
            
            if (exists == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyValueInRow")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(row)
                            .addParameter(rowOperator.rcValue())
                            .addParameter(value)
                            .addParameter(valueOperator.rcValue())
                            .addParameter(searchType.rcValue())
                            .addParameter(exists)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param exists 
         *        whether existence is expected or not
         * @since 4.1
         */
        public Result checkExistenceOfValueInRow(
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable SearchType searchType,
            @Nullable Boolean exists
        )  {
            if (row == null) return null;
            
            if (rowOperator == null) return null;
            
            if (value == null) return null;
            
            if (valueOperator == null) return null;
            
            if (searchType == null) return null;
            
            if (exists == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyValueInRow")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(row)
                            .addParameter(rowOperator.rcValue())
                            .addParameter(value)
                            .addParameter(valueOperator.rcValue())
                            .addParameter(searchType.rcValue())
                            .addParameter(exists)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkExistenceOfValueInColumn(
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable SearchType searchType,
            @Nullable Boolean exists,
            @Nullable Integer timeoutInMs
        )  {
            if (column == null) return null;
            
            if (columnOperator == null) return null;
            
            if (value == null) return null;
            
            if (valueOperator == null) return null;
            
            if (searchType == null) return null;
            
            if (exists == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyValueInColumn")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(column)
                            .addParameter(columnOperator.rcValue())
                            .addParameter(value)
                            .addParameter(valueOperator.rcValue())
                            .addParameter(searchType.rcValue())
                            .addParameter(exists)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param exists 
         *        whether existence is expected or not
         * @since 4.1
         */
        public Result checkExistenceOfValueInColumn(
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable SearchType searchType,
            @Nullable Boolean exists
        )  {
            if (column == null) return null;
            
            if (columnOperator == null) return null;
            
            if (value == null) return null;
            
            if (valueOperator == null) return null;
            
            if (searchType == null) return null;
            
            if (exists == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyValueInColumn")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(column)
                            .addParameter(columnOperator.rcValue())
                            .addParameter(value)
                            .addParameter(valueOperator.rcValue())
                            .addParameter(searchType.rcValue())
                            .addParameter(exists)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param numberOfClicks 
         *        the amount of interactions
         * @param extendSelection 
         *        whether to extend the selection or not
         * @param searchType 
         *        the search type
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public Result selectValueFromColumn(
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable Integer numberOfClicks,
            @Nullable BinaryChoice extendSelection,
            @Nullable SearchType searchType,
            @Nullable InteractionMode mouseButton
        )  {
            if (column == null) return null;
            
            if (columnOperator == null) return null;
            
            if (value == null) return null;
            
            if (valueOperator == null) return null;
            
            if (numberOfClicks == null) return null;
            
            if (extendSelection == null) return null;
            
            if (searchType == null) return null;
            
            if (mouseButton == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcSelectRowByValue")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(column)
                            .addParameter(columnOperator.rcValue())
                            .addParameter(value)
                            .addParameter(valueOperator.rcValue())
                            .addParameter(numberOfClicks)
                            .addParameter(extendSelection.rcValue())
                            .addParameter(searchType.rcValue())
                            .addParameter(mouseButton.rcIntValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param numberOfClicks 
         *        the amount of interactions
         * @param extendSelection 
         *        whether to extend the selection or not
         * @param searchType 
         *        the search type
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public Result selectValueFromRow(
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable Integer numberOfClicks,
            @Nullable BinaryChoice extendSelection,
            @Nullable SearchType searchType,
            @Nullable InteractionMode mouseButton
        )  {
            if (row == null) return null;
            
            if (rowOperator == null) return null;
            
            if (value == null) return null;
            
            if (valueOperator == null) return null;
            
            if (numberOfClicks == null) return null;
            
            if (extendSelection == null) return null;
            
            if (searchType == null) return null;
            
            if (mouseButton == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcSelectCellByColValue")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(row)
                            .addParameter(rowOperator.rcValue())
                            .addParameter(value)
                            .addParameter(valueOperator.rcValue())
                            .addParameter(numberOfClicks)
                            .addParameter(extendSelection.rcValue())
                            .addParameter(searchType.rcValue())
                            .addParameter(mouseButton.rcIntValue())
                            .build(), null);
        }
        
        
        /**
         * CompSystem.ReadTableCellValueAPI.descr
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @since 4.0
         */
        public Result getValueSpecifyCell(
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator
        )  {
            if (row == null) return null;
            
            if (rowOperator == null) return null;
            
            if (column == null) return null;
            
            if (columnOperator == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcReadValue")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(row)
                            .addParameter(rowOperator.rcValue())
                            .addParameter(column)
                            .addParameter(columnOperator.rcValue())
                            .build(), null);
        }
        
        
        /**
         * Use this action to read the value in the cell where the mouse is currently placed so that you can use the value in the cell as data for other Test Steps
         * @since 4.0
         */
        public Result getValueAtMousePosition(
        )  {
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcReadValueAtMousePosition")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .build(), null);
        }
        
        /**
         * 
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * 
         */
        public Result dragCell(
            @Nullable InteractionMode mouseButton,
            @Nullable Modifier[] modifierKeys,
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits
        )  {
            if (mouseButton == null) return null;
            
            if (modifierKeys == null) return null;
            
            if (row == null) return null;
            
            if (rowOperator == null) return null;
            
            if (column == null) return null;
            
            if (columnOperator == null) return null;
            
            if (xPosition == null) return null;
            
            if (xUnits == null) return null;
            
            if (yPosition == null) return null;
            
            if (yUnits == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcDragCell")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(StringUtils.join(modifierKeys, TestDataConstants.COMBI_VALUE_SEPARATOR))
                            .addParameter(row)
                            .addParameter(rowOperator.rcValue())
                            .addParameter(column)
                            .addParameter(columnOperator.rcValue())
                            .addParameter(xPosition)
                            .addParameter(xUnits.rcValue())
                            .addParameter(yPosition)
                            .addParameter(yUnits.rcValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * 
         */
        public Result dropOnCell(
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable Integer delayBeforeDropMilliseconds
        )  {
            if (row == null) return null;
            
            if (rowOperator == null) return null;
            
            if (column == null) return null;
            
            if (columnOperator == null) return null;
            
            if (xPosition == null) return null;
            
            if (xUnits == null) return null;
            
            if (yPosition == null) return null;
            
            if (yUnits == null) return null;
            
            if (delayBeforeDropMilliseconds == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcDropCell")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(row)
                            .addParameter(rowOperator.rcValue())
                            .addParameter(column)
                            .addParameter(columnOperator.rcValue())
                            .addParameter(xPosition)
                            .addParameter(xUnits.rcValue())
                            .addParameter(yPosition)
                            .addParameter(yUnits.rcValue())
                            .addParameter(delayBeforeDropMilliseconds)
                            .build(), null);
        }
        
        /**
         * 
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * 
         */
        public Result dragCellFromColumn(
            @Nullable InteractionMode mouseButton,
            @Nullable Modifier[] modifierKeys,
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable SearchType searchType
        )  {
            if (mouseButton == null) return null;
            
            if (modifierKeys == null) return null;
            
            if (column == null) return null;
            
            if (columnOperator == null) return null;
            
            if (value == null) return null;
            
            if (valueOperator == null) return null;
            
            if (searchType == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcDragRowByValue")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(StringUtils.join(modifierKeys, TestDataConstants.COMBI_VALUE_SEPARATOR))
                            .addParameter(column)
                            .addParameter(columnOperator.rcValue())
                            .addParameter(value)
                            .addParameter(valueOperator.rcValue())
                            .addParameter(searchType.rcValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * 
         */
        public Result dropOnCellFromColumn(
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable SearchType searchType,
            @Nullable Integer delayBeforeDropMilliseconds
        )  {
            if (column == null) return null;
            
            if (columnOperator == null) return null;
            
            if (value == null) return null;
            
            if (valueOperator == null) return null;
            
            if (searchType == null) return null;
            
            if (delayBeforeDropMilliseconds == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcDropRowByValue")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(column)
                            .addParameter(columnOperator.rcValue())
                            .addParameter(value)
                            .addParameter(valueOperator.rcValue())
                            .addParameter(searchType.rcValue())
                            .addParameter(delayBeforeDropMilliseconds)
                            .build(), null);
        }
        
        /**
         * 
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * 
         */
        public Result dragCellFromRow(
            @Nullable InteractionMode mouseButton,
            @Nullable Modifier[] modifierKeys,
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable SearchType searchType
        )  {
            if (mouseButton == null) return null;
            
            if (modifierKeys == null) return null;
            
            if (row == null) return null;
            
            if (rowOperator == null) return null;
            
            if (value == null) return null;
            
            if (valueOperator == null) return null;
            
            if (searchType == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcDragCellByColValue")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(StringUtils.join(modifierKeys, TestDataConstants.COMBI_VALUE_SEPARATOR))
                            .addParameter(row)
                            .addParameter(rowOperator.rcValue())
                            .addParameter(value)
                            .addParameter(valueOperator.rcValue())
                            .addParameter(searchType.rcValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * 
         */
        public Result dropOnCellFromRow(
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable SearchType searchType,
            @Nullable Integer delayBeforeDropMilliseconds
        )  {
            if (row == null) return null;
            
            if (rowOperator == null) return null;
            
            if (value == null) return null;
            
            if (valueOperator == null) return null;
            
            if (searchType == null) return null;
            
            if (delayBeforeDropMilliseconds == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcDropCellByColValue")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(row)
                            .addParameter(rowOperator.rcValue())
                            .addParameter(value)
                            .addParameter(valueOperator.rcValue())
                            .addParameter(searchType.rcValue())
                            .addParameter(delayBeforeDropMilliseconds)
                            .build(), null);
        }
        
        /**
         * 
         * @param checked 
         *        Checked
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkSelectionOfCheckboxInSelectedRow(
            @Nullable Boolean checked,
            @Nullable Integer timeoutInMs
        )  {
            if (checked == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyCheckboxInSelectedRow")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(checked)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param checked 
         *        Checked
         * @since 4.1
         */
        public Result checkSelectionOfCheckboxInSelectedRow(
            @Nullable Boolean checked
        )  {
            if (checked == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyCheckboxInSelectedRow")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(checked)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param checked 
         *        Checked
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkSelectionOfCheckboxAtMousePosition(
            @Nullable Boolean checked,
            @Nullable Integer timeoutInMs
        )  {
            if (checked == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyCheckboxInRowAtMousePosition")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(checked)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param checked 
         *        Checked
         * @since 4.1
         */
        public Result checkSelectionOfCheckboxAtMousePosition(
            @Nullable Boolean checked
        )  {
            if (checked == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyCheckboxInRowAtMousePosition")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(checked)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * 
         */
        public Result toggleCheckboxInSelectedRow(
        )  {
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcToggleCheckboxInSelectedRow")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .build(), null);
        }
        
        /**
         * 
         * 
         */
        public Result toggleCheckboxAtMousePosition(
        )  {
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcToggleCheckboxInRowAtMousePosition")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .build(), null);
        }
        
        /**
         * 
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkPropertyAtMousePosition(
            @Nullable String propertyName,
            @Nullable String propertyValue,
            @Nullable Operator operator,
            @Nullable Integer timeoutInMs
        )  {
            if (propertyName == null) return null;
            
            if (propertyValue == null) return null;
            
            if (operator == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckPropertyAtMousePosition")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(propertyName)
                            .addParameter(propertyValue)
                            .addParameter(operator.rcValue())
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param operator 
         *        the operator used for comparison
         * @since 4.1
         */
        public Result checkPropertyAtMousePosition(
            @Nullable String propertyName,
            @Nullable String propertyValue,
            @Nullable Operator operator
        )  {
            if (propertyName == null) return null;
            
            if (propertyValue == null) return null;
            
            if (operator == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckPropertyAtMousePosition")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(propertyName)
                            .addParameter(propertyValue)
                            .addParameter(operator.rcValue())
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 5.0
         */
        public Result checkExistenceOfAColumn(
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable Boolean exists,
            @Nullable Integer timeoutInMs
        )  {
            if (column == null) return null;
            
            if (columnOperator == null) return null;
            
            if (exists == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckExistenceOfColumn")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(column)
                            .addParameter(columnOperator.rcValue())
                            .addParameter(exists)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param exists 
         *        whether existence is expected or not
         * @since 5.0
         */
        public Result checkExistenceOfAColumn(
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable Boolean exists
        )  {
            if (column == null) return null;
            
            if (columnOperator == null) return null;
            
            if (exists == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckExistenceOfColumn")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(column)
                            .addParameter(columnOperator.rcValue())
                            .addParameter(exists)
                            .addParameter(0)
                            .build(), null);
        }
        
} 