import { TextDocument, Position, CompletionItem } from 'vscode-languageserver-types';
import { DockerRegistryClient } from './dockerRegistryClient';
export declare class DockerAssist {
    private snippetSupport;
    private deprecatedSupport;
    private document;
    /**
     * The client for communicating with a Docker registry.
     */
    private dockerRegistryClient;
    /**
     * Creates a content assist processor for suggesting completion items related to a Dockerfile.
     *
     * @param document the text document to provide suggestions for
     * @param dockerRegistryClient the client for communicating with a Docker registry
     * @param snippetSupport true if snippets are supported by the client, false otherwise
     * @param deprecatedSupport true if the client supports the deprecated property on a completion item
     */
    constructor(document: TextDocument, dockerRegistryClient: DockerRegistryClient, snippetSupport: boolean, deprecatedSupport: boolean);
    computeProposals(position: Position): CompletionItem[] | PromiseLike<CompletionItem[]>;
    createProposals(keywords: string[], previousWord: string, prefixLength: number, offset: number): CompletionItem[];
    private createAddProposals(add, position, offset, prefix);
    private createCopyProposals(dockerfile, copy, position, offset, prefix);
    private createFromProposals(from, position, prefix);
    private createHealthcheckProposals(offset, prefix);
    /**
    * Walks back in the text buffer to calculate the true prefix of the
    * current text caret offset. This function will handle the
    * Dockerfile escape characters to skip escaped newline characters
    * where applicable.
    *
    * @param buffer the content of the opened file
    * @param offset the current text caret's offset
    * @param escapeCharacter the escape character defined in this Dockerfile
    */
    private static calculateTruePrefix(buffer, offset, escapeCharacter);
    createSingleProposals(keyword: string, prefixLength: number, offset: number): CompletionItem;
    createADD(prefixLength: number, offset: number, markdown: string): CompletionItem;
    private createARG(prefixLength, offset);
    createARG_NameOnly(prefixLength: number, offset: number): CompletionItem;
    createARG_DefaultValue(prefixLength: number, offset: number): CompletionItem;
    createCMD(prefixLength: number, offset: number, markdown: string): CompletionItem;
    createCOPY(prefixLength: number, offset: number, markdown: string): CompletionItem;
    createENTRYPOINT(prefixLength: number, offset: number, markdown: string): CompletionItem;
    createENV(prefixLength: number, offset: number, markdown: string): CompletionItem;
    createEXPOSE(prefixLength: number, offset: number, markdown: string): CompletionItem;
    createFROM(prefixLength: number, offset: number, markdown: string): CompletionItem;
    createHEALTHCHECK_CMD(prefixLength: number, offset: number): CompletionItem;
    private createHEALTHCHECK_CMD_Subcommand(prefixLength, offset);
    private createADD_FlagChown(prefixLength, offset);
    private createCOPY_FlagChown(prefixLength, offset);
    private createCOPY_FlagFrom(prefixLength, offset);
    private createHEALTHCHECK_FlagInterval(prefixLength, offset);
    private createHEALTHCHECK_FlagRetries(prefixLength, offset);
    private createHEALTHCHECK_FlagStartPeriod(prefixLength, offset);
    private createHEALTHCHECK_FlagTimeout(prefixLength, offset);
    createHEALTHCHECK_NONE(prefixLength: number, offset: number): CompletionItem;
    private createHEALTHCHECK_NONE_Subcommand(prefixLength, offset);
    createLABEL(prefixLength: number, offset: number, markdown: string): CompletionItem;
    createMAINTAINER(prefixLength: number, offset: number, markdown: string): CompletionItem;
    createONBUILD(prefixLength: number, offset: number, markdown: string): CompletionItem;
    createRUN(prefixLength: number, offset: number, markdown: string): CompletionItem;
    createSHELL(prefixLength: number, offset: number, markdown: string): CompletionItem;
    createSTOPSIGNAL(prefixLength: number, offset: number, markdown: string): CompletionItem;
    createUSER(prefixLength: number, offset: number, markdown: string): CompletionItem;
    createVOLUME(prefixLength: number, offset: number, markdown: string): CompletionItem;
    createWORKDIR(prefixLength: number, offset: number, markdown: string): CompletionItem;
    createEscape(prefixLength: number, offset: number, markdown: string): CompletionItem;
    createKeywordCompletionItem(keyword: string, label: string, prefixLength: number, offset: number, insertText: string, markdown: string): CompletionItem;
    private createPlainTextCompletionItem(label, prefixLength, offset, insertText, markdown);
    private createFlagCompletionItem(label, prefixLength, offset, insertText, markdown);
    private createSourceImageCompletionItem(label, documentation, buildIndex, prefixLength, offset);
    private createVariableCompletionItem(text, prefixLength, offset, brace, documentation);
    private createTextEdit(prefixLength, offset, content);
}
