/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.graphing.ui.charts.listeners;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.Chart;

public abstract class AbstractChartMouseMoveListener
implements MouseMoveListener {
    protected final Chart chart;
    protected MouseEvent lastMouseEvent = null;

    public AbstractChartMouseMoveListener(Chart chart, final Composite hoverArea) {
        this.chart = chart;
        final AbstractChartMouseMoveListener thisListener = this;
        hoverArea.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                hoverArea.removeMouseMoveListener(thisListener);
                AbstractChartMouseMoveListener.this.exit();
            }

            public void mouseEnter(MouseEvent e) {
                hoverArea.addMouseMoveListener(thisListener);
            }
        });
    }

    public void exit() {
        this.lastMouseEvent = null;
    }

    public final void update() {
        if (this.lastMouseEvent != null) {
            this.mouseMove(this.lastMouseEvent);
        }
    }

    public void mouseMove(MouseEvent e) {
        this.lastMouseEvent = e;
    }

    public String getMouseMessage() {
        return "";
    }
}

