/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.util;

import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.ui.Messages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class SearchOnTyping {
    private static final int SELECTION_LIMIT = 1000;

    public static final void attachTo(Table table, ITableLabelProvider labelProvider, int columnIndex) {
        table.addKeyListener((KeyListener)new SearchKeyListener(new TableImpl(table, labelProvider, columnIndex)));
    }

    public static final void attachTo(Tree tree, ITableLabelProvider labelProvider, int columnIndex) {
        tree.addKeyListener((KeyListener)new SearchKeyListener(new TreeImpl(tree, labelProvider, columnIndex)));
    }

    public static final void attachTo(Control control, int columnIndex) {
        if (control instanceof Tree) {
            control.addKeyListener((KeyListener)new SearchKeyListener(new TreeImpl((Tree)control, null, columnIndex)));
        } else if (control instanceof Table) {
            control.addKeyListener((KeyListener)new SearchKeyListener(new TableImpl((Table)control, null, columnIndex)));
        } else {
            throw new RuntimeException(String.valueOf(Messages.SearchOnTyping_Exception) + control.getClass().getName());
        }
    }

    private SearchOnTyping() {
    }

    private static class SearchJob
    extends Job {
        SearchThingy thingy;
        String text;
        Text filterText;

        private SearchJob(SearchThingy thingy, String text, Text filterText) {
            super(Messages.SearchOnTyping_searching);
            this.setSystem(true);
            this.thingy = thingy;
            this.text = text;
            this.filterText = filterText;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (!this.filterText.isDisposed()) {
                this.filterText.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (SearchJob.this.filterText.isDisposed()) {
                            return;
                        }
                        String t = SearchJob.this.filterText.getText();
                        if (SearchJob.this.text.equals(t)) {
                            SearchJob.this.thingy.select(SearchJob.this.text.toLowerCase());
                        }
                    }
                });
            }
            return Status.OK_STATUS;
        }
    }

    private static final class SearchKeyListener
    implements KeyListener {
        SearchThingy thingy;

        public SearchKeyListener(SearchThingy thingy) {
            this.thingy = thingy;
        }

        public void keyPressed(KeyEvent e) {
            if (!Character.isISOControl(e.character) && e.character != ' ' && (e.stateMask & (SWT.MOD1 | SWT.MOD3)) == 0 && e.keyCode != 16777259 && e.keyCode != 16777261 && e.keyCode != 16777258 && e.keyCode != 16777263) {
                SearchPopup search = new SearchPopup(this.thingy, Character.toString(e.character));
                search.open();
                e.doit = false;
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    private static class SearchPopup
    extends PopupDialog {
        SearchThingy thingy;
        String initialPattern;
        Text filterText;

        private SearchPopup(SearchThingy thingy, String initialPattern) {
            super(thingy.getControl().getShell(), 16, true, false, false, false, null, null);
            this.thingy = thingy;
            this.initialPattern = initialPattern;
        }

        protected Point getInitialLocation(Point initialSize) {
            Control control = this.thingy.getControl();
            Point location = control.getShell().getDisplay().map(control, null, control.getLocation());
            return new Point(location.x, location.y);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.filterText = new Text(composite, 0);
            this.filterText.setText(this.initialPattern);
            this.filterText.setSelection(this.initialPattern.length());
            GC gc = new GC((Drawable)parent);
            gc.setFont(parent.getFont());
            FontMetrics fontMetrics = gc.getFontMetrics();
            gc.dispose();
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(100, Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)1)).applyTo((Control)this.filterText);
            this.filterText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SearchPopup.this.searchChanged();
                }
            });
            this.searchChanged();
            return composite;
        }

        protected Control getFocusControl() {
            return this.filterText;
        }

        private void searchChanged() {
            String text = this.filterText.getText().trim();
            if (text.length() < 3) {
                this.thingy.deselectAll();
            } else {
                new SearchJob(this.thingy, text, this.filterText).schedule(250L);
            }
        }
    }

    private static interface SearchThingy {
        public Control getControl();

        public void deselectAll();

        public void select(String var1);
    }

    private static final class TableImpl
    implements SearchThingy {
        Table table;
        ITableLabelProvider labelProvider;
        int columnIndex;

        private TableImpl(Table t, ITableLabelProvider labelProvider, int columnIndex) {
            this.table = t;
            this.labelProvider = labelProvider;
            this.columnIndex = columnIndex;
        }

        public Control getControl() {
            return this.table;
        }

        public void deselectAll() {
            this.table.deselectAll();
        }

        public void select(String pattern) {
            ArrayInt selected = new ArrayInt();
            int itemCount = this.table.getItemCount();
            int ii = 0;
            while (ii < itemCount) {
                Object data;
                if (selected.size() > 1000) break;
                TableItem item = this.table.getItem(ii);
                String text = null;
                text = this.labelProvider != null ? ((data = item.getData()) != null ? this.labelProvider.getColumnText(data, this.columnIndex) : null) : item.getText(this.columnIndex);
                if (text != null && (text = text.toLowerCase()).indexOf(pattern) >= 0) {
                    selected.add(ii);
                }
                ++ii;
            }
            this.table.setSelection(selected.toArray());
        }
    }

    private static final class TreeImpl
    implements SearchThingy {
        Tree tree;
        ITableLabelProvider labelProvider;
        int columnIndex;

        private TreeImpl(Tree tree, ITableLabelProvider labelProvider, int columnIndex) {
            this.tree = tree;
            this.labelProvider = labelProvider;
            this.columnIndex = columnIndex;
        }

        public void deselectAll() {
            this.tree.deselectAll();
        }

        public Control getControl() {
            return this.tree;
        }

        public void select(String pattern) {
            ArrayList<TreeItem> items = new ArrayList<TreeItem>();
            LinkedList<TreeItem> stack = new LinkedList<TreeItem>();
            int ii = 0;
            while (ii < this.tree.getItemCount()) {
                stack.add(this.tree.getItem(ii));
                ++ii;
            }
            while (!stack.isEmpty()) {
                Object data;
                if (items.size() > 1000) {
                    return;
                }
                TreeItem item = (TreeItem)stack.removeFirst();
                String text = null;
                text = this.labelProvider != null ? ((data = item.getData()) != null ? this.labelProvider.getColumnText(data, this.columnIndex) : null) : item.getText(this.columnIndex);
                if (text != null && (text = text.toLowerCase()).indexOf(pattern) >= 0) {
                    items.add(item);
                }
                if (!item.getExpanded()) continue;
                int itemCount = item.getItemCount();
                int ii2 = 0;
                while (ii2 < itemCount) {
                    stack.add(item.getItem(ii2));
                    ++ii2;
                }
            }
            this.tree.setSelection(items.toArray(new TreeItem[0]));
        }
    }
}

