/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.mylyn.internal.trac.core.Messages;
import org.eclipse.mylyn.internal.trac.core.TracAttributeMapper;
import org.eclipse.mylyn.internal.trac.core.model.TracTicket;

public enum TracAttribute {
    CC(TracTicket.Key.CC, Messages.TracAttribute_CC, "task.common.user.cc", "shortText", TracAttributeMapper.Flag.PEOPLE, new TracAttributeMapper.Flag[0]),
    CHANGE_TIME(TracTicket.Key.CHANGE_TIME, Messages.TracAttribute_Last_Modification, "task.common.date.modified", "date", TracAttributeMapper.Flag.READ_ONLY, new TracAttributeMapper.Flag[0]),
    COMPONENT(TracTicket.Key.COMPONENT, Messages.TracAttribute_Component, "task.common.product", "singleSelect", TracAttributeMapper.Flag.ATTRIBUTE, new TracAttributeMapper.Flag[0]),
    DESCRIPTION(TracTicket.Key.DESCRIPTION, Messages.TracAttribute_Description, "task.common.description", "longRichText"),
    ID(TracTicket.Key.ID, Messages.TracAttribute_ID, "task.common.key", "shortText", TracAttributeMapper.Flag.PEOPLE, new TracAttributeMapper.Flag[0]),
    KEYWORDS(TracTicket.Key.KEYWORDS, Messages.TracAttribute_Keywords, "task.common.keywords", "shortText", TracAttributeMapper.Flag.ATTRIBUTE, new TracAttributeMapper.Flag[0]),
    MILESTONE(TracTicket.Key.MILESTONE, Messages.TracAttribute_Milestone, null, "singleSelect", TracAttributeMapper.Flag.ATTRIBUTE, new TracAttributeMapper.Flag[0]),
    OWNER(TracTicket.Key.OWNER, Messages.TracAttribute_Assigned_to, "task.common.user.assigned", "person", TracAttributeMapper.Flag.PEOPLE, new TracAttributeMapper.Flag[0]),
    PRIORITY(TracTicket.Key.PRIORITY, Messages.TracAttribute_Priority, "task.common.priority", "singleSelect", TracAttributeMapper.Flag.ATTRIBUTE, new TracAttributeMapper.Flag[0]),
    REPORTER(TracTicket.Key.REPORTER, Messages.TracAttribute_Reporter, "task.common.user.reporter", "person", TracAttributeMapper.Flag.READ_ONLY, new TracAttributeMapper.Flag[0]),
    RESOLUTION(TracTicket.Key.RESOLUTION, Messages.TracAttribute_Resolution, "task.common.resolution", "singleSelect"),
    SEVERITY(TracTicket.Key.SEVERITY, Messages.TracAttribute_Severity, null, "singleSelect", TracAttributeMapper.Flag.ATTRIBUTE, new TracAttributeMapper.Flag[0]),
    STATUS(TracTicket.Key.STATUS, Messages.TracAttribute_Status, "task.common.status", "shortText"),
    SUMMARY(TracTicket.Key.SUMMARY, Messages.TracAttribute_Summary, "task.common.summary", "shortRichText"),
    TIME(TracTicket.Key.TIME, Messages.TracAttribute_Created, "task.common.date.created", "date", TracAttributeMapper.Flag.READ_ONLY, new TracAttributeMapper.Flag[0]),
    TYPE(TracTicket.Key.TYPE, Messages.TracAttribute_Type, "task.common.kind", "singleSelect", TracAttributeMapper.Flag.ATTRIBUTE, new TracAttributeMapper.Flag[0]),
    VERSION(TracTicket.Key.VERSION, Messages.TracAttribute_Version, null, "singleSelect", TracAttributeMapper.Flag.ATTRIBUTE, new TracAttributeMapper.Flag[0]),
    TOKEN(TracTicket.Key.TOKEN, "Update Token", null, "shortText", TracAttributeMapper.Flag.READ_ONLY, new TracAttributeMapper.Flag[0]);

    static Map<String, TracAttribute> attributeByTracKey;
    static Map<String, String> tracKeyByTaskKey;
    private final String tracKey;
    private final String prettyName;
    private final String taskKey;
    private final String type;
    private EnumSet<TracAttributeMapper.Flag> flags;

    static {
        attributeByTracKey = new HashMap<String, TracAttribute>();
        tracKeyByTaskKey = new HashMap<String, String>();
    }

    public static TracAttribute getByTaskKey(String taskKey) {
        TracAttribute[] tracAttributeArray = TracAttribute.values();
        int n = tracAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TracAttribute attribute = tracAttributeArray[n2];
            if (taskKey.equals(attribute.getTaskKey())) {
                return attribute;
            }
            ++n2;
        }
        return null;
    }

    public static TracAttribute getByTracKey(String tracKey) {
        TracAttribute[] tracAttributeArray = TracAttribute.values();
        int n = tracAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TracAttribute attribute = tracAttributeArray[n2];
            if (tracKey.equals(attribute.getTracKey())) {
                return attribute;
            }
            ++n2;
        }
        return null;
    }

    private TracAttribute(TracTicket.Key tracKey, String prettyName, String taskKey, String type, TracAttributeMapper.Flag firstFlag, TracAttributeMapper.Flag ... moreFlags) {
        this.tracKey = tracKey.getKey();
        this.taskKey = taskKey;
        this.prettyName = prettyName;
        this.type = type;
        this.flags = firstFlag == null ? TracAttributeMapper.NO_FLAGS : EnumSet.of(firstFlag, moreFlags);
    }

    private TracAttribute(TracTicket.Key tracKey, String prettyName, String taskKey, String type) {
        this(tracKey, prettyName, taskKey, type, null, new TracAttributeMapper.Flag[0]);
    }

    public String getTaskKey() {
        return this.taskKey;
    }

    public String getTracKey() {
        return this.tracKey;
    }

    public String getKind() {
        if (this.flags.contains((Object)TracAttributeMapper.Flag.ATTRIBUTE)) {
            return "task.common.kind.default";
        }
        if (this.flags.contains((Object)TracAttributeMapper.Flag.PEOPLE)) {
            return "task.common.kind.people";
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public boolean isReadOnly() {
        return this.flags.contains((Object)TracAttributeMapper.Flag.READ_ONLY);
    }

    public String toString() {
        return this.prettyName;
    }
}

