/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.dnd;

import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DNDDropAdapter<TYPE>
extends ViewerDropAdapter {
    private Transfer[] transfers;
    private boolean dropBetweenEnabled;

    protected DNDDropAdapter(Transfer[] transfers, StructuredViewer viewer) {
        super((Viewer)viewer);
        this.transfers = transfers;
    }

    protected DNDDropAdapter(StructuredViewer viewer) {
        super((Viewer)viewer);
    }

    public Transfer[] getTransfers() {
        return this.transfers;
    }

    protected void setTransfers(Transfer[] transfers) {
        this.transfers = transfers;
    }

    public StructuredViewer getViewer() {
        return (StructuredViewer)super.getViewer();
    }

    public boolean isDropBetweenEnabled() {
        return this.dropBetweenEnabled;
    }

    public void setDropBetweenEnabled(boolean dropBetweenEnabled) {
        this.dropBetweenEnabled = dropBetweenEnabled;
    }

    protected int determineLocation(DropTargetEvent event) {
        int location = super.determineLocation(event);
        if (!(location != 1 && location != 2 || this.dropBetweenEnabled)) {
            location = 3;
        }
        return location;
    }

    public boolean performDrop(Object data) {
        Object target = this.getCurrentTarget();
        if (target == null) {
            target = this.getViewer().getInput();
        }
        return this.performDrop(data, target);
    }

    public boolean validateDrop(Object target, int operation, TransferData type) {
        if (target != null && !this.validateTarget(target, operation)) {
            return false;
        }
        return this.validateTransfer(type);
    }

    protected boolean validateTransfer(TransferData type) {
        Transfer[] transferArray = this.getTransfers();
        int n = transferArray.length;
        int n2 = 0;
        while (n2 < n) {
            Transfer transfer = transferArray[n2];
            if (transfer.isSupportedType(type)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected abstract boolean validateTarget(Object var1, int var2);

    protected abstract boolean performDrop(TYPE var1, Object var2);
}

