/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.dnd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.net4j.util.internal.ui.bundle.OM;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DNDTransfer<TYPE>
extends ByteArrayTransfer {
    private String typeName;
    private int typeID;

    protected DNDTransfer(String typeName) {
        this.typeName = typeName;
        this.typeID = DNDTransfer.registerType((String)typeName);
    }

    protected int[] getTypeIds() {
        return new int[]{this.typeID};
    }

    protected String[] getTypeNames() {
        return new String[]{this.typeName};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ExtendedDataOutputStream out = new ExtendedDataOutputStream((OutputStream)baos);
        byte[] bytes = null;
        try {
            Object typed = object;
            this.writeObject(out, typed);
            out.close();
            bytes = baos.toByteArray();
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
        }
        if (bytes != null) {
            super.javaToNative((Object)bytes, transferData);
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ExtendedDataInputStream in = new ExtendedDataInputStream((InputStream)bais);
        try {
            return this.readObject(in);
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
            return null;
        }
    }

    protected abstract void writeObject(ExtendedDataOutputStream var1, TYPE var2) throws IOException;

    protected abstract TYPE readObject(ExtendedDataInputStream var1) throws IOException;
}

