/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.mylyn.impl;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.IBuildServer;
import org.eclipse.mylyn.builds.internal.core.BuildFactory;
import org.eclipse.mylyn.builds.internal.core.BuildModel;
import org.eclipse.mylyn.builds.ui.BuildsUi;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationCredentials;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationType;
import org.eclipse.mylyn.commons.repositories.core.auth.UserCredentials;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiInternal;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiPlugin;
import org.eclipse.oomph.preferences.util.PreferencesUtil;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.setup.mylyn.BuildPlan;
import org.eclipse.oomph.setup.mylyn.MylynBuildsTask;
import org.eclipse.oomph.setup.mylyn.MylynPackage;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.util.UserCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MylynBuildsTaskImpl
extends SetupTaskImpl
implements MylynBuildsTask {
    protected static final String CONNECTOR_KIND_EDEFAULT = "org.eclipse.mylyn.hudson";
    protected String connectorKind = "org.eclipse.mylyn.hudson";
    protected static final String SERVER_URL_EDEFAULT = null;
    protected String serverURL = SERVER_URL_EDEFAULT;
    protected static final String USER_ID_EDEFAULT = null;
    protected String userID = USER_ID_EDEFAULT;
    protected static final String PASSWORD_EDEFAULT = null;
    protected String password = PASSWORD_EDEFAULT;
    protected EList<BuildPlan> buildPlans;

    protected MylynBuildsTaskImpl() {
    }

    protected EClass eStaticClass() {
        return MylynPackage.Literals.MYLYN_BUILDS_TASK;
    }

    @Override
    public String getConnectorKind() {
        return this.connectorKind;
    }

    @Override
    public void setConnectorKind(String newConnectorKind) {
        String oldConnectorKind = this.connectorKind;
        this.connectorKind = newConnectorKind;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldConnectorKind, (Object)this.connectorKind));
        }
    }

    @Override
    public String getServerURL() {
        return this.serverURL;
    }

    @Override
    public void setServerURL(String newServerURL) {
        String oldServerURL = this.serverURL;
        this.serverURL = newServerURL;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldServerURL, (Object)this.serverURL));
        }
    }

    @Override
    public EList<BuildPlan> getBuildPlans() {
        if (this.buildPlans == null) {
            this.buildPlans = new EObjectContainmentEList(BuildPlan.class, (InternalEObject)this, 14);
        }
        return this.buildPlans;
    }

    @Override
    public String getUserID() {
        return this.userID;
    }

    @Override
    public void setUserID(String newUserID) {
        String oldUserID = this.userID;
        this.userID = newUserID;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldUserID, (Object)this.userID));
        }
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String newPassword) {
        String oldPassword = this.password;
        this.password = newPassword;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldPassword, (Object)this.password));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 14: {
                return ((InternalEList)this.getBuildPlans()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.getConnectorKind();
            }
            case 11: {
                return this.getServerURL();
            }
            case 12: {
                return this.getUserID();
            }
            case 13: {
                return this.getPassword();
            }
            case 14: {
                return this.getBuildPlans();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.setConnectorKind((String)newValue);
                return;
            }
            case 11: {
                this.setServerURL((String)newValue);
                return;
            }
            case 12: {
                this.setUserID((String)newValue);
                return;
            }
            case 13: {
                this.setPassword((String)newValue);
                return;
            }
            case 14: {
                this.getBuildPlans().clear();
                this.getBuildPlans().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.setConnectorKind(CONNECTOR_KIND_EDEFAULT);
                return;
            }
            case 11: {
                this.setServerURL(SERVER_URL_EDEFAULT);
                return;
            }
            case 12: {
                this.setUserID(USER_ID_EDEFAULT);
                return;
            }
            case 13: {
                this.setPassword(PASSWORD_EDEFAULT);
                return;
            }
            case 14: {
                this.getBuildPlans().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return CONNECTOR_KIND_EDEFAULT == null ? this.connectorKind != null : !CONNECTOR_KIND_EDEFAULT.equals(this.connectorKind);
            }
            case 11: {
                return SERVER_URL_EDEFAULT == null ? this.serverURL != null : !SERVER_URL_EDEFAULT.equals(this.serverURL);
            }
            case 12: {
                return USER_ID_EDEFAULT == null ? this.userID != null : !USER_ID_EDEFAULT.equals(this.userID);
            }
            case 13: {
                return PASSWORD_EDEFAULT == null ? this.password != null : !PASSWORD_EDEFAULT.equals(this.password);
            }
            case 14: {
                return this.buildPlans != null && !this.buildPlans.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (connectorKind: ");
        result.append(this.connectorKind);
        result.append(", serverURL: ");
        result.append(this.serverURL);
        result.append(", userID: ");
        result.append(this.userID);
        result.append(", password: ");
        result.append(this.password);
        result.append(')');
        return result.toString();
    }

    public boolean isNeeded(SetupTaskContext context) throws Exception {
        UserCredentials credentials;
        IBuildServer server = this.getServer();
        if (server == null) {
            return true;
        }
        if (this.isAuthenticate() && ((credentials = (UserCredentials)server.getLocation().getCredentials(AuthenticationType.REPOSITORY)) == null || !ObjectUtil.equals((Object)credentials.getPassword(), (Object)PreferencesUtil.decrypt((String)this.getPassword())))) {
            return true;
        }
        return !this.getMissingBuildPlans(server).isEmpty();
    }

    public void perform(final SetupTaskContext context) throws Exception {
        UserCallback callback = context.getPrompter().getUserCallback();
        callback.execInUI(false, new Runnable(){

            public void run() {
                BuildModel buildModel = BuildsUiInternal.getModel();
                String connectorKind = MylynBuildsTaskImpl.this.getConnectorKind();
                IBuildServer server = MylynBuildsTaskImpl.this.getServer();
                String password = PreferencesUtil.decrypt((String)MylynBuildsTaskImpl.this.getPassword());
                if (server != null) {
                    if (MylynBuildsTaskImpl.this.isAuthenticate()) {
                        UserCredentials credentials = new UserCredentials(MylynBuildsTaskImpl.this.userID, password, true);
                        server.getLocation().setCredentials(AuthenticationType.REPOSITORY, (AuthenticationCredentials)credentials);
                    }
                } else {
                    String serverURL = MylynBuildsTaskImpl.this.getServerURL();
                    String userID = MylynBuildsTaskImpl.this.getUserID();
                    context.log("Adding " + connectorKind + " server: " + serverURL);
                    server = BuildsUi.createServer((String)connectorKind);
                    server.setUrl(serverURL);
                    server.getAttributes().put("id", serverURL);
                    server.getAttributes().put("url", serverURL);
                    boolean authenticate = MylynBuildsTaskImpl.this.isAuthenticate();
                    if (authenticate) {
                        server.getAttributes().put("org.eclipse.mylyn.tasklist.repositories.enabled", "true");
                        server.getAttributes().put("org.eclipse.mylyn.repositories.username", userID);
                    }
                    RepositoryLocation repositoryLocation = new RepositoryLocation(server.getAttributes());
                    repositoryLocation.setUrl(serverURL);
                    if (authenticate) {
                        UserCredentials credentials = new UserCredentials(userID, password, true);
                        repositoryLocation.setCredentials(AuthenticationType.REPOSITORY, (AuthenticationCredentials)credentials);
                    }
                    repositoryLocation.setProxy(null);
                    server.setLocation(repositoryLocation);
                    buildModel.getServers().add(server);
                }
                Set buildPlanNames = MylynBuildsTaskImpl.this.getMissingBuildPlans(server);
                for (String buildPlanName : buildPlanNames) {
                    context.log("Adding " + connectorKind + " build plan: " + buildPlanName);
                    IBuildPlan buildPlan = BuildFactory.eINSTANCE.createBuildPlan();
                    buildPlan.setId(buildPlanName);
                    buildPlan.setName(buildPlanName);
                    buildPlan.setServer(server);
                    buildPlan.setSelected(true);
                    buildModel.getPlans().add(buildPlan);
                }
                BuildsUiPlugin.getDefault().refreshBuilds();
            }
        });
    }

    private boolean isAuthenticate() {
        return !StringUtil.isEmpty((String)this.userID) && !"anonymous".equals(this.userID) && !StringUtil.isEmpty((String)this.password) && !" ".equals(this.password);
    }

    private Set<String> getMissingBuildPlans(IBuildServer server) {
        LinkedHashSet<String> buildPlanNames = new LinkedHashSet<String>();
        for (BuildPlan buildPlan : this.getBuildPlans()) {
            buildPlanNames.add(buildPlan.getName());
        }
        for (BuildPlan buildPlan : BuildsUi.getModel().getPlans()) {
            if (buildPlan.getServer() != server) continue;
            buildPlanNames.remove(buildPlan.getName());
        }
        return buildPlanNames;
    }

    private IBuildServer getServer() {
        String serverURL = this.getServerURL();
        String userID = this.getUserID();
        String connectorKind = this.getConnectorKind();
        for (IBuildServer server : BuildsUi.getModel().getServers()) {
            if (!ObjectUtil.equals((Object)server.getUrl(), (Object)serverURL) || !ObjectUtil.equals((Object)server.getConnectorKind(), (Object)connectorKind) || this.isAuthenticate() && !userID.equals(server.getAttributes().get("org.eclipse.mylyn.repositories.username"))) continue;
            return server;
        }
        return null;
    }
}

