/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.util;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class PopupButtonMenu {
    private final Button button;
    private MenuManager menu;

    public PopupButtonMenu(Button button) {
        this.button = button;
        this.initialize();
    }

    public void addAction(IAction action) {
        this.menu.add(action);
    }

    private void initialize() {
        this.menu = new MenuManager();
        this.button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (PopupButtonMenu.this.menu != null) {
                    PopupButtonMenu.this.menu.dispose();
                    PopupButtonMenu.this.menu = null;
                }
            }
        });
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PopupButtonMenu.this.showMenu(e.x, e.y);
            }
        });
    }

    private void showMenu(int x, int y) {
        if (this.menu != null) {
            Menu menu = this.menu.createContextMenu((Control)this.button);
            menu.setLocation(this.button.toDisplay(x, y));
            menu.setVisible(true);
        }
    }
}

